<?php

/**
 * OptionsForm class.
 * OptionsForm is the data structure for keeping
 */
class OptionsForm extends CFormModel
{
    public $password_now;
    public $password_new;
    public $password_confirm;
    public $login;

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules()
    {
        return array(
            array('password_new', 'length', 'max'=>32, 'min' => 4,'message' => Yii::t('layout', 'Длина пароля должна быть от 4 до 32 символов'), 'on'=>'changePassword'),
            array('password_new', 'compare', 'compareAttribute'=>'password_confirm', 'on'=>'changePassword'),
            array('login', 'unique', 'className' => 'Users', 'caseSensitive' => false, 'message' => Yii::t('client_layout', 'Такой ник уже существует'), 'on'=>'changeLogin'),
            array('password_now, password_confirm', 'safe'),
        );
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels()
    {
        return array(
            'password_new' => Yii::t('admin_layout','Новый пароль'),
            'password_confirm' => Yii::t('admin_layout','Повторите пароль'),
            'password_now'=>Yii::t('admin_layout','Текущий пароль'),
            'login'=>Yii::t('admin_layout','Введите новый ник'),
        );
    }
}
