<?php
class MailForm extends CFormModel
{
    public $message;
    public $type;
    public $money;
    public $gold;
    public $silver;
    public $number;
    public $resource = 'iron';
    public $item;

    public function rules()
    {
        return array(
            array('number, gold, silver, item', 'numerical', 'integerOnly'=>true),
            array('gold, silver', 'checkMoney'),
            array('message', 'checkMessage'),
            array('number', 'checkResources'),
            array('item', 'checkItem'),
            array('message', 'length', 'max'=>1000),
            array('number', 'numerical', 'min'=>1),
            array('resource', 'safe'),
        );
    }
    
    public function checkMessage($attribute, $params) {
        if ($this->type < 1) {
            if (!$this->message) {
                $this->addError($attribute, Yii::t('layout', 'Необходимо ввести текст сообщения'));
            }
            if (!Users::checkForAvailable('iron', 1)) {
                $this->addError($attribute, Yii::t('layout', 'Недостаточно железа для отправки сообщения'));
            }
        }
    }
    
    public function checkMoney($attribute, $params) {
        if ($this->type == 1) {
            $this->money = $this->gold*100+$this->silver;
            if ($this->money < 1)
                $this->addError('money', Yii::t('layout', 'Укажите сумму для отправки'));
            $percent = (round($this->money/20)>5 ? round($this->money/20) : 5);
            $this->money += $percent;
            if (!Users::checkForAvailable('money', $this->money))
                $this->addError('money', Yii::t('layout', 'У Вас нет столько денег'));
        }
    }
    
    public function checkItem($attribute, $params) {
        if ($this->type == 3) {
            if (!$this->item)
                $this->addError('item', Yii::t('layout', 'Выберите предмет для отправки'));
            if (!UserItems::checkOwner($this->item, true))
                $this->addError('item', Yii::t('layout', 'Выберите другой предмет для отправки'));
            if (!Users::checkForAvailable('money', 5))
                $this->addError('item', Yii::t('layout', 'Недостаточно денег для оплаты отправки'));
        }
    }
    
    public function checkResources($attribute, $params) {
        if ($this->type == 2) {
            if ($this->number < 1)
                  $this->addError('number', Yii::t('layout', 'Укажите количество для отправки'));
            $price = 5*round($this->number/($this->resource == 'iron' ? 10000 : 10));
            if (!in_array($this->resource, array('iron', 'bottles')))
                $this->addError('number', Yii::t('layout', 'Укажите другой тип ресурсов'));  
            if (!$this->resource && !$this->number)
                $this->addError('number', Yii::t('layout', 'Укажите количество ресурсов для отправки'));
            if (!Users::checkForAvailable($this->resource, $this->number))
                $this->addError('number', Yii::t('layout', 'У вас нет столько ресурсов'));
            if (!Users::checkForAvailable('money', $price))
                $this->addError('number', Yii::t('layout', 'Недостаточно денег для оплаты сообщения'));
        }
    }
    
//    public function checkFields($attribute, $params) {
//        if ($this->scenario != 'reply') {
//            if ($this->type == 1) {
//                $this->money = $this->gold*100+$this->silver;
//                if ($this->money < 1)
//                    $this->addError('error', Yii::t('layout', 'Укажите сумму для отправки'));
//                $percent = (round($this->money/20)>5 ? round($this->money/20) : 5);
//                $this->money += $percent;
//                if (!Users::checkForAvailable('money', $this->money))
//                    $this->addError('error', Yii::t('layout', 'У Вас нет столько денег'));
//            }
//            elseif ($this->type == 2) {
//                $price = 5*round($this->number/($this->resource == 'iron' ? 10000 : 10));
//                if (!in_array($this->resource, array('iron', 'bottles')))
//                    $this->addError('error', Yii::t('layout', 'Укажите другой тип ресурсов'));  
//                if (!$this->resource && !$this->number)
//                    $this->addError('error', Yii::t('layout', 'Укажите количество ресурсов для отправки'));
//                if (!Users::checkForAvailable($this->resource, $this->number))
//                    $this->addError('error', Yii::t('layout', 'У вас нет столько ресурсов'));
//                if (!Users::checkForAvailable('money', $price))
//                    $this->addError('error', Yii::t('layout', 'Недостаточно денег для оплаты сообщения'));
//            }
//            elseif ($this->type == 3) {
//                if (!$this->items)
//                    $this->addError('error', Yii::t('layout', 'Выберите предмет для отправки'));
//                if (!UserItems::checkOwner($this->items))
//                    $this->addError('error', Yii::t('layout', 'Выберите другой предмет для отправки'));
//                if (!Users::checkForAvailable('money', 5))
//                    $this->addError('error', Yii::t('layout', 'Недостаточно денег для оплаты сообщения'));
//            }
//            else {
//                if (!$this->text) {
//                    $this->addError('error', Yii::t('layout', 'Необходимо ввести текст сообщения'));
//                }
//                if (!Users::checkForAvailable('iron', 1))
//                    $this->addError('error', Yii::t('layout', 'Недостаточно железа для оплаты сообщения'));
//            }
//        }
//    }

    public function attributeLabels()
    {
        return array(		
            'message' => Yii::t('layout', 'Сообщение'),
            'money' => Yii::t('layout', 'Деньги'),
            'item' => Yii::t('layout', 'Предмет'),
            'resource' => Yii::t('layout', 'Ресурсы'),
            'number' => Yii::t('layout', 'Количество'),
        );
    }
}
