<?php

class GuildsHistory extends CActiveRecord {
    public function tableName() {
        return 'guilds_history';
    }

    public function rules() {
        return array(
            array('id_guild', 'required'),
            array('type, subtype, created', 'numerical', 'integerOnly' => true),
            array('id_guild, id_user, id_target, created', 'length', 'max' => 11),
            array('info', 'length', 'max' => 100),
            array('id_history, id_guild, type, subtype, info, id_user, id_target, created', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'idGuild' => array(self::BELONGS_TO, 'Guilds', 'id_guild'),
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
            'idTarget' => array(self::BELONGS_TO, 'Users', 'id_target'),
        );
    }

    protected function beforeSave() {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                $this->id_user = Yii::app()->user->id;
                $this->created = time();
            }
            return true;
        } else {
            return false;
        }
    }
    
    public function attributeLabels() {
        return array(
            'id_history' => 'Id History',
            'id_guild' => 'Id Guild',
            'type' => 'Type',
            'subtype' => 'Subtype',
            'info' => 'Info',
            'id_user' => 'Id User',
            'id_target' => 'Id Target',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_history', $this->id_history, true);
        $criteria->compare('id_guild', $this->id_guild, true);
        $criteria->compare('type', $this->type);
        $criteria->compare('subtype', $this->subtype);
        $criteria->compare('info', $this->info, true);
        $criteria->compare('id_user', $this->id_user, true);
        $criteria->compare('id_target', $this->id_target, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
