<?php

class GuildsBuildings extends CActiveRecord {

    public function tableName() {
        return 'guilds_buildings';
    }

    public function rules() {
        return array(
            array('type, level', 'numerical', 'integerOnly' => true),
            array('id_guild, id_building, iron, bonus, time', 'length', 'max' => 11),
            array('id_guild, id_building, type, level, iron, bonus, time', 'safe'),
        );
    }

    public function relations() {
        return array(
            'idGuild' => array(self::BELONGS_TO, 'Guilds', 'id_guild'),
            'idBuilding' => array(self::BELONGS_TO, 'Buildings', 'id_building'),
        );
    }

    public function attributeLabels() {
        return array(
            'id_guild' => 'Id Guild',
            'id_building' => 'Id Building',
            'type' => 'Type',
            'level' => 'Level',
            'iron' => 'Iron',
            'bonus' => 'Bonus',
            'time' => 'Time',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_guild', $this->id_guild);
        $criteria->compare('id_building', $this->id_building);
        $criteria->compare('type', $this->type);
        $criteria->compare('level', $this->level);
        $criteria->compare('iron', $this->iron, true);
        $criteria->compare('bonus', $this->bonus, true);
        $criteria->compare('time', $this->time, true);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    /**
     * Выводит информацию о постройке для списка построек
     * @param type $id_guild
     * @param type $id_building
     * @return type
     */
    public static function getBuildingInfo($id_guild, $id_building) {
        $criteria = new CDbCriteria;
        $criteria->select = array('level', 'type', 'time');
        $criteria->compare('id_guild', $id_guild);
        $criteria->compare('id_building', $id_building);
        return self::model()->find($criteria);
    }

}
