<?php
class ForumThemesForUsers extends CActiveRecord {

    public function tableName() {
        return 'forum_themes_for_users';
    }

    public function rules() {
        return array(
            array('id_theme, id_user', 'required'),
            array('id_theme, id_user', 'length', 'max' => 11),
            array('id_theme, id_user', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'idTheme' => array(self::BELONGS_TO, 'ForumThemes', 'id_theme'),
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
        );
    }
    
    public function attributeLabels() {
        return array(
        );
    }

    public static function checkRead($id_theme) {
        return self::model()->countByAttributes(array('id_theme' => $id_theme, 'id_user' => Yii::app()->user->id));
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_dungeon', $this->id_dungeon, true);
        $criteria->compare('id_user', $this->id_user, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
