<?php
class ForumThemes extends CActiveRecord {

    public $is_delete;
    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'forum_themes';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('title, message', 'required'),
            array('close, vip', 'numerical', 'integerOnly' => true),
            array('id_category, time', 'length', 'max' => 11),
            array('title', 'length', 'max' => 255),
            array('id_category, time, id_user, close, vip, is_delete', 'safe'),
            array('id_theme, id_category, title, time, close, vip', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'forumMessages' => array(self::HAS_MANY, 'ForumMessages', 'id_theme'),
            'idCategory' => array(self::BELONGS_TO, 'ForumCategories', 'id_category'),
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
            'users' => array(self::MANY_MANY, 'Users', 'forum_themes_for_users(id_theme, id_user)'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_theme' => 'Id Theme',
            'id_category' => 'Id Category',
            'title' => 'Название',
            'message' => 'Сообщение',
            'time' => 'Time',
            'vip' => 'Приоритет',
            'close' => 'Закрыть тему',
            'is_delete' => 'Удалить тему',
        );
    }

    protected function beforeSave() {
        if ($this->isNewRecord) {
            $this->id_user = Yii::app()->user->id;
			$this->time = time();
        }
        return parent::beforeSave();
    }

    public function behaviors() {
        return array('CAdvancedArBehavior' => array(
            'class' => 'application.extensions.CAdvancedArBehavior.CAdvancedArBehavior'));
    }
    
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_theme', $this->id_theme, true);
        $criteria->compare('id_category', $this->id_category, true);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('time', $this->time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ForumThemes the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * Провверяет прочитанна ли тема для данного юзера
     * @param type $theme
     */
    public function checkRead() {
		$user = Users::findUser();
		$themes = CHtml::listData($user->forum_themes, 'id_theme', 'id_theme');
		if (in_array($this->id_theme, $themes)) {
			return true;
		}
		else {
			return false;
		}
    }
}
