<?php

/**
 * This is the model class for table "forum_messages".
 *
 * The followings are the available columns in table 'forum_messages':
 * @property string $id_message
 * @property string $id_theme
 * @property string $id_user
 * @property string $message
 * @property string $answer
 * @property integer $answer_type
 * @property integer $edit
 * @property integer $admin
 * @property integer $close
 * @property integer $vip
 * @property string $time
 *
 * The followings are the available model relations:
 * @property ForumThemes $idTheme
 */
class ForumMessages extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'forum_messages';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('message', 'required'),
            array('answer_type, edit, admin', 'numerical', 'integerOnly' => true),
            array('id_theme, time', 'length', 'max' => 11),
            array('id_user', 'length', 'max' => 255),
            array('answer', 'length', 'max' => 256),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id_message, id_theme, id_user, answer, answer_type, edit, admin, time, id_moder', 'safe'),
            array('id_message, id_theme, id_user, message, answer, answer_type, edit, admin, time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idTheme' => array(self::BELONGS_TO, 'ForumThemes', 'id_theme'),
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
            'idModer' => array(self::BELONGS_TO, 'Users', 'id_moder'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_message' => 'Id Message',
            'id_theme' => 'Тема',
            'id_user' => 'Пользователь',
            'message' => 'Комментарий',
            'answer' => 'Ответ',
            'answer_type' => 'Answer Type',
            'edit' => 'Edit',
            'admin' => 'Admin',
            'close' => 'Close',
            'vip' => 'Vip',
            'time' => 'Time',
        );
    }
    
    public function behaviors() {
        return array('CAdvancedArBehavior' => array(
            'class' => 'application.extensions.CAdvancedArBehavior.CAdvancedArBehavior'));
    }
    
    protected function beforeSave() {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                $this->time = time();
                $this->id_user = Yii::app()->user->id;
            }
            return true;
        } else {
            return false;
        }
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($id_theme) {
        $criteria = new CDbCriteria;

        $criteria->compare('id_theme', $id_theme, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'sortVar' => 'sort',
                'defaultOrder' => 'time ASC',
                'attributes' => array(
                    'time' => array('asc' => 'time', 'desc' => 'time DESC'),
                ),
            ),
            'pagination' => array(
                'route' => '/forum/theme/',
                'params' => array('id'=>$id_theme),
                'pageVar' => 'page',
                'pageSize' => '10',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ForumMessages the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
