<?php

class ForumCategories extends CActiveRecord {

    public function tableName() {
        return 'forum_categories';
    }

    public function rules() {
        return array(
            array('title', 'required'),
            array('title, description', 'length', 'max' => 255),
            array('description', 'safe'),
            array('id_category, title, description', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'forumThemes' => array(self::HAS_MANY, 'ForumThemes', 'id_category'),
        );
    }

    public function attributeLabels() {
        return array(
            'id_category' => 'Id Category',
            'title' => 'Название',
            'description' => 'Описание',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_category', $this->id_category, true);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('description', $this->description, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    /**
     * Провверяет прочитанна ли тема для данного юзера
     * @param type $theme
     */
    public function checkRead() {
        $count = count($this->forumThemes);
		$ids = CHtml::listData($this->forumThemes, 'id_theme', 'id_theme');
        $criteria = new CDbCriteria;
        $criteria->addInCondition('id_theme', $ids);
		$criteria->compare('id_user', Yii::app()->user->id);
		$read = ForumThemesForUsers::model()->count($criteria);
        if ($count == $read)
            return true;
        else
            return false;
    }
}
