<?php

/**
 * This is the model class for table "event_categories".
 *
 * The followings are the available columns in table 'event_categories':
 * @property string $id_event_cat
 * @property string $name_cat_ru
 * @property string $name_cat_ua
 * @property string $id_contr
 *
 * The followings are the available model relations:
 * @property Controllers $idContr
 */
class EventCategories extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event_categories';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name_cat_ru, name_cat_ua', 'required'),
			array('name_cat_ru, name_cat_ua', 'length', 'max'=>255),
			array('id_contr', 'length', 'max'=>11),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_event_cat, name_cat_ru, name_cat_ua, id_contr', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idContr' => array(self::BELONGS_TO, 'Controllers', 'id_contr'),
                        'events' => array(self::HAS_MANY, 'Events', 'id_event_cat'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_event_cat' => 'Id Event Cat',
			'name_cat_ru' => 'Name Cat Ru',
			'name_cat_ua' => 'Name Cat Ua',
			'id_contr' => 'Id Contr',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_event_cat',$this->id_event_cat);
		$criteria->compare('name_cat_ru',$this->name_cat_ru,true);
		$criteria->compare('name_cat_ua',$this->name_cat_ua,true);
		$criteria->compare('id_contr',$this->id_contr);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EventCategories the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
