<?php
class DungeonsWaiters extends CActiveRecord {

    public function tableName() {
        return 'dungeons_waiters';
    }

    public function rules() {
        return array(
            array('id_dungeon, id_user', 'required'),
            array('id_dungeon, id_user', 'length', 'max' => 11),
            array('id_dungeon, id_user', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'idDungeon' => array(self::BELONGS_TO, 'DungeonsList', 'id_dungeon'),
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
        );
    }
    
    public function attributeLabels() {
        return array(
            'id_dungeon' => 'Id Dungeon',
            'id_user' => 'Id User',
        );
    }
    
    /**
     * Ищет всех юзеров которые в данже
     * @param type $id_dungeon
     * @param type $id_guild если указан клан, будет искать клановых союзников
     * @param type $class если указан класс, найдет только указанный класс, если нет - всех
     */
    public static function findUsersInDungeon($id_dungeon, $class = null, $id_guild = null) {
        $criteria = new CDbCriteria;
        $criteria->with = array('idUser');
        $criteria->together = true;
        $criteria->select = array('t.id_user');
        $criteria->compare('t.id_dungeon', $id_dungeon);
        $criteria->compare('idUser.guild_id', $id_guild);
        $criteria->compare('idUser.class', $class);
        $criteria->addCondition('idUser.last_visit > '.(time()-60*5));
        $users = self::model()->findAll($criteria);
        $ids = CHtml::listData($users, 'id_user', 'id_user');
        return Users::model()->findAllByPk($ids);
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_dungeon', $this->id_dungeon, true);
        $criteria->compare('id_user', $this->id_user, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
