<?php
class DungeonsList extends CActiveRecord {

    public function tableName() {
        return 'dungeons_list';
    }

    public function rules() {
        return array(
            array('name_dungeon, warriors_need, healers_need, all_need, time_cooldown, day_access', 'required'),
            array('level, warriors_need, healers_need, all_need, day_access', 'numerical', 'integerOnly' => true),
            array('name_dungeon', 'length', 'max' => 64),
            array('time_cooldown', 'length', 'max' => 11),
            array('id_dungeon, name_dungeon, level, warriors_need, healers_need, all_need, time_cooldown, day_access', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'battlesDungeons' => array(self::HAS_MANY, 'BattlesDungeons', 'id_dungeon'),
            'dungeonsBots' => array(self::HAS_MANY, 'DungeonsBots', 'id_dungeon'),
            'usersLog' => array(self::MANY_MANY, 'Users', 'user_dungeons(id_dungeon, id_user)'),
            'users' => array(self::MANY_MANY, 'Users', 'dungeons_waiters(id_dungeon, id_user)',
                            'condition'=>'users.last_visit > '.(time()-60*5)),
            'warriors' => array(self::MANY_MANY, 'Users', 'dungeons_waiters(id_dungeon, id_user)',
                            'condition'=>'warriors.class = 1 AND warriors.last_visit > '.(time()-60*5)),
            'healers' => array(self::MANY_MANY, 'Users', 'dungeons_waiters(id_dungeon, id_user)',
                            'condition'=>'healers.class = 2 AND healers.last_visit > '.(time()-60*5)),
        );
    }

    public function attributeLabels() {
        return array(
            'id_dungeon' => 'Id Dungeon',
            'name_dungeon' => 'Name Dungeon',
            'level' => 'Level',
            'warriors_need' => 'Warriors Need',
            'healers_need' => 'Healers Need',
            'all_need' => 'All Need',
            'time_cooldown' => 'Time Cooldown',
            'day_access' => 'Day Access',
        );
    }

    public function behaviors() {
        return array('CAdvancedArBehavior' => array(
            'class' => 'application.extensions.CAdvancedArBehavior.CAdvancedArBehavior'));
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_dungeon', $this->id_dungeon, true);
        $criteria->compare('name_dungeon', $this->name_dungeon, true);
        $criteria->compare('level', $this->level);
        $criteria->compare('warriors_need', $this->warriors_need);
        $criteria->compare('healers_need', $this->healers_need);
        $criteria->compare('all_need', $this->all_need);
        $criteria->compare('time_cooldown', $this->time_cooldown, true);
        $criteria->compare('day_access', $this->day_access);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }
    
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
    * Проверяет находится ли пользователь в очереди
    */
    public static function checkForWait() {
        $criteria = new CDbCriteria;
        $criteria->with = array('users');
        $criteria->together = true;
        $criteria->addCondition('users.id_user = '.Yii::app()->user->id);
        return self::model()->find($criteria);
    }
}
