<?php
class DungeonsBots extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'dungeons_bots';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id_dungeon, login', 'required'),
            array('id_dungeon, strength, health, energy, regeneration, armor', 'length', 'max' => 11),
            array('login', 'length', 'max' => 64),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id_bot, id_dungeon, login, strength, health, energy, regeneration, armor', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idDungeon' => array(self::BELONGS_TO, 'DungeonsList', 'id_dungeon'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_bot' => 'Id Bot',
            'id_dungeon' => 'Id Dungeon',
            'login' => 'Login',
            'strength' => 'Strength',
            'health' => 'Health',
            'energy' => 'Energy',
            'regeneration' => 'Regeneration',
            'armor' => 'Armor',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_bot', $this->id_bot, true);
        $criteria->compare('id_dungeon', $this->id_dungeon, true);
        $criteria->compare('login', $this->login, true);
        $criteria->compare('strength', $this->strength, true);
        $criteria->compare('health', $this->health, true);
        $criteria->compare('energy', $this->energy, true);
        $criteria->compare('regeneration', $this->regeneration, true);
        $criteria->compare('armor', $this->armor, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return DungeonsBots the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * Возвращает всех ботов, которые есть в данном данже
     * @param type $id_dungeon ид данжа
     * @return type
     */
    public static function findByDangeon($id_dungeon) {
        $criteria = new CDbCriteria;
        $criteria->compare('id_dungeon', $id_dungeon);
        return self::model()->findAll($criteria);
    }
}
