<?php
class DonateLog extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'donate_log';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type, tid, id_user, value, phone, status, time', 'required'),
            array('type, tid, id_user, value, result, time', 'numerical', 'integerOnly' => true),
            array('phone', 'length', 'max' => 20),
            array('status', 'length', 'max' => 64),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, type, tid, id_user, value, phone, status, result, time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    protected function beforeSave() {
    if (parent::beforeSave()) {
        if ($this->isNewRecord) {
            $this->time = time();
        }
        return true;
    } else
        return false;
    }
    
    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'type' => 'Тип платежа',
            'tid' => 'ID транзакции',
            'id_user' => 'Пользователь',
            'value' => 'Золото',
            'phone' => 'Телефон',
            'result' => 'Статус',
            'time' => 'Время',
        );
    }

    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('type', $this->type);
        $criteria->compare('tid', $this->tid);
        $criteria->compare('id_user', $this->id_user);
        $criteria->compare('value', $this->value);
        $criteria->compare('phone', $this->phone, true);
        $criteria->compare('result', $this->result);
        $criteria->compare('time', $this->time);
        $criteria->order = 'time DESC';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getColumns() {
        return array(
            array(
                'name' => 'id_message',
                'header' => '#',
            ),
            array(
                'name' => 'type',
                'type' => 'raw',
                'value' => 'DonateLog::getType($data->type)',
            ),
            array(
                'name' => 'tid',
            ),
            array(
                'name' => 'id_user',
                'type' => 'raw',
                'value' => 'Users::getLoginWithLink($data->id_user)',
            ),
            array(
                'name' => 'value',
            ),
            array(
                'name' => 'phone',
            ),
            array(
                'name' => 'result',
                'value' => '($data->result > 0 ? "Проведен" : "В обработке")',
            ),
            array(
                'name' => 'time',
                'value' => 'FuncHelper::time($data->time)',
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
            )
        );
    }
    
    public static function getType($type) {
        if ($type == 1) {
            return '<img src="'.Yii::app()->request->baseUrl.'/images/payment/25x25/webmoney.png" width="18" /> Webmoney';
        }
        elseif ($type == 2) {
            return '<img src="'.Yii::app()->request->baseUrl.'/images/payment/25x25/xsolla.png" width="18" /> Xsolla';
        }
        elseif ($type == 3) {
            return '<img src="'.Yii::app()->request->baseUrl.'/images/payment/25x25/MTS.png" width="18" /> Моб. платеж';
        }
        elseif ($type == 4) {
            return '<img src="'.Yii::app()->request->baseUrl.'/images/payment/25x25/qiwi.png" width="18" /> QIWI';
        }
        elseif ($type == 5) {
            return '<img src="'.Yii::app()->request->baseUrl.'/images/payment/25x25/pumpit.png" width="18" /> Pumpit';
        }
    }
    
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
