<?php

class Buildings extends CActiveRecord {

    public function tableName() {
        return 'buildings';
    }

    public function rules() {
        return array(
            array('type, name, info', 'required'),
            array('type', 'numerical', 'integerOnly' => true),
            array('name', 'length', 'max' => 100),
            array('info', 'length', 'max' => 500),
            array('id_building, type, name, info', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'guilds' => array(self::MANY_MANY, 'Guilds', 'guilds_buildings(id_building, id_guild)'),
        );
    }

    public function attributeLabels() {
        return array(
            'id_building' => 'Id Building',
            'type' => 'Type',
            'name' => 'Name',
            'info' => 'Info',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_building', $this->id_building, true);
        $criteria->compare('type', $this->type);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('info', $this->info, true);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
