<?php

/**
 * This is the model class for table "battles_dungeons".
 *
 * The followings are the available columns in table 'battles_dungeons':
 * @property string $id_battle
 * @property string $id_dungeon
 * @property string $time_start
 * @property string $time_end
 *
 * The followings are the available model relations:
 * @property DungeonsList $idDungeon
 */
class BattlesDungeons extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'battles_dungeons';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id_dungeon, time_start, time_end', 'required'),
            array('id_dungeon, time_start, time_end', 'length', 'max' => 11),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id_battle, id_dungeon, time_start, time_end', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idDungeon' => array(self::BELONGS_TO, 'DungeonsList', 'id_dungeon'),
            'users' => array(self::HAS_MANY, 'Users', 'battle_id',
                            'with'=>'idRole',
                            'condition'=>'idRole.id_cat_role != 5'),
            'bots' => array(self::HAS_MANY, 'Users', 'battle_id',
                            'with'=>'idRole',
                            'condition'=>'idRole.id_cat_role = 5'),
            'warriors' => array(self::HAS_MANY, 'Users', 'battle_id',
                            'with'=>'idRole',
                            'condition'=>'idRole.id_cat_role != 5 AND health_now > 0 AND class = 1'),
            'healers' => array(self::HAS_MANY, 'Users', 'battle_id',
                            'with'=>'idRole',
                            'condition'=>'idRole.id_cat_role != 5 AND health_now > 0 AND class = 2'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_battle' => 'Id Battle',
            'id_dungeon' => 'Id Dungeon',
            'time_start' => 'Time Start',
            'time_end' => 'Time End',
        );
    }

    protected function beforeSave() {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                $this->time_start = time();
            }
            return true;
        } else {
            return false;
        }
    }
    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_battle', $this->id_battle, true);
        $criteria->compare('id_dungeon', $this->id_dungeon, true);
        $criteria->compare('time_start', $this->time_start, true);
        $criteria->compare('time_end', $this->time_end, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return BattlesDungeons the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    /**
    * Проверяет находится ли пользователь в пещерах
    */
    public static function checkForBattle() {
        $criteria = new CDbCriteria;
        $criteria->with = array('users');
        $criteria->together = true;
        $criteria->addCondition('users.id_user = '.Yii::app()->user->id);
        return self::model()->find($criteria);
    }
}
