<?php

/**
 * This is the model class for table "battle_log".
 *
 * The followings are the available columns in table 'battle_log':
 * @property string $id_log
 * @property integer $battle_type
 * @property string $battle_id
 * @property string $user
 * @property string $target
 * @property string $type
 * @property string $value
 * @property string $time
 *
 * The followings are the available model relations:
 * @property Users[] $users
 */
class BattleLog extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'battle_log';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('battle_type, battle_id, id_user, id_target, type, value', 'required'),
            array('battle_type, value', 'numerical', 'integerOnly' => true),
            array('battle_id, user, target, type, time', 'length', 'max' => 11),
            array('info', 'length', 'max' => 264),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('time', 'safe'),
            array('id_log, battle_type, battle_id, id_user, target, type, value, time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idBattle' => array(self::BELONGS_TO, 'BattlesLocations', 'battle_id'),
            'idDungeon' => array(self::BELONGS_TO, 'BattlesDungeons', 'battle_id'),
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
            'idTarget' => array(self::BELONGS_TO, 'Users', 'id_target'),
            'users' => array(self::MANY_MANY, 'Users', 'log_for_users(id_log, id_user)'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_log' => 'Id Log',
            'battle_type' => 'Battle Type',
            'battle_id' => 'Battle',
            'user' => 'User',
            'target' => 'Target',
            'type' => 'Type',
            'value' => 'Value',
            'time' => 'Time',
        );
    }
    
    public function behaviors() {
        return array('CAdvancedArBehavior' => array(
            'class' => 'application.extensions.CAdvancedArBehavior.CAdvancedArBehavior'));
    }
    
    protected function beforeSave() {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                $this->time = time();
            }
            return true;
        } else {
            return false;
        }
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_log', $this->id_log, true);
        $criteria->compare('battle_type', $this->battle_type);
        $criteria->compare('battle_id', $this->battle_id, true);
        $criteria->compare('user', $this->user, true);
        $criteria->compare('target', $this->target, true);
        $criteria->compare('type', $this->type, true);
        $criteria->compare('value', $this->value, true);
        $criteria->compare('time', $this->time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return BattleLog the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
