<?php
class AdminForm extends CFormModel
{
    public $id_user;
    public $type;
    public $number;
    public $reason;
    public $message;
    public $mute;
    public $answer;
    public $is_delete;

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules()
    {
        return array(
            array('number, type, mute', 'numerical', 'integerOnly'=>true),
            /* правила для бана юзера*/
            array('number, reason', 'required', 'on'=>'banUser'),
            array('type', 'checkNumber', 'on'=>'banUser'),
            /* правила для редактирования сообщений в чате/форуме*/
            array('message', 'required', 'on'=>'messageEdit'),
            array('reason, answer', 'safe', 'on'=>'messageEdit'),
            array('type, is_delete', 'safe'),
        );
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels()
    {
        return array(
            'type' => Yii::t('admin_layout','Тип'),
            'reason' => Yii::t('admin_layout','Комментарий'),
            'number'=>Yii::t('admin_layout','Число'),
            'message'=>Yii::t('admin_layout','Сообщение'),
            'id_user'=>Yii::t('admin_layout','Пользователь'),
            'mute'=>Yii::t('admin_layout','Молчание'),
            'answer'=>Yii::t('admin_layout','Ответ'),
            'is_delete'=>Yii::t('admin_layout','Удалить'),
        );
    }

    public function checkNumber($attribute,$params)
    {
        if (!$this->number && $this->type > 0)
            $this->addError('number',Yii::t('layout','Укажите число'));
    }
}
