<?php

class Actions extends CActiveRecord {

    public function tableName() {
        return 'actions';
    }

    public function rules() {
        return array(
            array('type_action, short_name_action, name_action, descr_action, min_bonus, bonus, time_active', 'required'),
            array('type_action, bonus', 'numerical', 'integerOnly' => true),
            array('short_name_action', 'length', 'max' => 100),
            array('name_action', 'length', 'max' => 512),
            array('descr_action', 'length', 'max' => 2054),
            array('time', 'length', 'max' => 11),
            array('time', 'safe'),
            array('id_action, type_action, short_name_action, name_action, descr_action, min_bonus, bonus, time', 'safe', 'on'=>'search'),
        );
    }

    public function relations() {
        return array(
        );
    }

    public function attributeLabels() {
        return array(
            'id_action' => 'Id Action',
            'type_action' => 'Тип',
            'short_name_action' => 'Название',
            'name_action' => 'Полное название',
            'descr_action' => 'Описание',
            'min_bonus' => 'Мин. бонус',
            'bonus' => 'Бонус',
            'time_active' => 'Время (в час.)',
            'time' => 'Статус',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_action', $this->id_action, true);
        $criteria->compare('type_action', $this->type_action);
        $criteria->compare('short_name_action', $this->short_name_action, true);
        $criteria->compare('name_action', $this->name_action, true);
        $criteria->compare('descr_action', $this->descr_action, true);
        $criteria->compare('bonus', $this->bonus);
        $criteria->compare('time', $this->time, true);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getBonusValue($type) {
        $criteria = new CDbCriteria;
        $criteria->compare('type_action', $type);
        $criteria->addCondition('t.time >= '.time());
        $model = self::model()->find($criteria);
        if ($model) {
            return $model->bonus;
        }
        else return null;
    }
    
    public function getColumns() {
        return array(
            array(
                'name' => 'id_action',
                'header' => '#',
            ),
            array(
                'name' => 'short_name_action',
            ),
            array(
                'name' => 'name_action',
            ),
            array(
                'name' => 'descr_action',
                'value'=>function($data) {
                    $text = mb_substr($data->descr_action,0,250,'UTF-8');
                    $text = strip_tags($text);
                    if (mb_strlen($data->descr_action,'UTF-8')>256) $text .= '...';
                    if ($text) return $text;
                    else return "&nbsp;";
                },
            ),
            array(
                'name' => 'bonus',
            ),
            array(
                'name' => 'time_active',
            ),
            array(
                'name' => 'time',
                'type' => 'raw',
                'header' => 'Статус',
                'value' => function ($data) {
                    if ($data->time < time()) {
                        return 'Не активна';
                    }
                    else {
                        return 'До конца акции: '.FuncHelper::timeLeft($data->time-time());
                    }
                },
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{active} {control} {remove}',
                'buttons' => array(
                    'active' => array(
                        'url' => 'array("actions/active", "id"=>$data->id_action)',
                        'label' => '<i class="fa fa-gift"></i>',
                        'options' => array(
                            'title' => 'Активировать', 
                            'style' => 'color: #000000;',
                            'confirm' => 'Активировать акцию?',
                            'ajax' => array(
                                'type' => 'POST',
                                'url' => "js:$(this).attr('href')",
                                'success' => 'function(data){                                
                                if(data == "true"){
                                    $.fn.yiiGridView.update("actions-grid");
                                    return false;
                                }
                            }',
                            'error' => 'function(data) { alert("error"); }',
                            ),
                        ),
                    ),
                    'control' => array(
                        'url' => 'array("actions/update", "id"=>$data->id_action)',
                        'label' => '<i class="fa fa-pencil"></i>',
                        'options' => array('title' => 'Редактировать', 'style' => 'color: #000000;'),
                    ),
                    'remove' => array(
                        'url' => 'array("shop/delete", "id"=>$data->id_action)',
                        'label' => '<i class="fa fa-times"></i>',
                        'options' => array(
                            'title' => 'Удалить', 
                            'style' => 'color: #000000;',
                            'confirm' => 'Удалить акцию?',
                            'ajax' => array(
                                'type' => 'POST',
                                'url' => "js:$(this).attr('href')",
                                'success' => 'function(data){                                
                                if(data == "true"){
                                    $.fn.yiiGridView.update("actions-grid");
                                    return false;
                                }
                            }',
                            'error' => 'function(data) { alert("error"); }',
                            ),
                        ),
                    )
                )
            )
        );
    }
}
