<?php

echo "
    ALTER TABLE `mland`.`users` 
ADD COLUMN `id_ref` INT(11) UNSIGNED NOT NULL AFTER `news_ntf`;
CREATE TABLE `buildings` (
  `id_building` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL,
  `name` varchar(100) NOT NULL,
  `info` varchar(500) NOT NULL,
  PRIMARY KEY (`id_building`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `guilds_buildings` (
  `id_guild` int(11) unsigned NOT NULL,
  `id_building` int(11) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `iron` int(11) unsigned NOT NULL,
  `bonus` int(11) unsigned NOT NULL,
  `time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id_building`, `id_guild`),
  KEY `id_building` (`id_building`),
  KEY `id_guild` (`id_guild`),
  CONSTRAINT `fk_guilds_buildings_1` FOREIGN KEY (`id_guild`) REFERENCES `guilds` (`id_guild`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_guilds_buildings_2` FOREIGN KEY (`id_building`) REFERENCES `buildings` (`id_building`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `mland`.`buildings` (`id_building`, `type`, `name`, `info`) VALUES ('1', '1', 'Камень ярости', 'Строение гильдии, позволяющее всем членам гильдии в течении 2-х часов пользоваться бонусом к параметрам героя за небольшие пожертвования в виде железа.');

CREATE TABLE `users_buffs` (
  `id_buff` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `strength` int(11) unsigned NOT NULL,
  `armor` int(11) unsigned NOT NULL,
  `health` int(11) unsigned NOT NULL,
  `energy` int(11) unsigned NOT NULL,
  `regeneration` int(11) unsigned NOT NULL,
  `time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id_buff`),
  KEY `id_user` (`id_user`),
  CONSTRAINT `users_buffs_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `users` (`id_user`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

ALTER TABLE `mland`.`users_buffs` 
ADD COLUMN `percents` INT(11) UNSIGNED NOT NULL AFTER `regeneration`;

ALTER TABLE `mland`.`users_buffs` 
CHANGE COLUMN `percents` `percents` DECIMAL(3,1) UNSIGNED NOT NULL;

ALTER TABLE `mland`.`users_buffs` 
CHANGE COLUMN `percents` `bonus` DECIMAL(4,1) UNSIGNED NOT NULL ,
ADD COLUMN `subtype` TINYINT(2) UNSIGNED NOT NULL AFTER `type`;




###new
ALTER TABLE `mland`.`users` 
ADD COLUMN `guild_buff` DECIMAL(4,1) UNSIGNED NOT NULL AFTER `guild_time`,
ADD COLUMN `guild_buff_time` INT(11) UNSIGNED NOT NULL AFTER `guild_buff`;



";