<?php

class m141223_224844_actions extends CDbMigration {

    public function up() {
        $this->execute("
            CREATE TABLE `shop_abilities` (
  `id_ability` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name_ability` varchar(64) NOT NULL,
  `descr_ability` varchar(500) NOT NULL,
  `passive_ability` varchar(500) NOT NULL,
  PRIMARY KEY (`id_ability`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `shop_abilities_types` (
  `id_type` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_ability` int(11) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `value` int(3) unsigned NOT NULL,
  `time_active` int(11) unsigned NOT NULL,
  `time_cooldown` int(11) unsigned NOT NULL,
  `money` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id_type`),
  KEY `id_ability` (`id_ability`),
  CONSTRAINT `shop_abilities_types_ibfk_1` FOREIGN KEY (`id_ability`) REFERENCES `shop_abilities` (`id_ability`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `users_abilities` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) unsigned NOT NULL,
  `id_ability` int(11) unsigned NOT NULL,
  `id_type` int(11) unsigned NOT NULL,
  `chosen` tinyint(1) unsigned NOT NULL,
  `time_active` int(11) unsigned NOT NULL,
  `time_cooldown` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_ability` (`id_ability`),
  KEY `id_type` (`id_type`),
  KEY `id_user` (`id_user`),
  CONSTRAINT `users_abilities_ibfk_1` FOREIGN KEY (`id_ability`) REFERENCES `shop_abilities` (`id_ability`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `users_abilities_ibfk_2` FOREIGN KEY (`id_type`) REFERENCES `shop_abilities_types` (`id_type`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `users_abilities_ibfk_3` FOREIGN KEY (`id_user`) REFERENCES `users` (`id_user`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
ALTER TABLE `mland`.`shop_abilities` 
ADD COLUMN `info` VARCHAR(64) NOT NULL AFTER `descr_ability`;

                ");

        if (Yii::app()->hasComponent('cache')) {
            Yii::app()->getComponent('cache')->flush();
            echo "Cache flused\n";
        }

        $this->clearAssets();
    }

    private function clearAssets() {
        $path = Yii::app()->getComponent('assetManager')->getBasePath();
        $this->clearDir($path);
        echo "Assets clear\n";
    }

    private function clearDir($folder, $main = true) {
        if (is_dir($folder)) {
            $handle = opendir($folder);
            while ($subfile = readdir($handle)) {
                if ($subfile == '.' || $subfile == '..')
                    continue;
                if (is_file($subfile))
                    unlink("{$folder}/{$subfile}");
                else
                    $this->clearDir("{$folder}/{$subfile}", false);
            }
            closedir($handle);
            if (!$main)
                rmdir($folder);
        } else
            unlink($folder);
    }

    public function down() {
        echo "m141223_224844_actions does not support migration down.\n";
        return false;

        $this->execute("");
    }

    /*
      // Use safeUp/safeDown to do migration with transaction
      public function safeUp()
      {
      }

      public function safeDown()
      {
      }
     */
}
