<?php
class Tiny extends CInputWidget {

    public $attribute;
    public $name;
    public $value;
    public $htmlOptions;
        
    public function init() {
        return parent::init();
    }
    
    function run() {
        list($name, $id) = $this->resolveNameID();
        
        if (isset($this->htmlOptions['id']))
            $id = $this->htmlOptions['id'];
        else
            $this->htmlOptions['id'] = $id;
        
        if (isset($this->htmlOptions['name']))
            $name = $this->htmlOptions['name'];
        else
            $this->htmlOptions['name'] = $name;
        
        if ($this->hasModel())
            echo CHtml::activeTextArea($this->model, $this->attribute, $this->htmlOptions);
        else
            echo CHtml::textArea($this->name, $this->value, $this->htmlOptions);

        $cs = Yii::app()->getClientScript();

        $assetUrl = Yii::app()->assetManager->publish(Yii::getPathOfAlias('ext.tinymce.js.assets'));
        Yii::app()->clientScript->registerScriptFile($assetUrl . '/tinymce.min.js');

        $js = 'tinymce.init({
            selector: "#'.$id.'",
            height : "500",
            language : "ru",
            resize: "both",
            relative_urls : false,
            forced_root_block : "",
            plugins: [
                "lists link image",
                "insertdatetime media table contextmenu paste jbimages textcolor"
            ],
            menu : {
                edit   : {title : "Edit"  , items : "undo redo | cut copy paste pastetext | selectall"},
                insert : {title : "Insert", items : "jbimages link media | template hr"},
                view   : {title : "View"  , items : "visualaid"},
                format : {title : "Format", items : "bold italic underline strikethrough superscript subscript | formats | removeformat"},
                table  : {title : "Table" , items : "inserttable tableprops deletetable | cell row column"},
            },
            toolbar: "jbimages undo redo | styleselect | forecolor backcolor | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"});';
        $cs->registerScript(__CLASS__ . '#' . $id, $js);
    }
}
?>