<?php

/**
  SladekTinyMCE
 * 
 * Cтарый редактор
 *             
 *   $this->widget('ext.ImperaviRedactor.ImperaviRedactorWidget', array(
 *       'model' => $model,
 *       'attribute' => 'descr_subject',
 *       'options' => array(
 *           'lang' => Yii::App()->language,
 *           'toolbar' => true,
 *           'iframe' => true,
 *           'minHeight' => 500,
 *           'imageUpload' => '/image/imgUpload',
 *       ),
 *   ));
 */
class SladekTinyMce extends CInputWidget {

    public $height = 500;

    public function init() {
        $assetUrl = Yii::app()->assetManager->publish(Yii::getPathOfAlias('ext.tinymce.js.assets'));
        Yii::app()->clientScript->registerScriptFile($assetUrl . '/tinymce.min.js');
        $lang = Yii::App()->language;
        if (!in_array($lang, array('ru', 'ua', 'en'))) {
            $lang = 'ru';
        }
        echo '<script>
            tinymce.init({
                selector: "textarea.tinymce",
                relative_urls : false,
                height : "' . $this->height . '",
                resize: "both",
                language : "' . $lang . '",
                plugins: [
                    "advlist autolink lists link image charmap preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media table contextmenu paste jbimages textcolor"
                ],
                menu : { // this is the complete default configuration
                    edit   : {title : "Edit"  , items : "undo redo | cut copy paste pastetext | selectall"},
                    insert : {title : "Insert", items : "jbimages link media | template hr"},
                    view   : {title : "View"  , items : "visualaid"},
                    format : {title : "Format", items : "bold italic underline strikethrough superscript subscript | formats | removeformat"},
                    table  : {title : "Table" , items : "inserttable tableprops deletetable | cell row column"},
                    tools  : {title : "Tools" , items : "spellchecker code"}
                },
                toolbar: "jbimages undo redo | styleselect | forecolor backcolor | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"
            });
            </script>';
    }

}