<?php
class TrainingController extends Controller {
    public function accessRules() {
        return array(
            array('deny',
                'roles' => array('banned'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            ),
            array('allow',
                'actions' => array('index', 'damageLastTarget',  'healLastTarget'),
                'users' => array('@'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionIndex() {
        $user = Users::findUser();
        if ($user->xp <= 270) {
            $dialog = array(
                0=>'Мы находимся в тренировочном лагере, твоя задача научиться сражаться. В этом нам поможет этот манекен. Нажми "'.($user->class == 1 ? 'Бить' : 'Лечить').' манекен"',
                45=>'У тебя хорошо получается! Как ты можешь заметить с каждым '.($user->class == 1 ? 'ударом' : 'лечением').' ты становишься опытней, это заметно по полосе опыта вверху экрана. Продолжай '.($user->class == 1 ? 'бить' : 'лечить').'!',
                90=>'Поздравляю! Ты хорошо справляешься, теперь я научу тебя пользоваться предметами. Для начала попробуй получить предмет продолжая '.($user->class == 1 ? 'бить' : 'лечить').' манекен.',
                135=>'Ты получил вещь за свои старания, можешь примерить ее. Одень и потом вернись в бой.',
                180=>'В Битвах, куда ты скоро отправишься, ты тоже будешь получать вещи за свои старания!',
                225=>'У тебя хорошо получается, еще не много и отправишься на поле боя!',
                270=>'Ты достиг 3 уровня и готов сражаться за свой лагерь. Отправляйся на Битву и помни чему я тебя учил.',
                );
            if ($user->battle_type != 3) {
                $user->battle_type = 3;
                $user->battle_target = 3;
                if (!$user->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
                }
            }
            $this->render('index', array(
                'user' => $user,
                'dialog' => $dialog
            ));
        }
        else {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end(); 
        }
    }

    public function actionDamageLastTarget() {
        $user = Users::findUser();
        if ($user->battle_type != 3 || $user->level > 3) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        $user_params['xp'] = $user->xp + 45;
        $user_params['level'] = $user->level;
        $user_params['health_now'] = $user->health_now;
        $user_params['energy_now'] = $user->energy_now;
        $user_params = BattleHelper::checkXP($user, $user_params);
        Users::model()->updateByPk($user->id_user, $user_params);

        $log = new BattleLog();
        $log->battle_type = $user->battle_type;
        $log->battle_id = $user->battle_id;
        $log->id_user = $user->id_user;
        $log->id_target = $user->battle_target;
        $log->type = $user->class;
        $log->value = 45;
        $log->users = $user->id_user;
        $log->save(false);
        if ($user->xp == 135) {
            $criteria = new CDbCriteria();
            $criteria->condition = 'id_set = 1';
            $criteria->select = array('id_item', 'id_set');
            $criteria->order = 'RAND()';
            $criteria->limit = 1;
            $item = ShopItems::model()->find($criteria);
            $drop = ShopItems::getNewItem($item->id_item, 2, $user->id_user, false);
            $log = new BattleLog();
            $log->battle_type = $user->battle_type;
            $log->battle_id = $user->battle_id;
            $log->id_user = $user->id_user;
            $log->type = 5;
            $log->value = $drop;
            $log->users = $user->id_user;
            $log->save(false);
        }
        $this->redirect($this->createUrl('training/index'));
        Yii::app()->end();
    }

    public function actionHealLastTarget() {
        $user = Users::model()->findByPk(Yii::app()->user->id);
        if ($user->battle_type != 3 || $user->level > 3) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        $user_params['xp'] = $user->xp + 45;
        $user_params['level'] = $user->level;
        $user_params['health_now'] = $user->health_now;
        $user_params['energy_now'] = $user->energy_now;
        $user_params = BattleHelper::checkXP($user, $user_params);
        Users::model()->updateByPk($user->id_user, $user_params);

        $log = new BattleLog();
        $log->battle_type = $user->battle_type;
        $log->battle_id = $user->battle_id;
        $log->id_user = $user->id_user;
        $log->id_target = $user->battle_target;
        $log->type = $user->class;
        $log->value = 45;
        $log->users = $user->id_user;
        $log->save(false);
        if ($user->xp == 135) {
            $criteria = new CDbCriteria();
            $criteria->condition = 'id_set = 1';
            $criteria->select = array('id_item', 'id_set');
            $criteria->order = 'RAND()';
            $criteria->limit = 1;
            $item = ShopItems::model()->find($criteria);
            $drop = ShopItems::getNewItem($item->id_item, 2, $user->id_user, false);
            $log = new BattleLog();
            $log->battle_type = $user->battle_type;
            $log->battle_id = $user->battle_id;
            $log->id_user = $user->id_user;
            $log->type = 5;
            $log->value = $drop;
            $log->users = $user->id_user;
            $log->save(false);
        }
        $this->redirect($this->createUrl('training/index'));
        Yii::app()->end();
    }

}
