<?php
class TradeController extends Controller {
    public function accessRules() {
        return array(
            array('deny',
                'roles' => array('banned'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            ),
            array('allow',
                'actions' => array('index', 'back', 'buy', 'new'),
                'users' => array('@'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionIndex() {
        $model = new Auction('searchTrade');
        $model->unsetAttributes();  // clear any default values

        $list = array('iron', 'bottles', 'my');
        if (isset($_GET['sort']) && in_array($_GET['sort'], $list)) {
            $sort = $_GET['sort'];
        }
        else {
            $sort = 'iron';
        }
        $this->render('index', array('model' => $model, 'sort' => $sort, ));
    }
    
    /*
     * Выставляем ресурс на аук
     */
    public function actionNew() {
        $model = new Auction;
        if(isset($_POST['Auction']))
        {
            $user = Users::model()->findByPk(Yii::app()->user->id);
            $model->setscenario('insertTrade');
            $model->attributes = $_POST['Auction'];
            $type = $model->trade;
            if (!in_array($type, array('iron', 'bottles')) || $user->$type < $model->number) {
                Yii::app()->user->setFlash('error', 'У вас недостаточно ресурсов.');
                $this->redirect(Yii::app()->request->urlReferrer); 
                Yii::app()->end();
            }
            $model->lot = AUCTION_RES;
            $model->$type = $model->number;
            $model->price_out = $model->min_price_gold*100+$model->min_price_silver;
            if ($model->save()) {
                $user->$type -= $model->number;
                if (!$user->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
                }
                Yii::app()->user->setFlash('info', 'Ваши ресурсы выставлены на аукцион.');
                $this->redirect(array('/trade/index')); 
                Yii::app()->end();
            }
        }
        $this->render('new', array('model' => $model ));
    }
    
    /*
     * Забираем ресы с аука
     */
    public function actionBack($id) {
        $model = Auction::model()->findByPk($id);
        if (!$model || $model->lot < 2) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        $type = 'back';
        if(isset($_GET['confirm'])) {
            $user = Users::model()->findByPk(Yii::app()->user->id);
            if ($model->iron)
                $user->iron += $model->iron;
            elseif ($model->bottles)
                $user->bottles += $model->bottles;
            
            if (!$user->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
            }
            if (!$model->delete()) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при операции с аукционом!'));
            }
            Yii::app()->user->setFlash('info', 'Вы забрали ресурсы с аукциона.');
            $this->redirect(array('/trade/index')); 
            Yii::app()->end();
        }

        $this->render('confirm', array('model' => $model, 'type' => $type, ));
    }
    
    /*
     * Покупаем ресурсы
     */
    public function actionBuy($id) {
        $model = Auction::model()->findByPk($id);
        if (!$model || $model->lot < 2) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        $type = 'buy';
        if(isset($_GET['confirm'])) {
            $user = Users::model()->findByPk(Yii::app()->user->id);
            
            if ($user->money < $model->price_out) {
                Yii::app()->user->setFlash('error', 'У вас недостаточно денег.');
                $this->redirect(Yii::app()->request->urlReferrer); 
                Yii::app()->end();
            }
            $user->money -= $model->price_out;
            if (!$user->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
            }
            //Отправляем почту купившему
            $id_dialog = Users::checkDialog(Yii::app()->user->id, 100);
            $mail = new UsersMessages();
            $mail->id_dialog = $id_dialog;
            $mail->id_user = 100;
            $mail->users = Yii::app()->user->id;
            $mail->type = 2;
            $mail->message = 'Покупка лота';
            if ($model->iron)
                $mail->iron = $model->iron;
            elseif ($model->bottles)
                $mail->bottles = $model->bottles;
            if (!$mail->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
            }
            
            //Отправляем почту продавцу
            $id_dialog = Users::checkDialog($model->id_user, 100);
            $mail = new UsersMessages();
            $mail->id_dialog = $id_dialog;
            $mail->id_user = 100;
            $mail->users = $model->id_user;
            $mail->type = 1;
            $mail->message = 'Лот выкуплен';
            $mail->money = $model->price_out;
            if (!$mail->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
            }

            if (!$model->delete()) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при операции с аукционом!'));
            }
            Yii::app()->user->setFlash('info', 'Вы купили ресурсы.');
            $this->redirect(array('/trade/index')); 
            Yii::app()->end();
        }

        $this->render('confirm', array('model' => $model, 'type' => $type, ));
    }
}