<?php
class ShopController extends Controller {
    public function accessRules() {
        return array(
            array('deny',
                'roles' => array('banned'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            ),
            array('allow',
                'actions' => array('index', 'list', 'avatars', 'ajaxGetItems', 'buy', 'view', 'buyAvatar', 'abilities', 'viewAbility'),
                'users' => array('@'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionIndex() {
        $this->render('index');
    }
    
    
    public function actionAbilities() {
        $info = 'знаешь что поможет тебе победить врага? Хороший навык!';
        $model = new ShopAbilities('search');

        $this->render('abilities', ['model' => $model, 'info' => $info]);
    }
    
    public function actionViewAbility($id) {
        $model = $this->loadModel($id, 'ShopAbilities');
		$ability = UsersAbilities::model()->findByAttributes(['id_user' => Yii::app()->user->id, 'id_ability' => $id]);
		if (isset($_GET['type'])) {
			$shop = ShopAbilitiesTypes::model()->findByAttributes(['id_ability' => $id, 'id_type' => $_GET['type']]);
			$user = Users::findUser();
			if ($user->money >= $shop->money && (!empty($ability) && $ability->idType->type < $shop->type || empty($ability))) {
				if (empty($ability)) {
					$ability = new UsersAbilities();
					$ability->id_user = $user->id_user;
					$ability->id_ability = $id;
				}
				$ability->id_type = $shop->id_type;
				$ability->save(false);
				Users::model()->updateByPk($user->id_user, ['money' => $user->money - $shop->money]);
				Yii::app()->user->setFlash('info', 'Вы успешно купили навык');
			}
			else {
				Yii::app()->user->setFlash('error', 'Недостаточно денег');
			}
            $this->redirect(['/shop/viewAbility', 'id' => $id]);
            Yii::app()->end();
		}
        $this->render('viewAbility', ['model' => $model, 'ability' => $ability]);
    }
	
    public function actionList($id = 4) {
        $ids = array(4);
        if (!in_array($id, $ids)) {
            $this->redirect('/shop/');
            Yii::app()->end();
        }
        $info = array(
            4 => 'Хищник - идеальный вариант для игроков, которые уже на 15 уровне хотят иметь приемущество!',
            6 => 'Сила - максимальная сила, слабая броня и средние здоровье и энергия',
            7 => 'Защитник - максимальная броня и здоровье, средняя сила, слабая энергия и регенерация',
            8 => 'Паладин - максимальная регенерация, остальные параметры средние',
            9 => '',
        );
        $this->render('list', array(
            'type' => $id,
            'info' => $info
        ));
    }
    
    public function actionView($item, $id_set, $type) {
        $ids = array(4);
        if (!in_array($id_set, $ids)) {
            $this->redirect('/shop/');
            Yii::app()->end();
        }
        $type = ((int)$type && (int)$type>2 && (int)$type<7 ? (int)$type : 3);
        $item = ShopItems::findItem($item);
        if (!$item) {
            $this->redirect('/shop/');
            Yii::app()->end();
        }
        $percents = array(3=>99, 140, 195, 275);
        $percent=$percents[$type]; 

        $item->img = $id_set.'/'.$type;
        $item->quality = $type;
        $item->sum = 0;
        foreach (FuncHelper::mainParams() as $param => $name){
            if ($item->$param) {
                $param_percent = $param.'_percent';
                $item->$param = round($item->$param + ($item->$param / 100) * $percent);
                $item->$param_percent = $percent;                
            }
        }
        /*
         * Выбираем аналогичную надетую шмотку у пользователя
         */
        $user_item = UserItems::findUserItem($item);
        if ($user_item)
            $compare = FuncHelper::compareStats($item, $user_item);
        else 
            $compare = FuncHelper::compareStats($item, $item);

        $this->render('view', array(
            'item' => $item, 
            'user_item' => $user_item, 
            'type' => $type, 
            'compare' => $compare, 
            'percent' => $percent
        ));
    }
    
    public function actionBuy($id, $id_set, $type) {
        $ids = array(4);
        if (!in_array($id_set, $ids)) {
            $this->redirect('/shop/');
            Yii::app()->end();
        }
        $type = ((int)$type && (int)$type>2 && (int)$type<7 ? (int)$type : 3);
        $percents = array(3=>99, 140, 195, 275);
        $prices = array(
            4=>array(3=>50, 100, 200, 300),
            6=>array(3=>100, 200, 400, 600),
            7=>array(3=>100, 200, 400, 600),
            8=>array(3=>100, 200, 400, 600),
            9=>array(3=>100, 200, 400, 600),
        );
        $percent=$percents[$type]; 
        $price=$prices[$id_set][$type];
        $all=$price*10;
        $user = Users::findUser();
        
	if ($id == 'all'){
            if ($all>$user->money)
               Yii::app()->user->setFlash('error', 'Недостаточно денег');
            else {
                $shop_items = ShopItems::model()->findAll('id_set=:id_set', array(':id_set'=>$id_set));
                if ($shop_items) {
                    foreach ($shop_items as $item) {
                        ShopItems::getNewItem($item->id_item, $type, Yii::app()->user->id);
                    }
                    $user->money -= $all;
                    if (!$user->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении данных пользователя!'));
                    }
                    Yii::app()->user->setFlash('info', 'Покупка отправлена на почту');
                }
            }
	}
	else {
            $item = ShopItems::model()->findByPk($id);
            if (!$item || $item->id_set != $id_set) {
                $this->redirect('/shop/');
                Yii::app()->end();
            }
            if ($price>$user->money)
               Yii::app()->user->setFlash('error', 'Недостаточно денег');
            else {
                ShopItems::getNewItem($id, $type, Yii::app()->user->id);
                $user->money -= $price;
                if (!$user->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении данных пользователя!'));
                }
                Yii::app()->user->setFlash('info', 'Покупка отправлена на почту');
            }
	}
        $this->redirect('/shop/');
        Yii::app()->end();
    }

        public function actionAjaxGetItems($id_set, $type) {
        $type = ((int)$type && (int)$type>2 && (int)$type<7 ? (int)$type : 3);
        $percents = array(3=>99, 140, 195, 275);
        $prices = array(
            4=>array(3=>50, 100, 200, 300),
            6=>array(3=>100, 200, 400, 600),
            7=>array(3=>100, 200, 400, 600),
            8=>array(3=>100, 200, 400, 600),
            9=>array(3=>100, 200, 400, 600),
        );
        $percent=$percents[$type]; 
        $price=$prices[$id_set][$type];

        $all=FuncHelper::Money($price*10);
        $sale=FuncHelper::Money($price*2);

        $criteria = new CDbCriteria;
        $criteria->compare('id_set', $id_set);
        $shop_items = ShopItems::model()->findAll($criteria);
        if ($shop_items) {
            foreach ($shop_items as $item) {
                $item->price = FuncHelper::Money($price);
                /*
                 * Выбираем аналогичную надетую шмотку у пользователя
                 */
                $item->sum = 0;
                foreach (FuncHelper::mainParams() as $param => $name){
                    if ($item->$param) {
                        $item->sum += ShopItems::calcParam($item->id_item, $param, $percents[$type]);
                    }
                }
                $user_item = UserItems::findUserItem($item);
                if ($user_item)
                    $item->better = ($item->sum > $user_item->sum ? $item->sum-$user_item->sum : false);
                else 
                    $item->better = $item->sum;
            }
        }
        else $shop_items = null;
        $this->renderPartial('_items', array(
            'items' => $shop_items, 
            'id_set' => $id_set, 
            'price' => $price,
            'all' => $all,
            'sale' => $sale, 
            'type' => $type
        ));
    }
    
    public function loadModel($id, $model = 'model') {
        $model = $model::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, Yii::t('admin_layout', 'Страница не найдена!'));
        return $model;
    }
}