<?php

class PumpitapiController extends Controller {

    public function accessRules() {
        return array(
            array('allow',
                'actions' => array('index'),
                'users' => array('*'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }

    public function actionIndex($action = null) {
        $pumpit_params = array();
        
        $pumpit_params['APP_ID'] = 92;              // id игры, выдает администрация Pumpit
        $pumpit_params['API_HOST'] = "http://pumpit.ru/riba_api/?"; // HOST PUMPIT
        $pumpit_params['KEY_API'] = 'UKHifLS4EjOHAlG9j';    // ключ подписи ко всем запросам кроме биллинговых, выдает администрация Pumpit
        $pumpit_params['KEY_BILLING'] = 'jjhX5YSPNtPf3EyNw';    // ключ подписи для биллинговых запросов, выдает администрация Pumpit
        $pumpit_params['LOG'] = '/var/log/pumpit.log';   // файл для записи логов

        // Если сессия пустая или сброс сессии,то пользователь не авторизован
        if (!isset($_SESSION['p_sid'])) {
            $_SESSION['pumpit_id'] = 0;
            $_SESSION['p_sid'] = '';
            $_SESSION['p_user_info'] = array();
        }

        // Сохраняем в сессии заголовки проксирования
        if (!isset($_SESSION['x_host']) && isset($_SERVER['HTTP_X_HOST'])) {
            $_SESSION['x_host'] = $_SERVER['HTTP_X_HOST'];
        }
        if (!isset($_SESSION['x_partner']) && isset($_SERVER['HTTP_X_PARTNER'])) {
            $_SESSION['x_partner'] = $_SERVER['HTTP_X_PARTNER'];
        }

        $pumpit = new Pumpit($pumpit_params);

        // Если пришел запрос GetAppOnline, то нужно вернуть число пользователей онлайн
        if (!empty($action) && ($action == 'GetAppOnline') && $pumpit->checkRequest($_SERVER['QUERY_STRING'])) {
            // Здесь реализовывается логика определения пользователей online и передается ответ Pumpit
            $online_number = Users::countOnline();
            $xml_response = '<?xml version="1.0" encoding="utf-8"?>
                <response>
                       <online>' . $online_number . '</online>
                </response>';
            echo $xml_response;
            exit();
        }
        
        // Если пришел запрос DoLogin то записываем в сессию
        if (!empty($action) && ($action == 'DoLogin') && $pumpit->checkRequest($_SERVER['QUERY_STRING'])) {
            $_SESSION['pumpit_id'] = (int)$_GET['login'];
            $_SESSION['p_sid'] = $_GET['p_sid'];
//            $res = $pumpit->getMyProfile($_GET['p_sid']);
//            if ($res) {
//                $_SESSION['p_user_info'] = $res;
//            }
            //Проверяем есть ли у пользователя персонаж в игре или нет
            $user = Users::findPartnerUser($_SESSION['pumpit_id']);
            if ($user->id_user) {
                $password = md5('pumpit'.$_SESSION['pumpit_id']);
                $login = new LoginForm;
                $login->login = $user->login;
                $login->password = $password;
                $login->login();
            }
            $this->redirect('http://'.$_SERVER['HTTP_X_HOST']);
            Yii::app()->end();
//            if (!empty($_GET['url'])) {
//                // Здесь нужно перекинуть пользователя по запрашиваемому url
//                $this->redirect($_GET['url']);
//                Yii::app()->end();
//            }
        }
        // Если пришел запрос PaymentOk то надо нотифицировать Pumpit о том что запрос принят и деньги переведены в игру
        if (!empty($action) && ($action == 'PaymentOk') && $pumpit->checkRequest($_SERVER['QUERY_STRING'], true)) {
            $query_string = $_SERVER['QUERY_STRING'];
            parse_str($query_string, $query);

            /* Теперь массив query содержит следующие данные
              action   - приходит всегда
              amount   - приходит всегда
              app_id   - приходит всегда
              coin     - приходит всегда
              login    - приходит всегда
              trans_id - приходит всегда
              sig      - приходит всегда
              app_tid  - приходит если был передан при запросе DoIncAppAccount как элемент массива третим параметром
              app_uid  - приходит если был передан при запросе DoIncAppAccount как элемент массива третим параметром

              Здесь надо реализовать логику зачисления и отправить Pumpit ответ

              если зачисление успешно то    $ans = '<status>OK</status>';
              если зачисление не успешно то $ans = '<status>CANCEL</status>';
             */
            $user = Users::findPartnerUser($query['login']);
            if ($user) {
                $params = array(
                    5 => 5,
                    10 => 10,
                    55 => 50,
                    300 => 250,
                    1000 => 800,
                );
                $key = array_search($query['coin'], $params);
                if (!isset($key)) {
                    echo '<status>CANCEL</status>';
                    exit();
                }
                $money = $key * 100;
                /**
                 * Для акции на премиум в подарок 
                 */
                if ($money >= 1000) {
                    $time = floor($money/1000);
                    $bonus = Actions::getBonusValue(4);
                    if ($bonus > 0 && $time > 0) {
                        if ($user->premium_time > time())
                            $user->premium_time += 60 * 60 * 24 * $time;
                        else
                            $user->premium_time = time() + 60 * 60 * 24 * $time;
                        if (!$user->save(false)) {
                            throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
                        } 
                    }
                }
                $id_dialog = Users::checkDialog($user->id_user, 100);
                $mail = new UsersMessages();
                $mail->id_dialog = $id_dialog;
                $mail->id_user = 100;
                $mail->users = $user->id_user;
                $mail->type = 1;
                $mail->message = 'Пополнение счета';
                $bonus = Actions::getBonusValue(1);
                $mail->money = $bonus ? round($money + ($money/100)*$bonus) : $money;
                if (!$mail->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                }
                
                //Проверяем достиг ли игрок 10 уровень и является ли он рефералом
                if ($user->level >= 10 && $user->id_ref > 0 && isset($user->idRef)) {
                    $money = round($money/10);
                    $id_dialog = Users::checkDialog($user->id_ref, 100);
                    $mail = new UsersMessages();
                    $mail->id_dialog = $id_dialog;
                    $mail->id_user = 100;
                    $mail->users = $user->id_ref;
                    $mail->type = 1;
                    $mail->message = 'Бонус за друга';
                    $mail->money = $money;
                    if (!$mail->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                    }
                }
                $log = new DonateLog();
                $log->id_user = $user->id_user;
                $log->tid = $query['trans_id'];
                $log->value = $key;
                $log->type = 5;
                $log->result = 1;
                $log->save(false);
                $ans = '<status>OK</status>';
            }
            else {
                $ans = '<status>CANCEL</status>';
            }
            echo $ans;
            exit();
        }
    }
}
