<?php

class PaymentController extends Controller {

    public function accessRules() {
        return array(
            array('deny',
                'roles' => array('banned'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            ),
            array('allow',
                'actions' => array('index', 'webmoney', 'xsolla', 'xbillForAPI', 'xsollaAPI'),
                'users' => array('*'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }

    public function actionIndex($type = 'mobilePayment') {
        $params = array();
        $secret_key = 'JsLzz,;@hezGx/cyQKQj(RRi;4+z]/aX';
        if ($type == 'mobilePayment' && isset($_POST['phone']) && isset($_POST['number'])) {
            $price = Yii::app()->request->getParam('number') * 2;
            $dopparam['user'] = Yii::app()->user->id;
            $dopparam['gold'] = Yii::app()->request->getParam('number');
            $mk = XBill::mk_create_pay(
                    Yii::app()->request->getParam('phone'), $price, 'Покупка в silawar.ru ' . Yii::app()->request->getParam('number') . ' золота (ID: ' . Yii::app()->user->id . ')', 'Золото отправлено. C ув. команда silawar.ru', $dopparam
            );
            if ($mk['status'] == 0) {
                $text = 'Платеж успешно создан, 
                Номер платежа в системе: : ' . $mk['id'] . '.
                На Ваш номер отправлено SMS, следуйте интсрукциям для получения золота';
                Yii::app()->user->setFlash('info', $text);
            } else {
                $text = 'Ошибка #' . $mk['status'] . ': ' . $mk['status_desc'];
                Yii::app()->user->setFlash('error', $text);
            }
            $this->redirect('/payment/');
            Yii::app()->end;
        }
        if ($type == 'mobilePaymentAlt' && isset($_POST['phone']) && isset($_POST['number'])) {
            //Подготовка параметров
            $request['command'] = 'invoice';
            $request['project'] = 22342;
            $request['v1'] = Yii::app()->user->id;
            $request['phone'] = Yii::app()->request->getParam('phone');
            $request['out'] = Yii::app()->request->getParam('number');
            // Формирование подписи
            $md5 = '';
            foreach ($request as $value) {
                $md5.= $value;
            }
            $request['md5'] = md5($md5 . $secret_key);
            // Формирование строки запроса
            $url = 'https://secure.xsolla.com/api/mobile/payment/index.php?';
            foreach ($request as $key => $value) {
                $url.=$key . '=' . urlencode($value) . '&';
            }
            $url = rtrim($url, '&');
            $answer = FuncHelper::sendCurl($url);
            if ($answer->result == 0) {
                $log = new DonateLog();
                $log->id_user = Yii::app()->user->id;
                $log->tid = $answer->invoice;
                $log->value = Yii::app()->request->getParam('number');
                $log->phone = Yii::app()->request->getParam('phone');
                $log->type = 3;
                $log->result = 0;
                if (!$log->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении лога!'));
                }
                Yii::app()->user->setFlash('info', 'Счет успешно выставлен, ожидайте SMS');
            } else {
                Yii::app()->user->setFlash('error', $answer->comment);
            }
//            $this->redirect('/payment/');
//            Yii::app()->end;
        } elseif ($type == 'terminals') {
            //Подготовка параметров
            $request['project'] = 22342;
            $request['v1'] = Yii::app()->user->id;
            $request['format'] = 'xml';
            // Формирование подписи
            $md5 = '';
            foreach ($request as $value) {
                $md5.= $value;
            }
            $request['md5'] = md5($md5 . $secret_key);
            // Формирование строки запроса
            $url = 'https://api.xsolla.com/xsolla_number.php?';
            foreach ($request as $key => $value) {
                $url.=$key . '=' . urlencode($value) . '&';
            }
            $url = rtrim($url, '&');
            $answer = FuncHelper::sendCurl($url);
            $params['number'] = $answer->number;
        } 
        elseif ($type == 'qiwi' && isset($_POST['phone']) && isset($_POST['number'])) {
            //Подготовка параметров
            $request['command'] = 'invoice';
            $request['project'] = 22342;
            $request['v1'] = Yii::app()->user->id;
            $request['phone'] = Yii::app()->request->getParam('phone');
            $request['out'] = Yii::app()->request->getParam('number');
            $request['ps'] = 'qiwi';
            // Формирование подписи
            $md5 = '';
            foreach ($request as $value) {
                $md5.= $value;
            }
            $request['md5'] = md5($md5 . $secret_key);
            // Формирование строки запроса
            $url = 'https://secure.xsolla.com/api/invoicing/index.php?';
            foreach ($request as $key => $value) {
                $url.=$key . '=' . urlencode($value) . '&';
            }
            $url = rtrim($url, '&');
            $answer = FuncHelper::sendCurl($url);
            if ($answer->result == 0) {
                $log = new DonateLog();
                $log->id_user = Yii::app()->user->id;
                $log->tid = $answer->invoice;
                $log->value = Yii::app()->request->getParam('number');
                $log->phone = Yii::app()->request->getParam('phone');
                $log->type = 4;
                $log->result = 0;
                if (!$log->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении лога!'));
                }
                Yii::app()->user->setFlash('info', 'Счет успешно выставлен. Теперь Вам необходимо оплатить его через терминал QIWI или на сайте <a href="http://wap.qiwi.ru">wap.qiwi.ru</a>');
            } else {
                Yii::app()->user->setFlash('error', $answer->comment);
            }
//            $this->redirect('/payment/', array('type' => 'qiwi'));
//            Yii::app()->end;
        } elseif ($type == 'webmoney') {
            $params = array(
                5 => 10,
                10 => 20,
                55 => 100,
                300 => 500,
                1000 => 1500,
            );
        } elseif ($type == 'free') {
            $criteria = new CDbCriteria();
            $criteria->compare('id_ref', Yii::app()->user->id);
            $criteria->addCondition('level >= 10');
            $params['count'] = Users::model()->count($criteria);
        } 
        elseif (isset($_SERVER['HTTP_X_HOST'])) {
            $pumpit = new Pumpit(Yii::app()->params->pumpit_params);
            // Если пользователь хочет перейти в кошелек Pumpit
            if ($type == 'wallet') {
                $url = $pumpit->doPumpitPayment($_SESSION['p_sid']);
                $this->redirect($url);
                Yii::app()->end();
            }
            $params = array(
                5 => 5,
                10 => 10,
                55 => 50,
                300 => 250,
                1000 => 800,
            );
            
            // Если пользователь хочет купить что-либо в игре
            if (isset($_POST['value'])) {
                $coins = (isset($params[$_POST['value']]) ? $params[$_POST['value']] : $params[10]);
                $url = $pumpit->doIncAppAccount($_SESSION['p_sid'], $coins);
                $this->redirect($url);
                Yii::app()->end();
            }
        }
        $this->render('index', array(
            'type' => $type,
            'params' => $params
        ));
    }

    public function actionWebmoney() {
        $result = Yii::app()->request->getParam('result');
        $id_user = Yii::app()->request->getParam('idChar');
        $value = Yii::app()->request->getParam('valueChar');
        if ($result && $result == 'success' && $id_user && $value) {
            $money = $value * 100;
            
            $user = Users::findUser($id_user);
            /**
             * Для акции на премиум в подарок 
             */
            if ($money > 1000) {
                $time = floor($money/1000);
                $bonus = Actions::getBonusValue(4);
                if ($bonus > 0 && $time > 0) {
                    if ($user->premium_time > time())
                        $user->premium_time += 60 * 60 * 24 * $time;
                    else
                        $user->premium_time = time() + 60 * 60 * 24 * $time;
                    if (!$user->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
                    } 
                }
            }
            $id_dialog = Users::checkDialog($id_user, 100);
            $mail = new UsersMessages();
            $mail->id_dialog = $id_dialog;
            $mail->id_user = 100;
            $mail->users = $id_user;
            $mail->type = 1;
            $mail->message = 'Пополнение счета';
            $bonus = Actions::getBonusValue(1);
            $mail->money = $bonus ? round($money + ($money/100)*$bonus) : $money;
            if (!$mail->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
            }

            $log = new DonateLog();
            $log->id_user = $id_user;
            $log->value = $value;
            $log->type = 1;
            $log->result = 1;
            if (!$log->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении лога!'));
            }
            
            //Проверяем достиг ли игрок 10 уровень и является ли он рефералом
            if ($user->level >= 10 && $user->id_ref > 0 && isset($user->idRef)) {
                $money = round($money/10);
                $id_dialog = Users::checkDialog($user->id_ref, 100);
                $mail = new UsersMessages();
                $mail->id_dialog = $id_dialog;
                $mail->id_user = 100;
                $mail->users = $user->id_ref;
                $mail->type = 1;
                $mail->message = 'Бонус за друга';
                $mail->money = $money;
                if (!$mail->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                }
            }
            $this->redirect('/mail/index', array('sort' => 'new'));
            Yii::app()->end();
        } elseif ($result && $result == 'fail') {
            Yii::app()->user->setFlash('error', 'Ошибка! Ваш счет не пополнен.');
            $this->redirect('/user/index');
            Yii::app()->end();
        }
    }

    public function actionBank() {

        $v1 = 'v1=' . Yii::app()->user->id . 'JsLzz,;@hezGx/cyQKQj(RRi;4+z]/aX';
        $project = 'project=22342';
        $sign = md5($project . $v1);
        $this->redirect('https://secure.xsolla.com/paystation2/?marketplace=mobile&project=12548&v1=' . Yii::app()->user->id . '&hidden=v1,project&local=ru&sign=' . $sign);
        $this->render('bank', array(
            'values' => $values
        ));
    }

    public function actionXsolla() {
        $v1 = 'v1=' . Yii::app()->user->id . 'JsLzz,;@hezGx/cyQKQj(RRi;4+z]/aX';
        $project = 'project=22342';
        $sign = md5($project . $v1);
        $this->redirect('https://secure.xsolla.com/paystation2/?marketplace=mobile&project=12548&v1=' . Yii::app()->user->id . '&hidden=v1,project&local=ru&sign=' . $sign);
    }

    public function actionXsollaAPI() {
        $xsolla = new Xsolla();
        $xsolla->process();
    }

    public function actionXbillForAPI() {
        if (
                isset($_GET['order']) &&
                isset($_GET['phone']) &&
                isset($_GET['order_status']) &&
                isset($_GET['merchant_price']) &&
                isset($_GET['paytouser']) &&
                isset($_GET['time']) &&
                isset($_GET['sign'])) {

            $secret_key = "hmONCD8TEa6SUeRd"; # Секретный ключ (Указан в настройках проекта)

            $order_id = (isset($_GET['order_id']) ? $_GET['order_id'] : null); # Номер заказа переданный Вами в форму оплаты.
            $order = $_GET['order']; # Уникальный номер платежа
            $phone = $_GET['phone']; # Номер телефона покупателя
            $order_status = $_GET['order_status']; # Статус платежа
            $merchant_price = $_GET['merchant_price']; # Сумма которую оператор списывает со счета покупателя
            $time = $_GET['time'];
            $sign = $_GET['sign']; # Контрольная подпись
            $id_user = (int) $_GET['user'];
            $gold = (int) $_GET['gold'];
            $money = $gold * 100;

            $truesign = md5($order . $phone . $merchant_price . $secret_key);
            if ($sign == $truesign) {
                # Если контрольная строка совпадает:
                echo "ok";
                if ($order_status == 'success') {
                    $user = Users::findUser($id_user);
                    /**
                     * Для акции на премиум в подарок 
                     */
                    if ($money >= 1000) {
                        $time = floor($money/1000);
                        $bonus = Actions::getBonusValue(4);
                        if ($bonus > 0 && $time > 0) {
                            if ($user->premium_time > time())
                                $user->premium_time += 60 * 60 * 24 * $time;
                            else
                                $user->premium_time = time() + 60 * 60 * 24 * $time;
                            if (!$user->save(false)) {
                                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
                            } 
                        }
                    }
                    
                    $id_dialog = Users::checkDialog($id_user, 100);
                    $mail = new UsersMessages();
                    $mail->id_dialog = $id_dialog;
                    $mail->id_user = 100;
                    $mail->users = $id_user;
                    $mail->type = 1;
                    $mail->message = 'Пополнение счета';
                    $bonus = Actions::getBonusValue(1);
                    $mail->money = $bonus ? round($money + ($money/100)*$bonus) : $money;
                    if (!$mail->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                    }

                    $log = new DonateLog();
                    $log->id_user = $id_user;
                    $log->value = $gold;
                    $log->phone = $phone;
                    $log->type = 3;
                    $log->result = 1;
                    if (!$log->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении лога!'));
                    }
                    
                    //Проверяем достиг ли игрок 10 уровень и является ли он рефералом
                    if ($user->level >= 10 && $user->id_ref > 0 && isset($user->idRef)) {
                        $money = round($money/10);
                        $id_dialog = Users::checkDialog($user->id_ref, 100);
                        $mail = new UsersMessages();
                        $mail->id_dialog = $id_dialog;
                        $mail->id_user = 100;
                        $mail->users = $user->id_ref;
                        $mail->type = 1;
                        $mail->message = 'Бонус за друга';
                        $mail->money = $money;
                        if (!$mail->save(false)) {
                            throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                        }
                    }
                }
            } else {
                echo "error(sign)";
                exit();
            }
        } else {
            echo "error(count(" . count($_GET) . "))";
            exit();
        }
    }
}
