<?php
class MastersController extends Controller {
    public function accessRules() {
        return array(
            array('deny',
                'roles' => array('banned'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            ),
            array('allow',
                'actions' => array('index', 'ironmaster', 'enchants'),
                'users' => array('@'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionIndex() {
        $this->render('index');
    }
    
    public function actionIronmaster($getXP = null) {
        $user = Users::findUser();
        $params = array();
        $min = BattleHelper::maxXP($user->level-1);
        $max = BattleHelper::maxXP($user->level);
        if ($user->xp > 0)
            $percent = 100-round(($user->xp-$min)*100/($max-$min));
        else
            $percent = 100;
        if ($user->level < 24) {
            $params[1] = array(
                'percent' => $percent,
                'value' => ($max-$user->xp),
                'price' => round((1000/100)*$percent)
                );
            $params[2] = array(
                'percent' => 10,
                'value' => round((($max-$min)/100)*10),
                'price' => 100
                );
            if (!UserDaily::check('ironmaster')) {
                $params[3] = array(
                    'percent' => 5,
                    'value' => round((($max-$min)/100)*5),
                    'price' => 10000
                    );
                $params[4] = array(
                    'percent' => 2,
                    'value' => round((($max-$min)/100)*2),
                    'price' => 5000
                    ); 
            }
        }
        elseif ($user->level < 30) {
            $params[1] = array(
                'percent' => $percent,
                'value' => ($max-$user->xp),
                'price' => round((2000/100)*$percent)
                );
            $params[2] = array(
                'percent' => 10,
                'value' => round((($max-$min)/100)*10),
                'price' => 200
                );
            if (!UserDaily::check('ironmaster')) {
                $params[3] = array(
                    'percent' => 5,
                    'value' => round((($max-$min)/100)*5),
                    'price' => 10000
                    );
                $params[4] = array(
                    'percent' => 2,
                    'value' => round((($max-$min)/100)*2),
                    'price' => 5000
                    ); 
            }
        }
        if ($getXP && intval($getXP) < 5 && intval($getXP) > 0) {
            if ($params[$getXP] && $getXP < 3) {
                if ($params[$getXP]['price'] > $user->money) {
                    Yii::app()->user->setFlash('error', 'Недостаточно денег');
                }
                else {
                    Yii::app()->user->setFlash('info', 'Вы получили '.$params[$getXP]['value'].' опыта');
                    $user->money -= $params[$getXP]['price'];
                    $user->xp += $params[$getXP]['value'];
                    if ($user->xp >= $max && $user->level < 30) {
                        $user->level += 1;
                        $params = Users::calcParam($user->id_user);
                        $user->health_now = $params->totalHealth*2;
                        $user->energy_now = $params->totalEnergy*2;
                    }
                    if (!$user->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении данных пользователя!'));
                    }
                }
            }
            elseif ($params[$getXP] && $getXP > 2) {
                if ($params[$getXP]['price'] > $user->iron) {
                    Yii::app()->user->setFlash('error', 'Недостаточно железа');
                }
                else {
                    Yii::app()->user->setFlash('info', 'Вы получили '.$params[$getXP]['value'].' опыта');
                    UserDaily::addToDaily('ironmaster');
                    $user->iron -= $params[$getXP]['price'];
                    $user->xp += $params[$getXP]['value'];
                    if ($user->xp >= $max && $user->level < 30) {
                        $user->level += 1;
                        $params = Users::calcParam($user->id_user);
                        $user->health_now = $params->totalHealth*2;
                        $user->energy_now = $params->totalEnergy*2;
                    }
                    if (!$user->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении данных пользователя!'));
                    }
                }
            }
            $this->redirect('/masters/ironmaster');
        }

        $this->render('ironmaster', array(
            'params' => $params
        ));
    }
    
    public function actionEnchants($id = null) {
        $user = Users::findUser();
        
        if ($id && UserItems::checkBodyItem($id)) {
            $item = UserItems::model()->findByPk($id);
            
            if ($item->quality >5) 
                $iron_price = 5000;
            elseif ($item->quality >4) 
                $iron_price = 2500;
            elseif ($item->quality >3) 
                $iron_price = 1000;
            else 
                $iron_price = 250;
            
            $prices = array(1=>$iron_price, 1000, 5000, 25000, 100000, 500000);
            $value = array(1=>75, 100, 150, 200, 250, 350);

            $stats_list = array(
                '1' => array('health'=>'здоровья', 'armor'=>'брони'),
                '2' => array('health'=>'здоровья', 'energy'=>'энергии'),
                '3' => array('health'=>'здоровья', 'regeneration'=>'регенерации'),
                '4' => array('regeneration'=>'регенерации', 'energy'=>'энергии'),
                '5' => array('energy'=>'энергии', 'armor'=>'брони'),
                '6' => array('strength'=>'силы', 'health'=>'здоровья'),
                '7' => array('armor'=>'брони', 'regeneration'=>'регенерации'),
                '8' => array('energy'=>'энергии', 'health'=>'здоровья'),
                '9' => array('strength'=>'силы', 'armor'=>'брони'),
                '10' => array('regeneration'=>'регенерации', 'strength'=>'силы'),
                '11' => array('strength'=>'силы', 'regeneration'=>'регенерации'),
                '12' => array('energy'=>'энергии', 'strength'=>'силы'),
            );
            $stats = $stats_list[$item->type];
            for ($i = ($item->enchant_type ? $item->enchant_type : 1); $i<=6; $i++) {
                $params[$i] = array(
                    'price' => $prices[$i],
                    'value' => $value[$i]
                );
            }
            
            if (Yii::app()->request->getParam('type') && array_key_exists(Yii::app()->request->getParam('type'), $stats) && Yii::app()->request->getParam('enchant')) {
                $enchant = Yii::app()->request->getParam('enchant');
                $type = Yii::app()->request->getParam('type');
                $item_name = 'enchant_'.$type;
                if ($item->enchant_type > $enchant || $enchant > 6) {
                    $this->redirect(array('/masters/enchants', 'id'=>$id));
                }
                if ($enchant < 2 && $params[$enchant]['price'] > $user->iron) {
                    Yii::app()->user->setFlash('error', 'Недостаточно железа');                    
                }
                elseif ($enchant > 1 && $params[$enchant]['price'] > $user->money) {
                    Yii::app()->user->setFlash('error', 'Недостаточно золота');                    
                } 
                else {
                    if ($item->enchant_type) {
                        $item->enchant_strength = 0;
                        $item->enchant_health = 0;
                        $item->enchant_energy = 0;
                        $item->enchant_regeneration = 0;
                        $item->enchant_armor = 0;
                    }
                    if ($enchant < 2) {
                        $user->iron -= $params[$enchant]['price'];
                    }
                    else {
                        $user->money -= $params[$enchant]['price'];
                    }
                    /*Срабатывает шанс рандома лучшей чары*/
                    $text='';
                    if ($enchant < 6 && rand(1,100) > 89) {
                        $enchant++;
                        $text = ' Удача улыбнулась Вам!';
                    }
                    $item->enchant_type = $enchant;
                    $item->$item_name = $params[$enchant]['value'];
                    if (!$user->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении данных пользователя!'));
                    }
                    if (!$item->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении информации о предмете!'));
                    }
                    Yii::app()->user->setFlash('info', 'Вы зачаровали вещь.'.$text);
                }
                $this->redirect(array('/masters/enchants', 'id'=>$id));
            }
            $this->render('enchants_view', array(
                'item' => $item,
                'params' => $params,
                'stats' => $stats,
            )); 
        }
        else {
            $criteria = new CDbCriteria;
            $criteria->select = array('id_item', 'level', 'img');
            $criteria->compare('id_user', Yii::app()->user->id);
            $criteria->compare('status', ITEM_ON_BODY);
            $criteria->order = 'type ASC';
            $user_items = UserItems::model()->findAll($criteria);

            $this->render('enchants', array(
                'user_items' => $user_items,
            )); 
        }
    }
}