<?php

class ItemController extends Controller {

    public function accessRules() {
        return array(
            array('deny',
                'roles' => array('banned'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            ),
            array('allow',
                'actions' => array('index', 'backpack', 'destroy', 'in', 'repair', 'repairAll', 'store'),
                'users' => array('@'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }

    public function actionIndex($id) {
        $item = UserItems::findItem($id);
        if (!$item) {
            $this->render('index', array(
                'item' => $item,
            ));
            Yii::app()->end();
        }
        $model = Users::findUser();
        $item->user = Users::getLoginWithLink($item->id_user);
        /*
         * Выбираем аналогичную надетую шмотку у пользователя
         */
        $user_item = UserItems::findUserItem($item);
        if ($user_item)
            $compare = FuncHelper::compareStats($item, $user_item);
        else
            $compare = FuncHelper::compareStats($item, $item);

        $this->render('index', array(
            'model' => $model,
            'item' => $item,
            'user_item' => $user_item,
            'compare' => $compare,
        ));
    }

    /*
     * Одвеваем вещь
     */

    public function actionIn($id) {
        $user = Users::findUser();
        //Проверяем доступна ли эта вещь к одеванию
        $criteria = new CDbCriteria;
        $criteria->condition = 'level <= ' . $user->level . ' AND status < 3';
        $criteria->compare('id_item', $id);
        $criteria->compare('id_user', Yii::app()->user->id);
        $item = UserItems::model()->find($criteria);
        if (!$item) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        //Проверяем надета ли вещь на этот слот
        $criteria = new CDbCriteria;
        $criteria->compare('status', ITEM_ON_BODY);
        $criteria->compare('type', $item->type);
        $criteria->compare('id_user', Yii::app()->user->id);
        $userItem = UserItems::model()->find($criteria);
        //Если есть вещь, снимаем ее и отнимаем показатели хп\энергии
        if (!empty($userItem)) {
            $userItem->status = ITEM_IN_BACKPACK;
            if (!$userItem->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении предмета!'));
            }
        }
        //Одеваем вещь, приват и добавляем хп\энергию
        $item->status = ITEM_ON_BODY;
        $item->personal = 1;
        if (!$item->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении предмета!'));
        }
        Yii::app()->user->setFlash('info', 'Вы успешно надели ' . UserItems::itemName($id, 0));
        $this->redirect(Yii::app()->request->urlReferrer);
    }

    /*
     * Кладем вешь в рюкзак
     */

    public function actionBackpack($id) {
        $user = Users::findUser();
        //Проверяем пренадлежит ли эта вещь пользователю
        $criteria = new CDbCriteria;
        $criteria->condition = 'status < 3';
        $criteria->compare('id_item', $id);
        $criteria->compare('id_user', Yii::app()->user->id);
        $item = UserItems::model()->find($criteria);
        if (!$item) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        //Проверяем кол-во вещей в рюкзаке
        $count = UserItems::model()->countByAttributes(array('id_user' => Yii::app()->user->id, 'status' => ITEM_IN_BACKPACK));
        if ($count < $user->backpack) {
            //Если вещь надета, отнимаем хп\энергию
            $item->status = ITEM_IN_BACKPACK;
            if (!$item->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении предмета!'));
            }
        } else {
            Yii::app()->user->setFlash('error', 'В рюкзаке слишком мало места.');
        }
        $this->redirect(Yii::app()->request->urlReferrer);
    }

    /*
     * Кладем вещь в сундук
     */

    public function actionStore($id) {
        $user = Users::findUser();
        //Проверяем пренадлежит ли эта вещь пользователю
        $criteria = new CDbCriteria;
        $criteria->condition = 'status < 3';
        $criteria->compare('id_item', $id);
        $criteria->compare('id_user', Yii::app()->user->id);
        $item = UserItems::model()->find($criteria);
        if (!$item) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }

        //Проверяем кол-во вещей в сундуке
        $count = UserItems::model()->countByAttributes(array('id_user' => Yii::app()->user->id, 'status' => ITEM_IN_STORE));
        if ($count < $user->store) {
            //Если вещь надета, отнимаем хп\энергию
            $item->status = ITEM_IN_STORE;
            if (!$item->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении предмета!'));
            }
        } else {
            Yii::app()->user->setFlash('error', 'В сундуке слишком мало места.');
        }
        $this->redirect(Yii::app()->request->urlReferrer);
    }

    /*
     * Разбираем вещь
     */

    public function actionDestroy($id) {
        $user = Users::findUser();
        //Проверяем пренадлежит ли эта вещь пользователю
        $criteria = new CDbCriteria;
        $criteria->condition = 'status < 3';
        $criteria->compare('id_item', $id);
        $criteria->compare('id_user', Yii::app()->user->id);
        $item = UserItems::model()->find($criteria);
        if (!$item) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        $user->iron += $item->hardness;
        $item->status = ITEM_DESTROY;
        if (!$user->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
        }
        if (!$item->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении предмета!'));
        }
        Yii::app()->user->setFlash('info', 'Вы получили <img src="/images/icons/iron.png" alt="*">' . $item->hardness . ' за ' . UserItems::itemName($id, 0));
        $this->redirect('/user/backpack/');
    }

    /*
     * Чиним вещь
     */

    public function actionRepair($id) {
        $user = Users::findUser();
        //Проверяем пренадлежит ли эта вещь пользователю
        $criteria = new CDbCriteria;
        $criteria->condition = 'status < 3';
        $criteria->compare('id_item', $id);
        $criteria->compare('id_user', Yii::app()->user->id);
        $item = UserItems::model()->find($criteria);
        if (!$item) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        $iron = $item->hardness_max - $item->hardness;
        if ($user->iron >= $iron) {
            $user->iron -= $iron;
            if (!$user->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
            }
            $item->hardness = $item->hardness_max;
            if (!$item->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении предмета!'));
            }
            Yii::app()->user->setFlash('info', 'Вы починили ' . UserItems::itemName($id, 0));
        } else
            Yii::app()->user->setFlash('error', 'Недостаточно железа');
        $this->redirect(Yii::app()->request->urlReferrer);
    }

    public function actionRepairAll() {
        $user = Users::findUser();
        $summary = 0;
        $criteria = new CDbCriteria;
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->addCondition('hardness < hardness_max');
        $criteria->compare('status', ITEM_ON_BODY);
        $items = UserItems::model()->findAll($criteria);
        foreach ($items as $item) {
            $summary += $item->hardness_max - $item->hardness;
        }
        if ($summary > $user->iron) {
            Yii::app()->user->setFlash('error', 'Недостаточно <img src="/images/icons/iron.png" alt="*">железа.');
        } else {
            foreach ($items as $item) {
                $item->hardness = $item->hardness_max;
                if (!$item->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении предмета!'));
                }
            }
            $user->iron -= $summary;
            if (!$user->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
            }
            Yii::app()->user->setFlash('info', 'Вы починили все вещи');
        }
        $this->redirect('/user/body/');
        Yii::app()->end();
    }

}
