<?php
class AuctionController extends Controller {
    public function accessRules() {
        return array(
            array('deny',
                'roles' => array('banned'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            ),
            array('allow',
                'actions' => array('index', 'back', 'in', 'out', 'step', 'view'),
                'users' => array('@'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionIndex() {
        $model = new Auction('search');
        $model->unsetAttributes();
        $filter = FuncHelper::auctionFilters();
        if (isset($_POST['Auction'])) {
            $model->attributes = $_POST['Auction'];
            if ($model->level) {
                $model->max_level = $model->level + 4;
            }
        }
        $this->render('index', array('model' => $model, 'filter' => $filter,));
    }

    /*
     * Продаем предмет на аук
     */

    public function actionIn($id) {
        $model = new Auction;
        $user = Users::findUser();
        $criteria = new CDbCriteria;
        $criteria->addInCondition('status', array(ITEM_IN_BACKPACK, ITEM_IN_STORE));
        $criteria->compare('id_item', $id);
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->addCondition('personal = 0');
        $item = UserItems::model()->find($criteria);
        if (!$item) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }
        $item->user = Users::getLoginWithLink($item->id_user);

        if (isset($_POST['Auction'])) {
            $model->attributes = $_POST['Auction'];
            $model->lot = AUCTION_ITEM;
            $model->id_item = $id;
            $model->price = $model->min_price_gold * 100 + $model->min_price_silver;
            $model->price_out = $model->max_price_gold * 100 + $model->max_price_silver;
            if ($model->save()) {
                $item->status = ITEM_IN_AUCTION;
                if (!$item->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении предмета!'));
                }
//                $user->money -= 5;
//                if (!$user->save(false)) {
//                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
//                }
                Yii::app()->user->setFlash('info', 'Ваш товар выставлен на аукцион.');
                $this->redirect(array('/auction/index'));
                Yii::app()->end();
            }
        }

        $this->render('in', array(
            'model' => $model,
            'item' => $item,
            'user' => $user)
        );
    }

    /*
     * Выводит информацию о предмете
     */

    public function actionView($id) {
        $model = Auction::model()->findByPk($id);
        if (!$model || $model->time < time()) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }

        if (isset($_POST['Auction'])) {
            $model->attributes = $_POST['Auction'];
            $user = Users::findUser();
            $money = $model->price_step_gold * 100 + $model->price_step_silver;
            if ($money > $model->price_out)
                $money = $model->price_out;
            if ($user->money < $money) {
                Yii::app()->user->setFlash('error', 'У вас недостаточно денег.');
                $this->redirect(Yii::app()->request->urlReferrer);
                Yii::app()->end();
            }
            if ($model->last) {
                $id_dialog = Users::checkDialog($model->last, 100);
                $mail = new UsersMessages();
                $mail->id_dialog = $id_dialog;
                $mail->id_user = 100;
                $mail->users = $model->last;
                $mail->type = 1;
                $mail->message = 'Вашу ставку перебили';
                $mail->money = $model->price;
                if (!$mail->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                }
            }
            $model->last = Yii::app()->user->id;
            $model->price = $money;

            if (!$model->save()) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении действий аукциона!'));
            }
            $user->money -= $money;
            if (!$user->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
            }

            Yii::app()->user->setFlash('info', 'Вы успешно повысили ставку.');
            $this->redirect(Yii::app()->request->urlReferrer);
            Yii::app()->end();
        }
        $auction['nextStep'] = FuncHelper::auctionNextStep($model);
        $model->price_step_gold = $auction['nextStep']['gold'];
        $model->price_step_silver = $auction['nextStep']['silver'];

        $auction['step'] = FuncHelper::money($auction['nextStep']['step']);
        $auction['price'] = FuncHelper::money($model->price);
        $auction['price_out'] = FuncHelper::money($model->price_out);
        $auction['timeLeft'] = FuncHelper::auctionTimeLeft($model->time);

        $user_item = UserItems::findUserItem($model->idItem);        
        $this->render('view', array(
            'model' => $model, 
            'auction' => $auction, 
            'user_item' => $user_item,
        ));
    }

    /*
     * Забираем вещь с аука
     */

    public function actionBack($id) {
        $model = Auction::model()->findByPk($id);
        if (!$model || $model->last > 0) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }

        if (Auction::backItem($model)) {
            if (!$model->delete()) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при операции с аукционом!'));
            }
        }

        Yii::app()->user->setFlash('info', 'Вы забрали свою вещь с аукциона.');
        $this->redirect(array('/auction/index'));
        Yii::app()->end();
    }

    /*
     * Повышаем ставку через ссылку
     */

    public function actionStep($id) {
        $model = Auction::model()->findByPk($id);
        if (!$model) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }

        $user = Users::findUser();
        $money = FuncHelper::auctionNextStep($model, true);
        if ($user->money < $money) {
            Yii::app()->user->setFlash('error', 'У вас недостаточно денег.');
            $this->redirect(Yii::app()->request->urlReferrer);
            Yii::app()->end();
        }
        if ($model->last) {
            $id_dialog = Users::checkDialog($model->last, 100);
            $mail = new UsersMessages();
            $mail->id_dialog = $id_dialog;
            $mail->id_user = 100;
            $mail->users = $model->last;
            $mail->type = 1;
            $mail->message = 'Вашу ставку перебили';
            $mail->money = $model->price;
            if (!$mail->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
            }
        }
        $model->last = Yii::app()->user->id;
        $model->price = $money;
        if (!$model->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении действий аукциона!'));
        }
        $user->money -= $money;
        if (!$user->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
        }
        Yii::app()->user->setFlash('info', 'Вы успешно повысили ставку.');
        $this->redirect(Yii::app()->request->urlReferrer);
        Yii::app()->end();
    }

    /*
     * Выкупаем товар
     */

    public function actionOut($id) {
        $model = Auction::model()->findByPk($id);
        if (!$model) {
            $this->redirect(Yii::app()->user->returnUrl);
            Yii::app()->end();
        }

        $user = Users::findUser();
        if ($user->money < $model->price_out) {
            Yii::app()->user->setFlash('error', 'У вас недостаточно денег.');
            $this->redirect(Yii::app()->request->urlReferrer);
            Yii::app()->end();
        }

        $user->money -= $model->price_out;
        if (!$user->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
        }

        if ($model->last) {
            $id_dialog = Users::checkDialog($model->last, 100);
            $mail = new UsersMessages();
            $mail->id_dialog = $id_dialog;
            $mail->id_user = 100;
            $mail->users = $model->last;
            $mail->type = 1;
            $mail->message = 'Ваша ставка возвращена, лот выкупили';
            $mail->money = $model->price;
            if (!$mail->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
            }
        }

        $id_dialog = Users::checkDialog(Yii::app()->user->id, 100);
        $mail = new UsersMessages();
        $mail->id_dialog = $id_dialog;
        $mail->id_user = 100;
        $mail->users = Yii::app()->user->id;
        $mail->type = 3;
        $mail->message = 'Покупка лота';
        $mail->item = $model->id_item;
        if (!$mail->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
        }

        //Назначаем вещи нового владельца
        $item = UserItems::model()->findByPk($model->id_item);
        $item->id_user = Yii::app()->user->id;
        $item->status = ITEM_IN_MAIL;
        if (!$item->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке предмета!'));
        }

        //Забираем процент
        $price = $model->price_out;
        $percent = (round($price / 20) < 5 ? 5 : round($price / 20));
        $price -= $percent;

        //Отправляем почту продавцу
        $id_dialog = Users::checkDialog($model->id_user, 100);
        $mail = new UsersMessages();
        $mail->id_dialog = $id_dialog;
        $mail->id_user = 100;
        $mail->users = $model->id_user;
        $mail->type = 1;
        $mail->message = 'Лот выкуплен';
        $mail->money = $price;
        if (!$mail->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
        }

        if (!$model->delete()) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при удалении аукциона!'));
        }
        Yii::app()->user->setFlash('info', 'Предмет отправлен на почту.');
        $this->redirect('/auction/index');
        Yii::app()->end();
    }

}
