<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');
// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
    'basePath' => dirname(__FILE__) . DIRECTORY_SEPARATOR . '..',
    'name' => 'Атрея',
    'sourceLanguage' => 'ru',
    'language' => 'ru',
    'timeZone' => 'Europe/Moscow',
    // autoloading model and component classes
    'import' => require(dirname(__FILE__) . '/import.php'),
    'modules' => array(
        'panel',
    ),
    // application components
    'components' => array(
        'request' => array(
            'enableCsrfValidation' => false,
            'hostInfo'=>'http://'.(isset($_SERVER['HTTP_X_HOST']) ? $_SERVER['HTTP_X_HOST'] : $_SERVER['HTTP_HOST']),
        ),
        'coreMessages' => array(/* ищем языковые файлы в папках messages проекта, а не фреймворка. */
            'basePath' => null,
        ),
        'ih'=>array(
            'class'=>'application.extensions.ImageHandler.CImageHandler',
        ),
        'email'=>array(
                'class'=>'application.extensions.email.Email',
                'delivery'=>'php',
        ),
        'user' => array(
            'class' => 'WebUser',
            // enable cookie-based authentication
            'allowAutoLogin' => true,
        ),
        'authManager' => array(
            // Будем использовать свой менеджер авторизации
            'class' => 'PhpAuthManager',
            // Роль по умолчанию. Все, кто не админы, модераторы и юзеры — гости.
            'defaultRoles' => array('guest'),
        ),
        // uncomment the following to enable URLs in path-format
        'urlManager' => array(
            //'class' => 'application.components.UrlManager',
            'urlFormat' => 'path',
            'caseSensitive' => true,
            'showScriptName' => false,
            'appendParams' => false,
            'urlSuffix' => '/',
            'rules' => require(dirname(__FILE__) . '/routes.php'),
        ),
        'errorHandler' => array(
            // use 'site/error' action to display errors
            'errorAction' => 'site/error',
        ),
    ),
    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params' => require(dirname(__FILE__) . '/params.php'),
);
