<?php

class ItemView extends CWidget {

public $item;
public $type = 1;

    public function run() {
        /**
         * Сравнивает параметры на вещах
         * @param obj $item Вещь для просмотра
         * @param string $type тип, если 1 значит вещь юзера
         * @return type
         */
            if ($this->type == 1) {
                $second_item = UserItems::findUserItem($this->item);
            }
            $compare = array();
            foreach (FuncHelper::mainParams() as $param => $name) {
                if ($second_item) {
                    if ($this->item->$param > $second_item->$param) {
                        $compare[$param] = '<span class="green">' . $this->item->$param . '</span>';
                    }
                    elseif ($this->item->$param < $second_item->$param) {
                        $compare[$param] = '<span class="red">' . $this->item->$param . '</span>';
                    } else {
                        $compare[$param] = $this->item->$param;
                    }
                } else {
                    if (isset($this->item->id_user) && $this->item->id_user == Yii::app()->user->id && $this->item->status == ITEM_ON_BODY) {
                        $compare[$param] = $this->item->$param;
                    } else {
                        $compare[$param] = '<span class="green">' . $this->item->$param . '</span>';
                    }
                }
            }

            $this->item->sum = $this->item->health + $this->item->armor + $this->item->strength + $this->item->regeneration + $this->item->energy;
            if (isset($this->item->enchant_strength)) {
               $this->item->sum += $this->item->enchant_strength+$this->item->enchant_energy+$this->item->enchant_regeneration+$this->item->enchant_health+$this->item->enchant_armor;
            }
            if ($second_item) {
                $better = ($this->item->sum > $second_item->sum ? $this->item->sum - $second_item->sum : false);
            } else {
                if (isset($this->item->id_user) && $this->item->id_user == Yii::app()->user->id && $this->item->status == ITEM_ON_BODY) {
                    $better = 0;
                } else {
                    $better = $this->item->sum;
                }
            }
            $this->render('itemView', array(
                'item' => $this->item,
                'compare' => $compare,
                'better' => $better
            ));
        }
    }

?>
