<?php
class Xsolla extends VirtualCurrencyXsolla {

    public function userExists($user) {
        //query the db to see if user exists
        $criteria = new CDbCriteria();
        $criteria->compare('id_user', $user);
        return Users::model()->count($criteria) > 0;
    }

    public function paySuccess($id_user, $sum, $invoiceID) {
        $money = $sum * 100;
        
        $user = Users::findUser($id_user);
        /**
         * Для акции на премиум в подарок 
         */
        if ($money >= 1000) {
            $time = floor($money/1000);
            $bonus = Actions::getBonusValue(4);
            if ($bonus > 0 && $time > 0) {
                if ($user->premium_time > time())
                    $user->premium_time += 60 * 60 * 24 * $time;
                else
                    $user->premium_time = time() + 60 * 60 * 24 * $time;
                if (!$user->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
                } 
            }
        }
        $id_dialog = Users::checkDialog($id_user, 100);
        $mail = new UsersMessages();
        $mail->id_dialog = $id_dialog;
        $mail->id_user = 100;
        $mail->users = $id_user;
        $mail->type = 1;
        $mail->message = 'Пополнение счета';
        $bonus = Actions::getBonusValue(1);
        $mail->money = $bonus ? round($money + ($money/100)*$bonus) : $money;
        if (!$mail->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
        }
        
        //Проверяем достиг ли игрок 10 уровень и является ли он рефералом
        if ($user->level >= 10 && $user->id_ref > 0 && isset($user->idRef)) {
            $money = round($money/10);
            $id_dialog = Users::checkDialog($user->id_ref, 100);
            $mail = new UsersMessages();
            $mail->id_dialog = $id_dialog;
            $mail->id_user = 100;
            $mail->users = $user->id_ref;
            $mail->type = 1;
            $mail->message = 'Бонус за друга';
            $mail->money = $money;
            if (!$mail->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
            }
        }
        $log = DonateLog::model()->findByAttributes(array('tid'=>$invoiceID));
        $log->result = 1;
        $log->save(false);
    }

    public function payCancel($invoiceID) {
        $log = DonateLog::model()->findByAttributes(array('tid'=>$invoiceID, 'type'=>2));
    }

    public function invoiceExists($invoiceID) {
        //query db to see if invoice exists
        $log = DonateLog::model()->countByAttributes(array('tid'=>$invoiceID, 'type'=>2));
        return $log > 0;
    }

    public function newInvoice($invoiceID, $userID, $sum) {
            //insert new invoice into db
            $log = new DonateLog();
            $log->id_user = $userID;
            $log->tid = $invoiceID;
            $log->value = $sum;
            $log->type = 2;
            if (!$log->save(false)) {
                throw new Exception('error creating payment.');
            }
    }

    public function cancelInvoice($invoiceID) {
        //check if order is already canceled
        $log = DonateLog::model()->findByAttributes(array('tid'=>$invoiceID, 'type'=>2, 'result'=>0));
        //cancel if this invoice has not been canceled already
        if (!$log) {
            $log = DonateLog::model()->findByAttributes(array('tid'=>$invoiceID));
            $log->result = 0;
            $log->save(false);
        }
    }

}

?>