<?php

class WebUser extends CWebUser {

    private $_model = null;

    function init() {
        parent::init();
        $this->_model = $this->getModel();
        if ($this->_model !== null) {
            $this->_model->last_visit = time();
            $this->_model->update(array('last_visit'));
        }
    }

    private function getModel() {
        if (!$this->isGuest && $this->_model === null) {
            $criteria = new CDbCriteria();
            $criteria->with = array('idRole.idCat');
            $criteria->together = true;
            $criteria->select = array('t.login', 't.mute_time', 't.xp', 't.side', 't.level', 't.health_now', 't.energy_now', 'idRole.value_role as value_role', 'idCat.id_cat_role as id_cat_role');
            $criteria->compare('t.id_user', $this->id);
            $this->_model = Users::model()->find($criteria);
        }
        return $this->_model;
    }
    
    function getRole() {
        $user = $this->_model;

        if ($user == null) {
            return "guest";
        } else {
            return $user->value_role; /* символьное представление роли на инглише. Например, "player". */
        }
    }
    
    function getRoleCat() {
        $user = $this->_model;

        if ($user == null) {
            return 4; /* возвращаем идентификатор категории "гостя", если категория роли не заполнена */
        } else {
            return $user->id_cat_role;
        }
    }
    
    function getLogin() {
        $user = $this->_model;

        if ($user == null) {
            return null;
        } else {
            return $user->login;
        }
    }    
    
    function getMute() {
        $user = $this->_model;

        if ($user == null) {
            return null;
        } else {
            return $user->mute_time;
        }
    }
    
    function getLevel() {
        $user = $this->_model;

        if ($user == null) {
            return null;
        } else {
            return $user->level;
        }
    }
    
    function getSide() {
        $user = $this->_model;

        if ($user == null) {
            return null;
        } else {
            return $user->side;
        }
    }
    
    function getUserHealth() {
        $user = $this->_model;

        if ($user == null) {
            return null;
        } else {
            return $user->health_now;
        }
    }
    
    function getUserEnergy() {
        $user = $this->_model;

        if ($user == null) {
            return null;
        } else {
            return $user->energy_now;
        }
    }
        
    function getMoney() {
        $user = $this->_model;

        if ($user == null) {
            return null;
        } else {
            return $user->money;
        }
    }
    
    function getXP() {
        $user = $this->_model;

        if ($user == null) {
            return 0;
        } else {
            $min = BattleHelper::maxXP($user->level-1);
            $max = BattleHelper::maxXP($user->level);
            $xp = round(($user->xp-$min)*100/($max-$min));
            return ($xp > 100 ? 100 : $xp);
        }
    } 
}
