<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity {
    // Будем хранить id.
    protected $_id;
    
    // Данный метод вызывается один раз при аутентификации пользователя.
    public function authenticate(){       
        $user = Users::model()->find('LOWER(login)=? AND id_role NOT IN(4,5,6)', array(strtolower($this->login)));        
        if(($user===null) || (md5(md5($this->password))!==$user->password)) {
            $this->errorCode = self::ERROR_USERNAME_INVALID;
        } else {
            // В качестве идентификатора будем использовать id, а не username,
            // как это определено по умолчанию. Обязательно нужно переопределить
            // метод getId(см. ниже).
            $this->_id = $user->id_user;
 
            // Далее логин нам не понадобится, зато имя может пригодится
            // в самом приложении. Используется как Yii::app()->user->name.
            // realName есть в нашей модели. У вас это может быть name, firstName
            // или что-либо ещё.
//            $user->ip = CHttpRequest::getUserHostAddress();
//            $user->ua = CHttpRequest::getUserAgent();
            $user->save();
            $this->errorCode = self::ERROR_NONE;            
        }
        return !$this->errorCode;
    }
 
    public function getId(){
        return $this->_id;
    }
}