<?php

class TimeToString extends CApplicationComponent {

    public static function secs_to_h($secs) {
        $units = array(
            "week" => 7 * 24 * 3600,
            "day" => 24 * 3600,
            "hour" => 3600,
            "minute" => 60,
            "second" => 1,
        );

        // specifically handle zero
        if ($secs == 0)
            return "0 seconds";

        $s = "";

        foreach ($units as $name => $divisor) {
            if ($quot = intval($secs / $divisor)) {
                $s .= "$quot $name";
                $s .= (abs($quot) > 1 ? "s" : "") . ", ";
                $secs -= $quot * $divisor;
            }
        }

        return substr($s, 0, -2);
    }

    /*public static function secs_to_v($secs) {
        $units = array(
            "weeks" => 7 * 24 * 3600,
            "days" => 24 * 3600,
            "hours" => 3600,
            "minutes" => 60,
            "seconds" => 1,
        );

        foreach ($units as &$unit) {
            $quot = intval($secs / $unit);
            $secs -= $quot * $unit;
            $unit = $quot;
        }

        return $units;
    }*/
    
    public static function secs_to_v($secs) {
        $units = array(
            //"weeks" => 7 * 24 * 3600,
            //"days" => 24 * 3600,
            "hours" => 3600,
            "minutes" => 60,
            "seconds" => 1,
        );

        foreach ($units as &$unit) {
            $quot = intval($secs / $unit);
            $secs -= $quot * $unit;
            $unit = $quot;
        }

        foreach($units as $key=>$value)
        {
        if(strlen($value)==1)
            $units[$key] = '0'.$value;
        }
        
        
        return implode(':', $units);
        //return $units;
    }
    
    

}
