<?php

/**
 * Здесь находятся функции управления доступами к экшнам для ролей. 
 *  */
class RoleAccessHelper extends CComponent {

    public static $actions_list = array('xsollaAPI','xbillForAPI', 'webmoney', 'xsolla');

    /**
     * Проверяет есть ли доступ к указанному экшну для роли текущего залогиненного пользователя
     * @param string $action текстовое представление экшна, например, "index","create" и т.д.
     * @param string $controller текстовое представление контроллера
     * @return boolean 
     */
    public static function checkAccessToAction($action, $controller = null, $module = 1) {
        $access = array();
        if ($controller == null) {
            $controller = Yii::app()->controller->id;
        }
        $cur_contr = Controllers::findByControllerName($controller, $module);
        if ($cur_contr) {
            $criteria = new CDbCriteria();
            $criteria->join = "INNER JOIN `operations_in_roles` ON ( t.id_oper = operations_in_roles.id_oper ) ";
            $criteria->join.="INNER JOIN `roles` ON ( operations_in_roles.id_role = roles.id_role ) ";
            $criteria->join.="INNER JOIN `actions_in_operations` ON ( actions_in_operations.id_oper = t.id_oper ) ";
            $criteria->join.="INNER JOIN `actions` ON ( actions_in_operations.id_act = actions.id_act )";

            $criteria->select = array('roles.value_role as value_role', 't.id_oper');
            $criteria->order = "t.id_oper";
            $criteria->compare('t.id_contr', $cur_contr->id_contr);
            $criteria->compare('actions.value_act', $action);

            $roles = Operations::model()->findAll($criteria);

            foreach ($roles as $one_role) {
                if ($one_role->value_role == Yii::App()->user->role) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Формирует массив доступа к экшнам, который хавается одноимённым методом контроллера. 
     * Вынесено сюда, чтобы одинаково формировались экшн рулы как клиента, так и админки
     * @return array
     */
    public static function accessRules($module = 1) {
        $cur_contr = Controllers::findByControllerName(Yii::app()->controller->id, $module);
        $arr_permissions = array();
        if ($cur_contr != null) {
            /* Здесь переписано на жадную загрузку, т.к. при большом количестве экшнов она быстрее, чем ленивая. */
            $criteria = new CDbCriteria();
            /* TODO: переделать на with. Тут я вообще не знаю что происходит, когда with используешь. :( */
            $criteria->select = array('roles.value_role as value_role', 'actions.value_act as value_action', 't.id_oper as id_oper');
            $criteria->join = "INNER JOIN `operations_in_roles` ON ( t.id_oper = operations_in_roles.id_oper ) ";
            $criteria->join.="INNER JOIN `roles` ON ( operations_in_roles.id_role = roles.id_role ) ";
            $criteria->join.="INNER JOIN `actions_in_operations` ON ( actions_in_operations.id_oper = t.id_oper ) ";
            $criteria->join.="INNER JOIN `actions` ON ( actions_in_operations.id_act = actions.id_act )";
            $criteria->order = "t.id_oper";
            $criteria->compare('t.id_contr', $cur_contr->id_contr);

            $roles_and_actions = Operations::model()->findAll($criteria);
            $arr_roles = array();
            $arr_actions = array();
            $arr_ids = array();

            foreach ($roles_and_actions as $key => $one_record) {
                $arr_roles[$one_record->id_oper][] = $one_record->value_role;
                $arr_actions[$one_record->id_oper][] = $one_record->value_action;
                $arr_ids[] = $one_record->id_oper;
            }

            $arr_ids = array_unique($arr_ids);

            foreach ($arr_ids as $id_oper) {
                if (!empty($arr_roles) && !empty($arr_actions)) {
                    $arr_permissions[] = array('allow',
                        'actions' => array_unique($arr_actions[$id_oper]),
                        'roles' => array_unique($arr_roles[$id_oper]),
                    );
                }
            }
        }
        $arr_permissions[] = array('allow',
            'actions' => self::$actions_list,
            'users' => array('*'),
        );
        $arr_permissions[] = array('deny', // deny all users
            'users' => array('*'),
            'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
        );

        return $arr_permissions;
    }
}

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

