<?php

class Pumpit {

    var $param;
    var $app_id;
    var $key_api;
    var $key_billing;

    // Конструктор
    function Pumpit($param) {
        $this->param = $param;

        $this->app_id = $this->param['APP_ID'];
        $this->key_api = $this->param['KEY_API'];
        $this->key_billing = $this->param['KEY_BILLING'];

        $this->param['CONTEXT'] = array(
            'http' => array(
                'method' => 'GET',
                'request_fulluri' => true,
                'timeout' => 10
            )
        );
    }

    // Запрос виджетов
    function getWidgets($p_sid = '') {
        $result = false;
        $res = $this->sendRequest($p_sid, 'GetWidgets', '');
        if (!empty($res)) {
            $result = array();
            $result['status'] = sprintf("%d", $res->{'status'});
            $result['err_info'] = sprintf("%s", $res->{'err_info'});
            $result['header'] = sprintf("%s", $res->{'header'});
            $result['footer'] = sprintf("%s", $res->{'footer'});
        }

        return $result;
    }

    // Запрос профиля пользователя
    function getMyProfile($p_sid = '') {
        $result = false;
        $res = $this->sendRequest($p_sid, 'GetMyProfile', '');
        if ($res) {
            $result = array();

            $result['status'] = sprintf("%d", $res->{'status'});
            $result['err_info'] = sprintf("%s", $res->{'err_info'});
            $result['reg_time'] = sprintf("%s", $res->{'reg_time'});
            $result['login'] = sprintf("%d", $res->{'login'});
            $result['nick'] = sprintf("%s", $res->{'nick'});
            $result['sex'] = sprintf("%d", $res->{'sex'});
            $result['coin'] = sprintf("%s", $res->{'coin'});
            if (isset($res->{'avatar'})) {
                $result['avatar'] = sprintf("%s", $res->{'avatar'});
            }
        }

        return $result;
    }

    // Запрос на перевод денег со счета абонента в приложение
    function doIncAppAccount($p_sid = '', $coin = '', $params = array(), $burl = '') {
        $query = array();
        $query['app_id'] = $this->app_id;
        $query['action'] = 'DoIncAppAccount';
        $query['p_sid'] = $p_sid;
        $query['coin'] = $coin;
        $query['burl'] = $burl;

        // Если есть необязательные параметры такие как desc, app_tid, app_uid
        if (!empty($params)) {
            foreach ($params as $key => $value) {
                $query[$key] = $value;
            }
        }

        // Формируем подпись запроса
        $sig = $this->getSig($query, true);

        $url = $this->param['API_HOST'];
        // Собираем URL с сортировкой по ключам
        ksort($query);
        foreach ($query as $key => $value) {
            // Исключаем параметр sig
            if (strtolower($key) != 'sig') {
                $url .= urlencode($key) . "=" . urlencode($value) . "&";
            }
        }
        $url .= "sig=" . $sig;

        return $url;
    }

    // Запрос на авторизацию пользователя
    function doPumpitLogin($p_sid = '', $burl = '') {
        $query = array();
        $query['app_id'] = $this->app_id;
        $query['action'] = 'DoPumpitLogin';
        $query['p_sid'] = $p_sid;
        $query['burl'] = $burl;

        // Формируем подпись запроса
        $sig = $this->getSig($query);

        $url = $this->param['API_HOST'];
        // Собираем URL с сортировкой по ключам
        ksort($query);
        foreach ($query as $key => $value) {
            // Исключаем параметр sig
            if (strtolower($key) != 'sig') {
                $url .= urlencode($key) . "=" . urlencode($value) . "&";
            }
        }
        $url .= "sig=" . $sig;
        return $url;
    }

    // Запрос на доступ к кошельку Pumpit
    function doPumpitPayment($p_sid = '', $burl = '') {
        $query = array();
        $query['app_id'] = $this->app_id;
        $query['action'] = 'DoPumpitPayment';
        $query['p_sid'] = $p_sid;
        $query['burl'] = $burl;

        // Формируем подпись запроса
        $sig = $this->getSig($query);

        $url = $this->param['API_HOST'];
        // Собираем URL с сортировкой по ключам
        ksort($query);
        foreach ($query as $key => $value) {
            // Исключаем параметр sig
            if (strtolower($key) != 'sig') {
                $url .= urlencode($key) . "=" . urlencode($value) . "&";
            }
        }
        $url .= "sig=" . $sig;

        return $url;
    }

    // Запрос на возврат абонента в Pumpit
    function doPumpitBack($p_sid = '') {
        $query = array();
        $query['app_id'] = $this->app_id;
        $query['action'] = 'DoPumpitBack';
        $query['p_sid'] = $p_sid;

        // Формируем подпись запроса
        $sig = $this->getSig($query);

        $url = $this->param['API_HOST'];
        // Собираем URL с сортировкой по ключам
        ksort($query);
        foreach ($query as $key => $value) {
            // Исключаем параметр sig
            if (strtolower($key) != 'sig') {
                $url .= urlencode($key) . "=" . urlencode($value) . "&";
            }
        }
        $url .= "sig=" . $sig;

        return $url;
    }

    // Функция формирования подписи
    function getSig($query, $billing = false) {
        $str = "";
        // Собираем строку для подписи с сортировкой по ключам
        ksort($query);
        foreach ($query as $key => $value) {
            // Исключаем параметр sig
            if (strtolower($key) != 'sig') {
                $str .= $key . "=" . $value;
            }
        }
        $appkey = ($billing) ? $this->key_billing : $this->key_api;

        return md5($str . $appkey);
    }

    // Отправить запрос
    function sendRequest($p_sid, $action, $param, $billing = false) {
        $query = array();
        $query['app_id'] = $this->app_id;
        $query['action'] = $action;
        $query['p_sid'] = $p_sid;

        // Формируем подпись запроса
        $sig = $this->getSig($query, $billing);

        $url = $this->param['API_HOST'];
        // Собираем URL с сортировкой по ключам
        ksort($query);
        foreach ($query as $key => $value) {
            // Исключаем параметр sig
            if (strtolower($key) != 'sig') {
                $url .= urlencode($key) . "=" . urlencode($value) . "&";
            }
        }
        $url .= "sig=" . $sig;

        $connection = stream_context_create($this->param['CONTEXT']);
        $data = file_get_contents($url, false, $connection);
        if ($data) {
            $json = json_decode($data);
            if ($json) {
                return $json;
            } else {
                $this->logError("Unexpected response for request" . "\n" . $data);
            }
        } else {
            $this->logError("Unable to send request" . "\n" . "P_SID=" . $p_sid . " ACTION=" . $action . " PARAM=" . $param . " BILLING=" . $billing);
        }

        return false;
    }

    // Функция проверки валидности запросов от pumpit
    function checkRequest($query_string, $billing = false) {
        $result = false;
        
        parse_str($query_string, $query);
        //пусть пока так
        unset($query['pumpitapi/'], $query['pumpitapi']);
        if ($query['sig'] == $this->getSig($query, $billing)) {
            $result = true;
        }

        return $result;
    }

    // Логирование ошибок
    function logError($txt) {
        if (isset($this->param['LOG']) && $this->param['LOG'] && ($handle = fopen($this->param['LOG'], 'a'))) {
            $tmp = "[" . date('Y-m-d H:i:s') . "]\n";
            $tmp .= "Error. " . $txt . "\n";
            fwrite($handle, $tmp);
            fclose($handle);
        }
    }

}

?>