<?php
class RegenerationCommand extends CConsoleCommand {
    public function run($args) {
        for ($i = 1; $i < 12; $i++) {
            foreach (Users::findUsersForRegeneration() as $user) {
                if ($user->health_now < $user->totalHealth) {
                    $regen=round($user->totalRegeneration/36);
                    if ($user->health_now + $regen > $user->totalHealth) {
                        $user->health_now = $user->totalHealth;
                    }
                    else {
                        $user->health_now += $regen;
                    }
                }
                if ($user->energy_now < $user->totalEnergy) {
                    $regen=round($user->totalRegeneration/12);
                    if ($user->energy_now + $regen > $user->totalEnergy) {
                        $user->energy_now = $user->totalEnergy;
                    }
                    else {
                        $user->energy_now += $regen;
                    }
                }
                Yii::app()->db->createCommand()->update('users', array(
                    'health_now'=>$user->health_now, 'energy_now'=>$user->energy_now,
                ), 'id_user='.$user->id_user);
            }
            sleep(5);
        }
    }
}

