<?php
class BattlesCommand extends CConsoleCommand {
    public function run($args) {
        for ($i = 1; $i < 6; $i++) {
            $battles = BattlesLocations::model()->with('usersForBots')->findAll(array('condition' => 'type_location!=1'));
            foreach ($battles as $battle) {
                Users::setFullParamsForBotsInLocation($battle->id_location, $battle->level_max);
                $domination = BattlesLocations::getDomination($battle->side_now);
                if ($domination >= 50) {
                    $bot = Users::getRandomBotsInLocationForAttack($battle->id_location, $battle->side_now);
                    if ($bot)
                        BattleHelper::captureTerritory($bot);
                }
                $bots = Users::getRandomBotsInLocationForAttack($battle->id_location);
                if (count($bots) > 0) {
                    foreach ($bots as $bot) {
                        $enemy = Users::getRandomEnemyForBattles($battle->id_location, $bot->side, true);
                        Users::getRandomBotsInLocationForDamage($battle->id_location, $bot->side);
                        $result = BattleHelper::damageUser($bot, $enemy);
                        /* Если был удар - идет кол-во в участие */
                        if ($result) {
                            BattleHelper::participation($bot->battle_id, $result['damage']);
                            $log = new BattleLog();
                            $log->battle_type = 1;
                            $log->battle_id = $bot->battle_id;
                            $log->id_user = $bot->id_user;
                            $log->id_target = $enemy->id_user;
                            $log->type = $bot->class;
                            $log->value = $result['damage'];
                            $log->info = ($result['isCritical'] ? 'крит' : '');
                            $log->users = Users::getUsersForLog($enemy->id_user);
                            $log->save(false);
                        }
                        unset($enemy);
                    }
                }
            }
            unset($battles);
            sleep(10);
        }
    }
}

