<?php
class AuctionCommand extends CConsoleCommand {
    public function run($args) {
        $criteria = new CDbCriteria();
        $criteria->condition = '`end` < 1 AND `time` < '.time();
        $auction = Auction::model()->findAll($criteria);
        foreach ($auction as $one) {
            if ($one->lot == 1) {
                if ($one->last) {
                    //Назначаем вещи нового владельца
                    $item = UserItems::model()->findByPk($one->id_item);
                    $item->id_user = $one->last;
                    $item->status = ITEM_IN_MAIL;
                    if (!$item->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке предмета!'));
                    }
                    
                    $id_dialog = Users::checkDialog($one->last, 100);
                    $mail = new UsersMessages();
                    $mail->id_dialog = $id_dialog;
                    $mail->id_user = 100;
                    $mail->users = $one->last;
                    $mail->type = 3;
                    $mail->message = 'Покупка лота';
                    $mail->item = $one->id_item;
                    if (!$mail->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                    }

                    $percent = round($one->price/20);
                    if ($one->price<5) $percent=5;
                    $one->price -= $percent;
                    
                    $id_dialog = Users::checkDialog($one->id_user, 100);
                    $mail = new UsersMessages();
                    $mail->id_dialog = $id_dialog;
                    $mail->id_user = 100;
                    $mail->users = $one->id_user;
                    $mail->type = 1;
                    $mail->message = 'Аукцион завершен. Лот продан';
                    $mail->money = $one->price;
                    if (!$mail->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                    }
                }
                else {
                    $id_dialog = Users::checkDialog($one->id_user, 100);
                    $mail = new UsersMessages();
                    $mail->id_dialog = $id_dialog;
                    $mail->id_user = 100;
                    $mail->users = $one->id_user;
                    $mail->type = 3;
                    $mail->message = 'Аукцион завершен. Лот возвращен';
                    $mail->item = $one->id_item;
                    if (!$mail->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                    }
                }
            }
            elseif ($one->lot == 2) {
                $id_dialog = Users::checkDialog($one->id_user, 100);
                $mail = new UsersMessages();
                $mail->id_dialog = $id_dialog;
                $mail->id_user = 100;
                $mail->users = $one->id_user;
                $mail->type = 2;
                $mail->message = 'Аукцион завершен. Лот возвращен';
                if ($one->iron)
                    $mail->iron = $one->iron;
                if ($one->bottles)
                    $mail->bottles = $one->bottles;
                if (!$mail->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
                }
            }
            $one->delete();
        }
    }
}

