function AddTagToMsg( sBegin, sEnd ) {
    el = document.getElementsByClassName( 'message' );
    textarea = el[0];
    if( !textarea ) return;

    if( document.selection ) {
            textarea.focus();
            sel = document.selection.createRange();
            sel.text = sBegin + sel.text + sEnd;
    } else if( textarea.selectionStart || textarea.selectionStart == '0') {
            textarea.focus();
            var startPos = textarea.selectionStart;
            var endPos = textarea.selectionEnd;
            textarea.value = textarea.value.substring(0, startPos) + sBegin + textarea.value.substring(startPos, endPos) + sEnd + textarea.value.substring( endPos, textarea.value.length );
    } else {
            textarea.value += sBegin + sEnd;
    }

    return false;
}

$(document).ready(function() {  

    $(document).on('click', '.update', function(ev) {
        ev.preventDefault();
        window.location.reload();
    });
    $(document).on("click",".edit",function(ev){
        ev.preventDefault();
        var link = $(this);
        var block = $(this).closest(".message_block");
        $.ajax({
            url: $(this).attr("href"),
            type: "POST",
            success: function(data){    
                $(link).hide(1000);
                $(block).append(data);
            }
        });
    });
    $(document).on("click",".delete-msg",function(ev){
        ev.preventDefault();
        if (confirm("Удалить сообщение?")) {
            var block = $(this).closest(".message_block");
            $.ajax({
                url: $(this).attr("href"),
                type: "POST",
                success: function(data){          
                    if(data == "true"){        
                        $(block).hide(1000);
                        $.fn.yiiListView.update("messages");
                    }
                    else {
                        alert("Сообщение не удалено");
                    }
                }
            });
        }
    });
    
    $(document).on("click",".ban-link",function(ev){
        ev.preventDefault();
        var link = $(this);
        var block = $(this).parent().find("#ban-form");
        $.ajax({
            url: $(this).attr("href"),
            type: "POST",
            success: function(data){
                $(link).hide(1000);
                $(block).append(data);
            }
        });
    });
    
    $(document).on("click",".unban-link",function(ev){
        ev.preventDefault();
        if (confirm("Разбанить пользователя?")) {
            $.ajax({
                url: $(this).attr("href"),
                type: "POST",
                success: function(data){          
                    if(data == "true"){     
                        window.location.reload();
                    }
                    else {
                        alert("Пользователь не заблокирован");
                    }
                }
            });
        }
    });
    
    $(document).on('click', '.answer_link', function(ev) {
        ev.preventDefault();
        var login = $(this).parent().parent().find(".user-login").text();
        $('input:text').val(login + ", ");
        $('textarea').val(login + ", ");
    });
    
    $(document).on('click', '.getForm', function(ev) {
        ev.preventDefault();
        var url = $(this).attr('href');
        var modal = $('.modal');
        $.post(url, function(data) {
            modal.html(data).modal('show');
        });
    });

    $('.modal').on('click', '.sendModalForm', function(ev) {
        ev.preventDefault();
        var form = $(this).closest('form')[0];
        var data = new FormData(form);
        $.ajax({
            'url': $(form).attr('action'),
            'data': data,
            'type': "POST",
            'dataType': "json",
            'processData': false,
            'contentType': false,
            'success': function(data) {
                if(data.status=="success"){
                    $('.modal').modal('hide');
                    if (data.redirect) {
                        window.location.href = data.redirect;
                    }
                    else if (data.reload){
                        window.location.reload();
                    }
                    else if (data.updateList){
                        $.fn.yiiListView.update(data.updateList);
                    }
                    else if (data.updateGrid){
                        $.fn.yiiGridView.update(data.updateGrid);
                    }
                }
                else {
                    $(".errorMessage").hide(); 
                    $.each(data, function(key, val) {                                               
                    $("#"+key+"_em_").text(val);                                                    
                    $("#"+key+"_em_").show();
                    });
                }
            },
        });
    });
    
    $(document).on('click', '.sendForm', function() {
        var form = $(this).closest('form');
        $.post(
            form.attr('action'),
            form.serialize(),
            function(data) {
                if(data.status=="success"){
                    if (data.redirect) {
                        window.location.href = data.redirect;
                    }
                    else if (data.reload){
                        window.location.reload();
                    }
                    else if (data.updateList){
                        $.fn.yiiListView.update(data.updateList);
                    }
                    $(form)[0].reset();
                }
                else{
                    $(".errorMessage").hide(); 
                    $.each(data, function(key, val) {  
                    $("#"+key+"_em_").text(val);                                                    
                    $("#"+key+"_em_").show();
                    });
                }
            },
            'json'
        );
        return false;
    });
});