DROP TABLE IF EXISTS `admin_chat`;

CREATE TABLE `admin_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  `read` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `amulet`;

CREATE TABLE `amulet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stat` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `silver` int(11) NOT NULL,
  `gold` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `arena`;

CREATE TABLE `arena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `opponent` int(11) NOT NULL DEFAULT '0',
  `attack` int(11) NOT NULL,
  `end` int(11) NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=cp1251;

INSERT INTO arena VALUES("1","1","2","12","0","1551821091");
INSERT INTO arena VALUES("2","2","2","15","0","0");
INSERT INTO arena VALUES("3","3","3","15","0","0");



DROP TABLE IF EXISTS `ban`;

CREATE TABLE `ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `text` text NOT NULL,
  `who` int(11) NOT NULL,
  `ip` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `block`;

CREATE TABLE `block` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `who` int(11) NOT NULL,
  `ip` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `chat`;

CREATE TABLE `chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  `read` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clan_built`;

CREATE TABLE `clan_built` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `desc` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO clan_built VALUES("1","Академия","Обучение в академии увеличивает получаемый клановый опыт от всех участников клана");
INSERT INTO clan_built VALUES("2","Архивы знаний","Чтение рукописей в архивах знаний увеличивает личный опыт участников клана");
INSERT INTO clan_built VALUES("3","Магическая лавка","Усиливает волшебные свойства, увеличивает серебро");
INSERT INTO clan_built VALUES("4","Трофейный зал ","Даёт дополнительный бонус к параметрам от трофеев");
INSERT INTO clan_built VALUES("5","Оружейная","Оружейная комната дает бонус к опыту при разборе вещей");



DROP TABLE IF EXISTS `clan_chat`;

CREATE TABLE `clan_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan` int(11) NOT NULL,
  `user` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  `read` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clan_forum_comments`;

CREATE TABLE `clan_forum_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clan_forum_sub`;

CREATE TABLE `clan_forum_sub` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `clan` int(11) NOT NULL,
  `rank` enum('0','1','2','3','4') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clan_forum_topic`;

CREATE TABLE `clan_forum_topic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sub` int(11) NOT NULL DEFAULT '0',
  `clan` int(11) NOT NULL,
  `close` enum('0','1') NOT NULL DEFAULT '0',
  `stick` enum('0','1') NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clan_history`;

CREATE TABLE `clan_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_invite`;

CREATE TABLE `clan_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `ho` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clan_lair`;

CREATE TABLE `clan_lair` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `name2` text NOT NULL,
  `gde` text NOT NULL,
  `gde2` text NOT NULL,
  `lair_attack` int(11) NOT NULL,
  `lair_hp` int(11) NOT NULL,
  `lair_def` int(11) NOT NULL,
  `clan_gold` int(11) NOT NULL,
  `clan_silver` int(11) NOT NULL,
  `clan_exp` int(11) NOT NULL,
  `user_dead` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO clan_lair VALUES("1","Зеленый дракон","Зеленого дракона","Пещера дракона ","Пещеру дракона","1200","100000","2500","100","10000","10000","100");
INSERT INTO clan_lair VALUES("2","Синий дракон","Синего дракона","Казна гномов ","Казну гномов ","2200","270000","8500","500","500000","500000","200");
INSERT INTO clan_lair VALUES("3","Красный дракон","Красного дракона","Сокровищница королей ","Сокровищницу королей ","4100","1000000","18000","2000","1000000","2000000","500");
INSERT INTO clan_lair VALUES("4","Черный дракон","Черного дракона","Сокровищница Богов ","Сокровищницу Богов ","7500","3000000","25000","6000","6000000","3000000","1500");



DROP TABLE IF EXISTS `clan_lair_boss`;

CREATE TABLE `clan_lair_boss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan` int(11) NOT NULL,
  `lair` int(11) NOT NULL,
  `str` int(11) NOT NULL,
  `vit` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `dead` enum('0','1') NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_lair_logs`;

CREATE TABLE `clan_lair_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_lair_memb`;

CREATE TABLE `clan_lair_memb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `str` int(11) NOT NULL,
  `vit` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `udarov` int(11) NOT NULL,
  `dmg` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `start` enum('0','1') NOT NULL,
  `dead` enum('0','1') NOT NULL,
  `nagrada_gold` int(11) NOT NULL,
  `nagrada_silver` int(11) NOT NULL,
  `nagrada_exp` int(11) NOT NULL,
  `nagrada_item_1` int(11) NOT NULL,
  `nagrada_item_2` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_memb`;

CREATE TABLE `clan_memb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `rank` enum('0','1','2','3','4') NOT NULL DEFAULT '0',
  `g` int(11) NOT NULL DEFAULT '0',
  `s` int(11) NOT NULL DEFAULT '0',
  `exp` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `last_update` int(11) NOT NULL DEFAULT '0',
  `v` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=cp1251;

INSERT INTO clan_memb VALUES("1","1","1","4","0","0","0","1551821491","1551907891","10");



DROP TABLE IF EXISTS `clan_msg`;

CREATE TABLE `clan_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clan_msg_read`;

CREATE TABLE `clan_msg_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clan_task`;

CREATE TABLE `clan_task` (
  `id` int(100) NOT NULL DEFAULT '0',
  `name` text,
  `how` int(11) NOT NULL DEFAULT '0',
  `_gold` int(11) NOT NULL DEFAULT '0',
  `_silver` int(11) NOT NULL DEFAULT '0',
  `_exp` int(11) NOT NULL DEFAULT '0',
  `place` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

INSERT INTO clan_task VALUES("1","Победи 125 противников на Арене","125","3","200","250","1");
INSERT INTO clan_task VALUES("2","Сразись с Боссом 38 раз","38","5","500","200","2");
INSERT INTO clan_task VALUES("3","Проведи в Набеге 44 часов","44","3","500","500","3");
INSERT INTO clan_task VALUES("4","Подними параметры героя три раза","3","0","0","0","");
INSERT INTO clan_task VALUES("5","Разбери 25 вещей","25","0","0","0","");



DROP TABLE IF EXISTS `clan_task_user`;

CREATE TABLE `clan_task_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan` int(11) NOT NULL,
  `user` int(11) NOT NULL DEFAULT '0',
  `user_2` int(11) NOT NULL,
  `task` int(11) NOT NULL DEFAULT '0',
  `how` int(11) NOT NULL DEFAULT '0',
  `complete` int(11) NOT NULL DEFAULT '0',
  `time_task` int(11) NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `clans`;

CREATE TABLE `clans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text CHARACTER SET utf8 NOT NULL,
  `description` text CHARACTER SET utf8 NOT NULL,
  `gerb` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '1',
  `exp` int(11) NOT NULL DEFAULT '0',
  `g` int(11) NOT NULL DEFAULT '0',
  `s` int(11) NOT NULL DEFAULT '0',
  `diamond` int(11) NOT NULL,
  `r` enum('0','1') NOT NULL DEFAULT '0',
  `rank_for_invite` enum('0','1','2','3','4') NOT NULL DEFAULT '0',
  `rank_for_delete` enum('0','1','2','3','4') NOT NULL DEFAULT '0',
  `build_1` int(11) NOT NULL DEFAULT '0',
  `build_1_time` int(11) NOT NULL,
  `build_2` int(11) NOT NULL DEFAULT '0',
  `build_2_time` int(11) NOT NULL DEFAULT '0',
  `build_3` int(11) NOT NULL DEFAULT '0',
  `build_3_time` int(11) NOT NULL DEFAULT '0',
  `build_4` int(11) NOT NULL,
  `build_4_time` int(11) NOT NULL,
  `build_5` int(11) NOT NULL,
  `build_5_time` int(11) NOT NULL,
  `build_6` int(11) NOT NULL,
  `build_6_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=cp1251;

INSERT INTO clans VALUES("1","Администраия","","1","1","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");



DROP TABLE IF EXISTS `coliseum`;

CREATE TABLE `coliseum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start` enum('0','1') NOT NULL DEFAULT '0',
  `end` enum('0','1') NOT NULL DEFAULT '0',
  `users` int(11) NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `coliseum_log`;

CREATE TABLE `coliseum_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `battle` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `text` text CHARACTER SET utf8 NOT NULL,
  `show` int(11) NOT NULL DEFAULT '0',
  `opponent` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `coliseum_member`;

CREATE TABLE `coliseum_member` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `battle` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `str` int(11) NOT NULL,
  `vit` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `opponent` int(11) NOT NULL DEFAULT '0',
  `kills` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `exit` enum('0','1') NOT NULL DEFAULT '0',
  `dead` enum('0','1') NOT NULL DEFAULT '0',
  `dmg` int(11) NOT NULL,
  `qqq` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `complects`;

CREATE TABLE `complects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quality` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `w_1` int(11) NOT NULL DEFAULT '0',
  `w_2` int(11) NOT NULL DEFAULT '0',
  `w_3` int(11) NOT NULL DEFAULT '0',
  `w_4` int(11) NOT NULL DEFAULT '0',
  `w_5` int(11) NOT NULL DEFAULT '0',
  `w_6` int(11) NOT NULL DEFAULT '0',
  `w_7` int(11) NOT NULL DEFAULT '0',
  `w_8` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=cp1251;

INSERT INTO complects VALUES("1","1","Комплект ополченца","1","2","3","4","5","6","7","8");
INSERT INTO complects VALUES("2","1","Комплект следопыта","9","10","11","12","13","14","15","16");
INSERT INTO complects VALUES("3","1","Комплект варвара","17","18","19","20","21","22","23","24");
INSERT INTO complects VALUES("4","1","Комплект охотника","25","26","27","28","29","30","31","32");
INSERT INTO complects VALUES("5","2","Комплект ратника","33","34","35","36","37","38","39","40");
INSERT INTO complects VALUES("6","2","Комплект арбалетчика","41","42","43","44","45","46","47","48");
INSERT INTO complects VALUES("7","2","Комплект ассасина","49","50","51","52","53","54","55","56");
INSERT INTO complects VALUES("8","2","Комплект рыцаря","57","58","59","60","61","62","63","64");
INSERT INTO complects VALUES("9","3","Комплект легионера","65","66","67","68","69","70","71","72");
INSERT INTO complects VALUES("10","3","Комплект палача","73","74","75","76","77","78","79","80");
INSERT INTO complects VALUES("11","3","Комплект инквизитора","81","82","83","84","85","86","87","88");
INSERT INTO complects VALUES("12","3","Комплект паладина","89","90","91","92","93","94","95","96");
INSERT INTO complects VALUES("13","4","Комплект победоносца","97","98","99","100","101","102","103","104");
INSERT INTO complects VALUES("14","4","Комплект полководца","105","106","107","108","109","110","111","112");
INSERT INTO complects VALUES("15","4","Комплект триумфатора","113","114","115","116","117","118","119","120");
INSERT INTO complects VALUES("16","4","Комплект воителя","121","122","123","124","125","126","127","128");
INSERT INTO complects VALUES("17","4","Комплект гладиатора","129","130","131","132","133","134","135","136");
INSERT INTO complects VALUES("18","5","Комплект сокрушителя","137","138","139","140","141","142","143","144");
INSERT INTO complects VALUES("19","5","Комплект властелина","145","146","147","148","149","150","151","152");
INSERT INTO complects VALUES("20","5","Комплект владыки","153","154","155","156","157","158","159","160");
INSERT INTO complects VALUES("21","5","Комплект избранного","161","162","163","164","165","166","167","168");
INSERT INTO complects VALUES("22","5","Комплект повелителя","169","170","171","172","173","174","175","176");
INSERT INTO complects VALUES("23","6","Комплект Ярости","177","178","179","180","181","182","183","184");
INSERT INTO complects VALUES("24","6","Комплект Тьмы","185","186","187","188","189","190","191","192");
INSERT INTO complects VALUES("25","6","Комплект Хаоса","193","194","195","196","197","198","199","200");
INSERT INTO complects VALUES("26","6","Комплект Разрушения","201","202","203","204","205","206","207","208");
INSERT INTO complects VALUES("27","6","Комплект Вечности","209","210","211","212","213","214","215","216");
INSERT INTO complects VALUES("28","6","Комплект Жизни","217","218","219","220","221","222","223","224");
INSERT INTO complects VALUES("29","6","Комплект Порядка","225","226","227","228","229","230","231","232");
INSERT INTO complects VALUES("30","6","Комплект Света","233","234","235","236","237","238","239","240");



DROP TABLE IF EXISTS `contacts`;

CREATE TABLE `contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `ho` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=cp1251;

INSERT INTO contacts VALUES("1","1","2","1551821045");
INSERT INTO contacts VALUES("2","2","1","1551821045");
INSERT INTO contacts VALUES("3","2","2","1551821069");
INSERT INTO contacts VALUES("4","2","2","1551821069");
INSERT INTO contacts VALUES("5","3","2","1552549200");
INSERT INTO contacts VALUES("6","2","3","1552549200");



DROP TABLE IF EXISTS `forum_comments`;

CREATE TABLE `forum_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `forum_sub`;

CREATE TABLE `forum_sub` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `access` enum('0','1','2','3') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=cp1251;

INSERT INTO forum_sub VALUES("1","Новости","0");
INSERT INTO forum_sub VALUES("2","Помощь по игре","0");
INSERT INTO forum_sub VALUES("3","Общение","0");



DROP TABLE IF EXISTS `forum_topic`;

CREATE TABLE `forum_topic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sub` int(11) NOT NULL DEFAULT '0',
  `close` enum('0','1') NOT NULL DEFAULT '0',
  `stick` enum('0','1') NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `gifts`;

CREATE TABLE `gifts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `g` int(11) NOT NULL,
  `img` text NOT NULL,
  `tip` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8;

INSERT INTO gifts VALUES("1","10","1","0");
INSERT INTO gifts VALUES("2","10","2","0");
INSERT INTO gifts VALUES("3","10","3","0");
INSERT INTO gifts VALUES("4","10","4","0");
INSERT INTO gifts VALUES("5","10","5","0");
INSERT INTO gifts VALUES("6","10","6","0");
INSERT INTO gifts VALUES("7","10","7","0");
INSERT INTO gifts VALUES("8","10","8","0");
INSERT INTO gifts VALUES("9","10","9","0");
INSERT INTO gifts VALUES("10","10","24","0");
INSERT INTO gifts VALUES("11","10","25","0");
INSERT INTO gifts VALUES("12","10","29","0");
INSERT INTO gifts VALUES("13","10","30","0");
INSERT INTO gifts VALUES("14","10","31","0");
INSERT INTO gifts VALUES("15","10","32","0");
INSERT INTO gifts VALUES("16","10","33","0");
INSERT INTO gifts VALUES("17","10","34","0");
INSERT INTO gifts VALUES("18","10","35","0");
INSERT INTO gifts VALUES("19","10","36","0");
INSERT INTO gifts VALUES("20","10","10","1");
INSERT INTO gifts VALUES("21","10","11","1");
INSERT INTO gifts VALUES("22","10","12","1");
INSERT INTO gifts VALUES("23","10","13","1");
INSERT INTO gifts VALUES("24","10","14","1");
INSERT INTO gifts VALUES("25","10","15","1");
INSERT INTO gifts VALUES("26","10","17","1");
INSERT INTO gifts VALUES("27","10","18","1");
INSERT INTO gifts VALUES("28","10","19","1");
INSERT INTO gifts VALUES("29","10","26","1");
INSERT INTO gifts VALUES("30","10","27","1");
INSERT INTO gifts VALUES("31","10","28","1");
INSERT INTO gifts VALUES("32","10","20","2");
INSERT INTO gifts VALUES("33","10","21","2");
INSERT INTO gifts VALUES("34","10","23","2");
INSERT INTO gifts VALUES("35","10","37","2");
INSERT INTO gifts VALUES("36","10","38","2");
INSERT INTO gifts VALUES("37","10","39","2");
INSERT INTO gifts VALUES("38","10","40","2");
INSERT INTO gifts VALUES("39","10","41","2");
INSERT INTO gifts VALUES("40","10","42","2");
INSERT INTO gifts VALUES("41","10","43","2");
INSERT INTO gifts VALUES("42","10","44","2");
INSERT INTO gifts VALUES("43","10","45","2");
INSERT INTO gifts VALUES("44","10","46","2");
INSERT INTO gifts VALUES("45","10","47","3");
INSERT INTO gifts VALUES("46","10","48","3");
INSERT INTO gifts VALUES("47","10","49","3");
INSERT INTO gifts VALUES("48","10","50","3");
INSERT INTO gifts VALUES("49","10","51","3");
INSERT INTO gifts VALUES("50","10","52","3");
INSERT INTO gifts VALUES("51","10","53","3");
INSERT INTO gifts VALUES("52","10","54","3");



DROP TABLE IF EXISTS `gifts_user`;

CREATE TABLE `gifts_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `komy` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `img` int(11) NOT NULL,
  `text` text NOT NULL,
  `privacy` enum('1','2','3') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `inv`;

CREATE TABLE `inv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `item` int(11) NOT NULL DEFAULT '0',
  `quality` enum('1','2','3','4','5','6') NOT NULL DEFAULT '1',
  `smith` int(11) NOT NULL DEFAULT '0',
  `equip` enum('0','1') NOT NULL DEFAULT '0',
  `new` enum('0','1') NOT NULL DEFAULT '0',
  `rune` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0',
  `_str` int(11) NOT NULL DEFAULT '0',
  `_vit` int(11) NOT NULL DEFAULT '0',
  `_agi` int(11) NOT NULL DEFAULT '0',
  `_def` int(11) NOT NULL DEFAULT '0',
  `place` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=cp1251;

INSERT INTO inv VALUES("1","1","1","1","0","0","1","0","4","4","0","4","0");



DROP TABLE IF EXISTS `invasion`;

CREATE TABLE `invasion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time_start` int(11) NOT NULL,
  `start` enum('0','1') NOT NULL DEFAULT '0',
  `end` enum('0','1') NOT NULL DEFAULT '0',
  `time_left` int(11) NOT NULL,
  `kill_boss` int(11) NOT NULL,
  `pobeda` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO invasion VALUES("1","1551859200","0","0","1551860100","0","0");



DROP TABLE IF EXISTS `invasion_items`;

CREATE TABLE `invasion_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invasion` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `invasion_logs`;

CREATE TABLE `invasion_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `invasion` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `invasion_member`;

CREATE TABLE `invasion_member` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `vit` int(11) NOT NULL,
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `invasion` int(11) NOT NULL,
  `dead` enum('0','1') NOT NULL DEFAULT '0',
  `cooldown` int(11) NOT NULL,
  `target` int(11) NOT NULL,
  `kill` int(11) NOT NULL,
  `uron` int(11) NOT NULL,
  `nagrada` enum('0','1') NOT NULL DEFAULT '0',
  `item` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `invasion_mobs`;

CREATE TABLE `invasion_mobs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `invasion` int(11) NOT NULL,
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `agi` int(11) NOT NULL,
  `max_hp` int(11) NOT NULL,
  `hp` int(11) NOT NULL,
  `img` int(11) NOT NULL DEFAULT '1',
  `dead` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `invasion_stone`;

CREATE TABLE `invasion_stone` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `items`;

CREATE TABLE `items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `w` enum('1','2','3','4','5','6','7','8') NOT NULL DEFAULT '1',
  `name` varchar(100) DEFAULT NULL,
  `quality` enum('1','2','3','4','5','6') NOT NULL DEFAULT '1',
  `level` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=314 DEFAULT CHARSET=cp1251;

INSERT INTO items VALUES("1","1","Шлем Ополченца","1","1");
INSERT INTO items VALUES("2","2","Наплечник Ополченца","1","1");
INSERT INTO items VALUES("3","3","Броня Ополченца","1","1");
INSERT INTO items VALUES("4","4","Перчатки Ополченца","1","1");
INSERT INTO items VALUES("5","5","Щит Ополченца","1","1");
INSERT INTO items VALUES("6","6","Дубина Ополченца","1","1");
INSERT INTO items VALUES("7","7","Штаны Ополченца","1","1");
INSERT INTO items VALUES("8","8","Ботинки Ополченца","1","1");
INSERT INTO items VALUES("9","1","Маска Следопыта","1","1");
INSERT INTO items VALUES("10","2","Наплечник Следопыта","1","1");
INSERT INTO items VALUES("11","3","Накидка Следопыта","1","1");
INSERT INTO items VALUES("12","4","Перчатки Следопыта","1","1");
INSERT INTO items VALUES("13","5","Сеть Следопыта","1","1");
INSERT INTO items VALUES("14","6","Топор Следопыта","1","1");
INSERT INTO items VALUES("15","7","Штаны Следопыта","1","1");
INSERT INTO items VALUES("16","8","Сапоги Следопыта","1","1");
INSERT INTO items VALUES("17","1","Шлем Варвара","1","1");
INSERT INTO items VALUES("18","2","Наплечник Варвара","1","1");
INSERT INTO items VALUES("19","3","Доспех Варвара","1","1");
INSERT INTO items VALUES("20","4","Перчатки Варвара","1","1");
INSERT INTO items VALUES("21","5","Щит Варвара","1","1");
INSERT INTO items VALUES("22","6","Топор Варвара","1","1");
INSERT INTO items VALUES("23","7","Штаны Варвара","1","1");
INSERT INTO items VALUES("24","8","Ботинки Варвара","1","1");
INSERT INTO items VALUES("25","1","Накидка охотника","1","1");
INSERT INTO items VALUES("26","2","Наплечник охотника","1","1");
INSERT INTO items VALUES("27","3","Доспех охотника","1","1");
INSERT INTO items VALUES("28","4","Перчатки охотника","1","1");
INSERT INTO items VALUES("29","5","Кинжал охотника","1","1");
INSERT INTO items VALUES("30","6","Охотничий лук","1","1");
INSERT INTO items VALUES("31","7","Штаны охотника","1","1");
INSERT INTO items VALUES("32","8","Сапоги охотника","1","1");
INSERT INTO items VALUES("33","1","Шлем Ратника","2","7");
INSERT INTO items VALUES("34","2","Наплечник Ратника","2","7");
INSERT INTO items VALUES("35","3","Доспех Ратника","2","7");
INSERT INTO items VALUES("36","4","Перчатки Ратника","2","7");
INSERT INTO items VALUES("37","5","Щит Ратника","2","7");
INSERT INTO items VALUES("38","6","Секира Ратника","2","7");
INSERT INTO items VALUES("39","7","Штаны Ратника","2","7");
INSERT INTO items VALUES("40","8","Сапоги Ратника","2","7");
INSERT INTO items VALUES("41","1","Шлем Арбалетчика","2","7");
INSERT INTO items VALUES("42","2","Наплечник Арбалетчика","2","7");
INSERT INTO items VALUES("43","3","Доспех Арбалетчика","2","7");
INSERT INTO items VALUES("44","4","Перчатки Арбалетчика","2","7");
INSERT INTO items VALUES("45","5","Кинжал Арбалетчика","2","7");
INSERT INTO items VALUES("46","6","Боевой арбалет","2","7");
INSERT INTO items VALUES("47","7","Штаны Арбалетчика","2","7");
INSERT INTO items VALUES("48","8","Сапоги Арбалетчика","2","7");
INSERT INTO items VALUES("49","1","Капюшон Ассасина","2","7");
INSERT INTO items VALUES("50","2","Наплечник Ассасина","2","7");
INSERT INTO items VALUES("51","3","Броня Ассасина","2","7");
INSERT INTO items VALUES("52","4","Перчатки Ассасина\r\n","2","7");
INSERT INTO items VALUES("53","5","Клинок Ассасина","2","7");
INSERT INTO items VALUES("54","6","Клинок Ассасина","2","7");
INSERT INTO items VALUES("55","7","Штаны Ассасина","2","7");
INSERT INTO items VALUES("56","8","Ботинки Ассасина","2","7");
INSERT INTO items VALUES("57","1","Шлем Рыцаря","2","7");
INSERT INTO items VALUES("58","2","Наплечник Рыцаря","2","7");
INSERT INTO items VALUES("59","3","Доспех Рыцаря","2","7");
INSERT INTO items VALUES("60","4","Перчатки Рыцаря","2","7");
INSERT INTO items VALUES("61","5","Щит Рыцаря","2","7");
INSERT INTO items VALUES("62","6","Меч Рыцаря","2","7");
INSERT INTO items VALUES("63","7","Штаны Рыцаря","2","7");
INSERT INTO items VALUES("64","8","Сапоги Рыцаря","2","7");
INSERT INTO items VALUES("65","1","Шлем Легионера","3","12");
INSERT INTO items VALUES("66","2","Наплечник Легионера","3","12");
INSERT INTO items VALUES("67","3","Перчатки Легионера","3","12");
INSERT INTO items VALUES("68","4","Перчатки искателя","3","12");
INSERT INTO items VALUES("69","5","Щит Легионера","3","12");
INSERT INTO items VALUES("70","6","Меч Легионера","3","12");
INSERT INTO items VALUES("71","7","Штаны Легионера","3","12");
INSERT INTO items VALUES("72","8","Сапоги Легионера","3","12");
INSERT INTO items VALUES("73","1","Шлем Палача","3","12");
INSERT INTO items VALUES("74","2","Наплечник Палача","3","12");
INSERT INTO items VALUES("75","3","Доспех Палача","3","12");
INSERT INTO items VALUES("76","4","Перчатки Палача","3","12");
INSERT INTO items VALUES("77","5","Сеть Палача","3","12");
INSERT INTO items VALUES("78","6","Топор Палача","3","12");
INSERT INTO items VALUES("79","7","Штаны Палача","3","12");
INSERT INTO items VALUES("80","8","Сапоги Палача","3","12");
INSERT INTO items VALUES("81","1","Шлем Инквизитора","3","12");
INSERT INTO items VALUES("82","2","Наплечник Инквизитора","3","12");
INSERT INTO items VALUES("83","3","Доспех Инквизитора","3","12");
INSERT INTO items VALUES("84","4","Перчатки Инквизитора","3","12");
INSERT INTO items VALUES("85","5","Крест Инквизитора","3","12");
INSERT INTO items VALUES("86","6","Молот Инквизитора","3","12");
INSERT INTO items VALUES("87","7","Штаны Инквизитора","3","12");
INSERT INTO items VALUES("88","8","Ботинки Инквизитора","3","12");
INSERT INTO items VALUES("89","1","Шлем Паладина","3","12");
INSERT INTO items VALUES("90","2","Наплечник Паладина","3","12");
INSERT INTO items VALUES("91","3","Доспех Паладина","3","12");
INSERT INTO items VALUES("92","4","Перчатки Паладина","3","12");
INSERT INTO items VALUES("93","5","Щит Паладина","3","12");
INSERT INTO items VALUES("94","6","Молот Паладина","3","12");
INSERT INTO items VALUES("95","7","Штаны Паладина","3","12");
INSERT INTO items VALUES("96","8","Сапоги Паладина","3","12");
INSERT INTO items VALUES("97","1","Шлем Победоносца","4","24");
INSERT INTO items VALUES("98","2","Наплечник Победоносца","4","24");
INSERT INTO items VALUES("99","3","Доспех Победоносца","4","24");
INSERT INTO items VALUES("100","4","Наручи Победоносца","4","24");
INSERT INTO items VALUES("101","5","Щит Победоносца","4","24");
INSERT INTO items VALUES("102","6","Меч Победоносца","4","24");
INSERT INTO items VALUES("103","7","Штаны Победоносца","4","24");
INSERT INTO items VALUES("104","8","Сапоги Победоносца","4","24");
INSERT INTO items VALUES("105","1","Шлем Полководца","4","24");
INSERT INTO items VALUES("106","2","Наплечник Полководца","4","24");
INSERT INTO items VALUES("107","3","Кираса Полководца","4","24");
INSERT INTO items VALUES("108","4","Перчатки Полководца","4","24");
INSERT INTO items VALUES("109","5","Щит Полководца","4","24");
INSERT INTO items VALUES("110","6","Меч Полководца","4","24");
INSERT INTO items VALUES("111","7","Штаны Полководца","4","24");
INSERT INTO items VALUES("112","8","Сапоги Полководца","4","24");
INSERT INTO items VALUES("113","1","Шлем Триумфатора","4","24");
INSERT INTO items VALUES("114","2","Наплечник Триумфатора","4","24");
INSERT INTO items VALUES("115","3","Доспех Триумфатора","4","24");
INSERT INTO items VALUES("116","4","Наручи Триумфатора","4","24");
INSERT INTO items VALUES("117","5","Копье Триумфатора","4","24");
INSERT INTO items VALUES("118","6","Клинок Триумфатора","4","24");
INSERT INTO items VALUES("120","8","Сапоги Триумфатора","4","24");
INSERT INTO items VALUES("119","7","Штаны Триумфатора","4","24");
INSERT INTO items VALUES("121","1","Шлем Воителя","4","24");
INSERT INTO items VALUES("122","2","Наплечник Воителя","4","24");
INSERT INTO items VALUES("123","3","Доспех Воителя","4","24");
INSERT INTO items VALUES("124","4","Перчатки Воителя","4","24");
INSERT INTO items VALUES("125","5","Клинок Воителя","4","24");
INSERT INTO items VALUES("126","6","Меч Воителя","4","24");
INSERT INTO items VALUES("127","7","Штаны Воителя","4","24");
INSERT INTO items VALUES("128","8","Сапоги Воителя","4","24");
INSERT INTO items VALUES("129","1","Шлем Гладиатора","4","24");
INSERT INTO items VALUES("130","2","Наплечник Гладиатора","4","24");
INSERT INTO items VALUES("131","3","Доспех Гладиатора","4","24");
INSERT INTO items VALUES("132","4","Перчатки Гладиатора","4","24");
INSERT INTO items VALUES("133","5","Копье Гладиатора","4","24");
INSERT INTO items VALUES("134","6","Булава Гладиатора","4","24");
INSERT INTO items VALUES("135","7","Штаны Гладиатора","4","24");
INSERT INTO items VALUES("136","8","Сапоги Гладиатора","4","24");
INSERT INTO items VALUES("137","1","Шлем Сокрушителя","5","36");
INSERT INTO items VALUES("138","2","Наплечник Сокрушителя","5","36");
INSERT INTO items VALUES("139","3","Доспех Сокрушителя","5","36");
INSERT INTO items VALUES("140","4","Перчатки Сокрушителя","5","36");
INSERT INTO items VALUES("141","5","Щит Сокрушителя","5","36");
INSERT INTO items VALUES("142","6","Молот Сокрушителя","5","36");
INSERT INTO items VALUES("143","7","Штаны Сокрушителя","5","36");
INSERT INTO items VALUES("144","8","Сапоги Сокрушителя","5","36");
INSERT INTO items VALUES("145","1","Шлем Властелина","5","36");
INSERT INTO items VALUES("146","2","Наплечник Властелина","5","36");
INSERT INTO items VALUES("147","3","Доспех Властелина","5","36");
INSERT INTO items VALUES("148","4","Перчатки Властелина","5","36");
INSERT INTO items VALUES("149","5","Булава Властелина","5","36");
INSERT INTO items VALUES("150","6","Клинок Властелина","5","36");
INSERT INTO items VALUES("151","7","Штаны Властелина","5","36");
INSERT INTO items VALUES("152","8","Сапоги Властелина","5","36");
INSERT INTO items VALUES("153","1","Шлем Владыки","5","36");
INSERT INTO items VALUES("154","2","Наплечник Владыки","5","36");
INSERT INTO items VALUES("155","3","Доспех Владыки","5","36");
INSERT INTO items VALUES("156","4","Перчатки Владыки","5","36");
INSERT INTO items VALUES("157","5","Крюк Владыки","5","36");
INSERT INTO items VALUES("158","6","Меч Владыки","5","36");
INSERT INTO items VALUES("159","7","Штаны Владыки","5","36");
INSERT INTO items VALUES("160","8","Сапоги Владыки","5","36");
INSERT INTO items VALUES("161","1","Шлем Избранного","5","36");
INSERT INTO items VALUES("162","2","Наплечник Избранного","5","36");
INSERT INTO items VALUES("163","3","Доспех Избранного","5","36");
INSERT INTO items VALUES("164","4","Перчатки Избранного","5","36");
INSERT INTO items VALUES("165","5","Секира Избранного","5","36");
INSERT INTO items VALUES("166","6","Секира Избранного","5","36");
INSERT INTO items VALUES("167","7","Штаны Избранного","5","36");
INSERT INTO items VALUES("168","8","Сапоги Избранного","5","36");
INSERT INTO items VALUES("170","2","Наплечник Повелителя","5","36");
INSERT INTO items VALUES("171","3","Доспех Повелителя","5","36");
INSERT INTO items VALUES("172","4","Перчатки Повелителя","5","36");
INSERT INTO items VALUES("173","5","Булава Повелителя","5","36");
INSERT INTO items VALUES("174","6","Булава Повелителя","5","36");
INSERT INTO items VALUES("175","7","Штаны Повелителя","5","36");
INSERT INTO items VALUES("176","8","Сапоги Повелителя","5","36");
INSERT INTO items VALUES("177","1","Шлем Ярости","6","48");
INSERT INTO items VALUES("178","2","Наплечник Ярости","6","48");
INSERT INTO items VALUES("179","3","Броня Ярости","6","48");
INSERT INTO items VALUES("180","4","Перчатки Ярости","6","48");
INSERT INTO items VALUES("181","5","Топор Ярости","6","48");
INSERT INTO items VALUES("182","6","Клинок Ярости","6","48");
INSERT INTO items VALUES("183","7","Штаны Ярости","6","48");
INSERT INTO items VALUES("184","8","Сапоги Ярости","6","48");
INSERT INTO items VALUES("185","1","Шлем Тьмы","6","48");
INSERT INTO items VALUES("186","2","Наплечник Тьмы","6","48");
INSERT INTO items VALUES("187","3","Броня Тьмы","6","48");
INSERT INTO items VALUES("188","4","Перчатки Тьмы","6","48");
INSERT INTO items VALUES("189","5","Тесак Тьмы","6","48");
INSERT INTO items VALUES("190","6","Палаш Тьмы","6","48");
INSERT INTO items VALUES("191","7","Штаны Тьмы","6","48");
INSERT INTO items VALUES("192","8","Сапоги Тьмы","6","48");
INSERT INTO items VALUES("193","1","Шлем Хаоса","6","48");
INSERT INTO items VALUES("194","2","Наплечник Хаоса","6","48");
INSERT INTO items VALUES("195","3","Доспех Хаоса","6","48");
INSERT INTO items VALUES("196","4","Перчатки Хаоса","6","48");
INSERT INTO items VALUES("197","5","Коготь Хаоса","6","48");
INSERT INTO items VALUES("198","6","Клык Хаоса","6","48");
INSERT INTO items VALUES("199","7","Штаны Хаоса","6","48");
INSERT INTO items VALUES("200","8","Сапоги Хаоса","6","48");
INSERT INTO items VALUES("201","1","Шлем Разрушения","6","48");
INSERT INTO items VALUES("202","2","Наплечник Разрушения","6","48");
INSERT INTO items VALUES("203","3","Кираса Разрушения","6","48");
INSERT INTO items VALUES("204","4","Перчатки Разрушения","6","48");
INSERT INTO items VALUES("205","5","Клинок Разрушения","6","48");
INSERT INTO items VALUES("206","6","Топор Разрушения","6","48");
INSERT INTO items VALUES("207","7","Штаны Разрушения","6","48");
INSERT INTO items VALUES("208","8","Сапоги Разрушения","6","48");
INSERT INTO items VALUES("209","1","Шлем Вечности","6","48");
INSERT INTO items VALUES("210","2","Наплечник Вечности","6","48");
INSERT INTO items VALUES("211","3","Броня Вечности","6","48");
INSERT INTO items VALUES("212","4","Перчатки Вечности","6","48");
INSERT INTO items VALUES("213","5","Глефа Вечности","6","48");
INSERT INTO items VALUES("214","6","Меч Вечности","6","48");
INSERT INTO items VALUES("215","7","Штаны Вечности","6","48");
INSERT INTO items VALUES("216","8","Сапоги Вечности","6","48");
INSERT INTO items VALUES("217","1","Шлем Жизни","6","48");
INSERT INTO items VALUES("218","2","Наплечник Жизни","6","48");
INSERT INTO items VALUES("219","3","Броня Жизни","6","48");
INSERT INTO items VALUES("220","4","Перчатки Жизни","6","48");
INSERT INTO items VALUES("221","5","Меч Жизни","6","48");
INSERT INTO items VALUES("222","6","Клинок Жизни","6","48");
INSERT INTO items VALUES("223","7","Штаны Жизни","6","48");
INSERT INTO items VALUES("224","8","Сапоги Жизни","6","48");
INSERT INTO items VALUES("225","1","Шлем Порядка","6","48");
INSERT INTO items VALUES("226","2","Наплечник Порядка","6","48");
INSERT INTO items VALUES("227","3","Кираса Порядка","6","48");
INSERT INTO items VALUES("228","4","Перчатки Порядка","6","48");
INSERT INTO items VALUES("229","5","Оплот Порядка","6","48");
INSERT INTO items VALUES("230","6","Молот Порядка","6","48");
INSERT INTO items VALUES("231","7","Штаны Порядка","6","48");
INSERT INTO items VALUES("232","8","Сапоги Порядка","6","48");
INSERT INTO items VALUES("233","1","Шлем Света","6","48");
INSERT INTO items VALUES("234","2","Наплечник Света","6","48");
INSERT INTO items VALUES("235","3","Доспех Света","6","48");
INSERT INTO items VALUES("236","4","Перчатки Света","6","48");
INSERT INTO items VALUES("237","5","Щит Света","6","48");
INSERT INTO items VALUES("238","6","Копье Света","6","48");
INSERT INTO items VALUES("239","7","Штаны Света","6","48");
INSERT INTO items VALUES("240","8","Сапоги Света","6","48");
INSERT INTO items VALUES("169","1","Шлем Повелителя","5","36");



DROP TABLE IF EXISTS `lair`;

CREATE TABLE `lair` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(252) NOT NULL,
  `name2` varchar(252) NOT NULL,
  `description` text NOT NULL,
  `img` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO lair VALUES("1","Темный лес","В темный лес","До нас дошли слухи, что в пещере, в центре Темного леса видели оборотня. Ты должен убить его!","2");
INSERT INTO lair VALUES("2","Чёрный холм","В чёрный холм","Орки бегут с северных земель, попутно разоряя земли простых селян. Жители обещают неплохую награду за помощь в борьбе с орками.","4");
INSERT INTO lair VALUES("3","Старый замок","В старый замок","Мертвецы ожили на кладбище! В старом замке творит тёмный ритуал Древний Вампир. Надо остановить его пока не поздно!","11");
INSERT INTO lair VALUES("4","Огненная пещера","В огненная пещера","","14");
INSERT INTO lair VALUES("5","Заброшенный храм","В заброшенный храм","Что-то пробудило древних и ранее безобидных змей, и заставило их сеять ужас на близлежащие порты и деревни.","13");
INSERT INTO lair VALUES("6","Замок некроманта","В замок некроманта","","12");
INSERT INTO lair VALUES("7","Старый рудник","На старый рудник","","10");
INSERT INTO lair VALUES("8","Древнее болото","На древнее болото","","16");
INSERT INTO lair VALUES("9","Портал измерений","В портал измерений","","18");
INSERT INTO lair VALUES("10","Замок Ифрита","В замок Ифрита","","20");
INSERT INTO lair VALUES("11","Пещера Мантикоры","в пещера мантикоры","","22");
INSERT INTO lair VALUES("12","Гнезда Виверн","В гнезда виверн","","24");
INSERT INTO lair VALUES("13","Гнездо Феникса","В гнездо феникса","","26");
INSERT INTO lair VALUES("14","Замок Владыки","К замку Владыки","","28");
INSERT INTO lair VALUES("15","Обитель гиганта","В обитель гиганта","","30");
INSERT INTO lair VALUES("16","Некрополь","В Некрополь","","32");
INSERT INTO lair VALUES("17","Бездна","В бездну","","34");
INSERT INTO lair VALUES("18","Колыбель времени","В колыбель времени","","36");
INSERT INTO lair VALUES("19","Восстание Ётунов","В восстание Ётунов","","40");
INSERT INTO lair VALUES("20","Рагнарек","В Рагнарек","","44");



DROP TABLE IF EXISTS `lair_logs`;

CREATE TABLE `lair_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO lair_logs VALUES("1","1","Вы ударили Лесной волк  на <span class=\"red\">33</span> </br>\r\nЛесной волк ударил вас на <span class=\"red\">9</span>","1551821093");
INSERT INTO lair_logs VALUES("2","1","Вы ударили Лесной волк  на <span class=\"red\">32</span> </br>\r\nЛесной волк ударил вас на <span class=\"red\">8</span>","1551821093");
INSERT INTO lair_logs VALUES("3","1","Вы ударили Лесной волк  на <span class=\"red\">34</span> </br>\r\nЛесной волк ударил вас на <span class=\"red\">9</span>","1551821094");
INSERT INTO lair_logs VALUES("4","1","Вы ударили Лесной волк  на <span class=\"red\">32</span> </br>\r\nЛесной волк ударил вас на <span class=\"red\">8</span>","1551821094");



DROP TABLE IF EXISTS `lair_mobs`;

CREATE TABLE `lair_mobs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `name2` text NOT NULL,
  `glava` int(11) NOT NULL,
  `str` int(11) NOT NULL,
  `vit` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `gold` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `item` enum('1','2','3','4','5','6') NOT NULL,
  `img` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8;

INSERT INTO lair_mobs VALUES("1","Лесной волк","Лесного волка","1","15","100","25","10","100","1","1");
INSERT INTO lair_mobs VALUES("2","Степной волк","Степного волка","1","22","220","45","10","140","1","1");
INSERT INTO lair_mobs VALUES("3","Горный волк","Горного волка","1","50","300","50","10","260","1","1");
INSERT INTO lair_mobs VALUES("4","Оборотень","Оборотня","1","60","500","80","10","380","2","2");
INSERT INTO lair_mobs VALUES("5","Орк","Орка","2","90","800","125","10","520","2","15");
INSERT INTO lair_mobs VALUES("6","Орк рубака","Орка рубака","2","105","1100","150","10","650","2","15");
INSERT INTO lair_mobs VALUES("7","Вождь орков","Вождя орков","2","120","1300","175","10","780","2","15");
INSERT INTO lair_mobs VALUES("8","Горный тролль","Горного тролля","2","140","1500","195","12","960","3","4");
INSERT INTO lair_mobs VALUES("9","Разлагающийся зомби","Разлагающего зомби","3","190","1800","240","12","1200","2","5");
INSERT INTO lair_mobs VALUES("10","Ядовитый зомби","Ядовитого зомби","3","240","2200","315","12","1470","2","5");
INSERT INTO lair_mobs VALUES("11","Зомби драугр","Зомби драугр","3","300","2350","370","12","2000","2","5");
INSERT INTO lair_mobs VALUES("12","Вампир","Вампира","3","320","2500","400","15","2500","3","11");
INSERT INTO lair_mobs VALUES("13","Злобная гончая","Злобную гончу","4","360","3500","490","15","3200","3","6");
INSERT INTO lair_mobs VALUES("14","Гончая пламени","Гончу пламени","4","380","4000","550","15","5700","3","6");
INSERT INTO lair_mobs VALUES("15","Адская гончая","Адскую гончу","4","400","5000","600","15","6500","1","6");
INSERT INTO lair_mobs VALUES("16","Цербер","Цербера","4","450","5500","600","20","7200","4","14");
INSERT INTO lair_mobs VALUES("17","Большая кобра","Большую кобру","5","550","580","720","20","7900","3","7");
INSERT INTO lair_mobs VALUES("18","Песочный змей","Песочного змея","5","550","6000","780","20","9100","3","7");
INSERT INTO lair_mobs VALUES("19","Морской змей","Морского змея","5","600","6500","850","20","10300","3","7");
INSERT INTO lair_mobs VALUES("20","Медуза Горгона","Медузу Горгону","5","630","7200","900","25","12000","4","13");
INSERT INTO lair_mobs VALUES("21","Скелет воин","Скелета воина","6","700","7500","1000","25","13100","3","3");
INSERT INTO lair_mobs VALUES("22","Скелет командир","Скелета командира","6","760","8000","1070","25","14500","3","3");
INSERT INTO lair_mobs VALUES("23","Король скелетов","Короля скелетов","6","730","8500","1150","25","15900","3","3");
INSERT INTO lair_mobs VALUES("24","Некромант","Некроманта","6","880","9000","1220","30","17700","4","12");
INSERT INTO lair_mobs VALUES("25","Глиняный голем","Глиняного голема","7","930","10000","1300","30","19200","4","9");
INSERT INTO lair_mobs VALUES("26","Каменный голем","Каменного голема","7","1020","10000","1380","30","21300","4","9");
INSERT INTO lair_mobs VALUES("27","Гигантский голем","Гигантского голема","7","1030","11000","1450","30","23700","4","9");
INSERT INTO lair_mobs VALUES("28","Циклоп","Циклопа","7","1100","11500","1500","35","25100","4","10");
INSERT INTO lair_mobs VALUES("29","Огромная саламандра","Огромную саламандру","8","1450","10000","1700","35","26000","4","8");
INSERT INTO lair_mobs VALUES("30","Ядовитая саламандра","Ядовитую саламандру","8","1480","11000","1800","35","27100","4","8");
INSERT INTO lair_mobs VALUES("31","Огненную саламандру","Огненная саламандра","8","1500","12000","1900","35","28200","4","8");
INSERT INTO lair_mobs VALUES("32","Гидра","Гидру","8","1500","13500","2000","40","29300","4","16");
INSERT INTO lair_mobs VALUES("33","Злобоглаз","Злобоглаза","9","1550","15000","2100","45","31000","4","17");
INSERT INTO lair_mobs VALUES("34","Злое око","Злое око","9","1700","16000","2200","50","32000","4","17");
INSERT INTO lair_mobs VALUES("35","Ужаса из глубин","Ужаса из глубин","9","1700","17000","2300","55","33500","4","17");
INSERT INTO lair_mobs VALUES("36","Ночной кошмар","Ночного кошмара","9","1700","18000","2400","60","34700","4","18");
INSERT INTO lair_mobs VALUES("37","Призрак","Призрак","10","2000","16000","2500","65","36400","4","19");
INSERT INTO lair_mobs VALUES("38","Приведение","Приведение","10","2100","17000","2650","70","37100","4","19");
INSERT INTO lair_mobs VALUES("39","Злой дух","Злого Духа","10","2100","18000","2700","75","38400","4","19");
INSERT INTO lair_mobs VALUES("40","Ифрит","Ифрита","10","2100","20000","2750","80","39800","4","20");
INSERT INTO lair_mobs VALUES("41","Минотавр командир","Минотавра командира","11","2150","20000","2900","85","41000","4","21");
INSERT INTO lair_mobs VALUES("42","Элитный минотавр","Элитного минотавра","11","2300","21000","3000","90","42000","4","21");
INSERT INTO lair_mobs VALUES("43","Король минотавров","Короля минотавров","11","2300","22000","3100","95","43000","4","21");
INSERT INTO lair_mobs VALUES("44","Древняя мантикора","Древнюю мантикору","11","2380","2250","3200","100","44000","4","22");
INSERT INTO lair_mobs VALUES("45","Василиск","Василиска","12","2400","23000","3300","100","45000","4","23");
INSERT INTO lair_mobs VALUES("46","Большой Василиск","Большого Василиска","12","2459","23500","3350","100","46000","4","23");
INSERT INTO lair_mobs VALUES("47","Древний василиск","Древнего Василиска","12","2500","24000","3400","100","47000","4","23");
INSERT INTO lair_mobs VALUES("48","Виверна","Виверну","12","2550","30000","3600","100","48000","4","24");
INSERT INTO lair_mobs VALUES("49","Элементаль огня","Элементаля огня","13","2650","31000","3850","100","49000","5","25");
INSERT INTO lair_mobs VALUES("50","Элементаль лавы","Элементаля лавы","13","2700","3150","3900","100","50000","5","25");
INSERT INTO lair_mobs VALUES("51","Элементаль магмы","Элементаля магмы","13","2750","32000","4000","100","51000","5","25");
INSERT INTO lair_mobs VALUES("52","Феникс","Феникса","13","2800","33000","4050","100","52000","5","26");
INSERT INTO lair_mobs VALUES("53","Инфернал","Инфернала","14","2850","36000","4150","100","53000","5","27");
INSERT INTO lair_mobs VALUES("54","Большой Инфернал","Большого Инфернала","14","2950","37000","4250","100","54000","5","27");
INSERT INTO lair_mobs VALUES("55","Древний инфернал","Древнего Инфернала","14","2950","38000","4300","100","55000","5","27");
INSERT INTO lair_mobs VALUES("56","Владыка бездны","Владыку бездны","14","3000","40000","4400","100","56000","5","28");
INSERT INTO lair_mobs VALUES("57","Великан","Великана","15","3100","41000","4500","100","57000","5","29");
INSERT INTO lair_mobs VALUES("58","Великан солдат","Великана солдата","15","3120","42000","4550","100","58000","5","29");
INSERT INTO lair_mobs VALUES("59","Вождь великанов","Вождя великанов","15","3140","44000","4600","100","59000","5","29");
INSERT INTO lair_mobs VALUES("60","Гигант","Гиганта","15","3200","45000","4650","100","60000","5","30");
INSERT INTO lair_mobs VALUES("61","Костяной дракон","Костяного дракона","16","3180","46000","4780","100","61000","5","31");
INSERT INTO lair_mobs VALUES("62","Дракон скелет","Дракона Скелета","16","3200","47000","4800","100","62000","5","31");
INSERT INTO lair_mobs VALUES("63","Мертвый дракон","Мертвого дракона","16","3240","48000","4800","100","63000","5","31");
INSERT INTO lair_mobs VALUES("64","Темный властелин","Темного властелина","16","3330","50000","5000","100","64000","5","32");
INSERT INTO lair_mobs VALUES("65","Неизвестно","Неизвестно","17","3650","50000","5120","100","65000","5","33");
INSERT INTO lair_mobs VALUES("66","Око Бездны","Око Бездны","17","3830","50000","5170","100","66000","5","33");
INSERT INTO lair_mobs VALUES("67","Дитя Бездны","Дитя Бездны","17","4050","50000","5400","100","67000","5","33");
INSERT INTO lair_mobs VALUES("68","Повелитель Бездны","Повелителя Бездны","17","4100","55000","5450","100","68000","5","34");
INSERT INTO lair_mobs VALUES("69","Пожиратель","Пожирателя","18","4200","57000","5500","100","69000","5","35");
INSERT INTO lair_mobs VALUES("70","Уничтожитель","Уничтожителя","18","4250","58000","5500","100","70000","5","35");
INSERT INTO lair_mobs VALUES("71","Джаггернаут","Джаггернаута","18","4300","59000","5800","100","71000","5","35");
INSERT INTO lair_mobs VALUES("72","Древний ужас","Древнего Ужаса","18","6000","90000","8000","100","72000","5","36");
INSERT INTO lair_mobs VALUES("73","1-й Ётун","1-го Ётуна","19","7000","125000","9000","100","73000","5","37");
INSERT INTO lair_mobs VALUES("74","2-й Ётун","2-го Ётуна","19","7500","135000","9500","100","74000","5","38");
INSERT INTO lair_mobs VALUES("75","3-й Ётун","3-го Ётуна","19","8000","145000","10000","100","75000","5","39");
INSERT INTO lair_mobs VALUES("76","Фенрир","Фенрира","19","10000","160000","10000","250","76000","5","40");
INSERT INTO lair_mobs VALUES("77","1-й Великан","1-го Великана","20","10500","170000","10750","100","77000","5","41");
INSERT INTO lair_mobs VALUES("78","2-й Великан","2-го Великана","20","11000","180000","11500","100","78000","5","42");
INSERT INTO lair_mobs VALUES("79","3-й Великанов","3-го Великанов","20","11500","190000","12250","100","70000","5","43");
INSERT INTO lair_mobs VALUES("80","Хель","Хель","20","12500","200000","13000","500","80000","5","44");



DROP TABLE IF EXISTS `lair_users`;

CREATE TABLE `lair_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_str` int(11) NOT NULL,
  `user_vit` int(11) NOT NULL,
  `user_def` int(11) NOT NULL,
  `boss_id` int(11) NOT NULL,
  `boss_str` int(11) NOT NULL,
  `boss_vit` int(11) NOT NULL,
  `boss_def` int(11) NOT NULL,
  `start` enum('0','1') NOT NULL DEFAULT '0',
  `boss_dead` enum('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO lair_users VALUES("1","1","0","0","0","0","0","0","0","0","0","0");
INSERT INTO lair_users VALUES("2","2","39","39","39","1","15","100","25","0","0","1518857233");
INSERT INTO lair_users VALUES("3","3","39","39","39","1","15","100","25","0","0","1518857233");



DROP TABLE IF EXISTS `mail`;

CREATE TABLE `mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  `read` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=cp1251;

INSERT INTO mail VALUES("1","2","1"," Ваш логин: Admin </br>\r\n        Ваш пароль: 123456","1551821045","1");
INSERT INTO mail VALUES("2","2","2"," Ваш логин: system </br>\r\n        Ваш пароль: 123456","1551821069","0");
INSERT INTO mail VALUES("3","2","3"," Ваш логин: 111111 </br>\r\n        Ваш пароль: 111111","1552549200","0");



DROP TABLE IF EXISTS `maze`;

CREATE TABLE `maze` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) unsigned NOT NULL,
  `lvl` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `hp` smallint(5) unsigned NOT NULL,
  `hp_max` smallint(5) unsigned NOT NULL,
  `tip` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `kluch` tinyint(2) unsigned NOT NULL,
  `maze` tinyint(2) unsigned NOT NULL,
  `sunduk` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `lovushka` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `gold` int(11) NOT NULL,
  `silver` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `passed_cells` int(11) NOT NULL,
  `passed_traps` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`id_user`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO maze VALUES("1","1","1","39","39","0","25","5","0","0","0","0","0","0","0");



DROP TABLE IF EXISTS `maze_block`;

CREATE TABLE `maze_block` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) unsigned NOT NULL,
  `block` tinyint(2) unsigned NOT NULL,
  `block2` tinyint(2) unsigned NOT NULL,
  `open` tinyint(1) unsigned NOT NULL,
  `money` smallint(6) unsigned NOT NULL DEFAULT '0',
  `opit` smallint(6) unsigned NOT NULL DEFAULT '0',
  `lovushka` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hp` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id_user`,`block`,`block2`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `text` varchar(228) NOT NULL,
  `user` int(11) NOT NULL,
  `time` int(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `news_comm`;

CREATE TABLE `news_comm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `user` int(11) NOT NULL,
  `time` int(20) NOT NULL,
  `news` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `news_status`;

CREATE TABLE `news_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `news` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `news_status_read`;

CREATE TABLE `news_status_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` int(11) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `premium`;

CREATE TABLE `premium` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `settings`;

CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_tournament_date` varchar(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO settings VALUES("1","14.05.2018");



DROP TABLE IF EXISTS `shop`;

CREATE TABLE `shop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quality` enum('1','2','3','4','5','6') NOT NULL DEFAULT '1',
  `cost` int(11) NOT NULL DEFAULT '0',
  `_str` int(11) NOT NULL DEFAULT '0',
  `_vit` int(11) NOT NULL DEFAULT '0',
  `_def` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1711 DEFAULT CHARSET=cp1251;

INSERT INTO shop VALUES("1","1","10","4","4","4");
INSERT INTO shop VALUES("2","1","10","4","4","4");
INSERT INTO shop VALUES("3","1","10","4","4","4");
INSERT INTO shop VALUES("4","1","10","4","4","4");
INSERT INTO shop VALUES("5","1","10","4","4","4");
INSERT INTO shop VALUES("6","1","10","4","4","4");
INSERT INTO shop VALUES("7","1","10","4","4","4");
INSERT INTO shop VALUES("8","1","10","4","4","4");
INSERT INTO shop VALUES("9","1","10","4","4","4");
INSERT INTO shop VALUES("10","1","10","4","4","4");
INSERT INTO shop VALUES("11","1","10","4","4","4");
INSERT INTO shop VALUES("12","1","10","4","4","4");
INSERT INTO shop VALUES("13","1","10","4","4","4");
INSERT INTO shop VALUES("14","1","10","4","4","4");
INSERT INTO shop VALUES("15","1","10","4","4","4");
INSERT INTO shop VALUES("16","1","10","4","4","4");
INSERT INTO shop VALUES("17","1","10","4","4","4");
INSERT INTO shop VALUES("18","1","10","4","4","4");
INSERT INTO shop VALUES("19","1","10","4","4","4");
INSERT INTO shop VALUES("20","1","10","4","4","4");
INSERT INTO shop VALUES("21","1","10","4","4","4");
INSERT INTO shop VALUES("22","1","10","4","4","4");
INSERT INTO shop VALUES("23","1","10","4","4","4");
INSERT INTO shop VALUES("24","1","10","4","4","4");
INSERT INTO shop VALUES("25","1","10","4","4","4");
INSERT INTO shop VALUES("26","1","10","4","4","4");
INSERT INTO shop VALUES("27","1","10","4","4","4");
INSERT INTO shop VALUES("28","1","10","4","4","4");
INSERT INTO shop VALUES("29","1","10","4","4","4");
INSERT INTO shop VALUES("30","1","10","4","4","4");
INSERT INTO shop VALUES("31","1","10","4","4","4");
INSERT INTO shop VALUES("32","1","10","4","4","4");
INSERT INTO shop VALUES("33","2","30","26","26","26");
INSERT INTO shop VALUES("34","2","30","26","26","26");
INSERT INTO shop VALUES("35","2","30","26","26","26");
INSERT INTO shop VALUES("36","2","30","26","26","26");
INSERT INTO shop VALUES("37","2","30","26","26","26");
INSERT INTO shop VALUES("38","2","30","26","26","26");
INSERT INTO shop VALUES("39","2","30","26","26","26");
INSERT INTO shop VALUES("40","2","30","26","26","26");
INSERT INTO shop VALUES("41","2","30","23","23","23");
INSERT INTO shop VALUES("42","2","30","26","26","26");
INSERT INTO shop VALUES("43","2","30","26","26","26");
INSERT INTO shop VALUES("44","2","30","26","26","26");
INSERT INTO shop VALUES("45","2","30","26","26","26");
INSERT INTO shop VALUES("46","2","30","26","26","26");
INSERT INTO shop VALUES("47","2","30","26","26","26");
INSERT INTO shop VALUES("48","2","30","26","26","26");
INSERT INTO shop VALUES("49","2","30","26","26","26");
INSERT INTO shop VALUES("50","2","30","26","26","26");
INSERT INTO shop VALUES("51","2","30","26","26","26");
INSERT INTO shop VALUES("52","2","30","26","26","26");
INSERT INTO shop VALUES("53","2","30","26","26","26");
INSERT INTO shop VALUES("54","2","30","26","26","26");
INSERT INTO shop VALUES("55","2","30","26","26","26");
INSERT INTO shop VALUES("56","2","30","26","26","26");
INSERT INTO shop VALUES("57","2","30","26","26","26");
INSERT INTO shop VALUES("58","2","30","26","26","26");
INSERT INTO shop VALUES("59","2","30","26","26","26");
INSERT INTO shop VALUES("60","2","30","26","26","26");
INSERT INTO shop VALUES("61","2","30","26","26","26");
INSERT INTO shop VALUES("62","2","30","26","26","26");
INSERT INTO shop VALUES("63","2","30","26","26","26");
INSERT INTO shop VALUES("64","2","30","26","26","26");
INSERT INTO shop VALUES("65","3","60","52","52","52");
INSERT INTO shop VALUES("66","3","60","52","52","52");
INSERT INTO shop VALUES("67","3","60","52","52","52");
INSERT INTO shop VALUES("68","3","60","52","52","52");
INSERT INTO shop VALUES("69","3","60","52","52","52");
INSERT INTO shop VALUES("70","3","60","52","52","52");
INSERT INTO shop VALUES("71","3","60","52","52","52");
INSERT INTO shop VALUES("72","3","60","52","52","52");
INSERT INTO shop VALUES("73","3","60","52","52","52");
INSERT INTO shop VALUES("74","3","60","52","52","52");
INSERT INTO shop VALUES("75","3","60","52","52","52");
INSERT INTO shop VALUES("76","3","60","52","52","52");
INSERT INTO shop VALUES("77","3","60","52","52","52");
INSERT INTO shop VALUES("78","3","60","52","52","52");
INSERT INTO shop VALUES("79","3","60","52","52","52");
INSERT INTO shop VALUES("80","3","60","52","52","52");
INSERT INTO shop VALUES("81","3","60","52","52","52");
INSERT INTO shop VALUES("82","3","60","52","52","52");
INSERT INTO shop VALUES("83","3","60","52","52","52");
INSERT INTO shop VALUES("84","3","60","52","52","52");
INSERT INTO shop VALUES("85","3","60","60","60","60");
INSERT INTO shop VALUES("86","3","60","52","52","52");
INSERT INTO shop VALUES("87","3","60","52","52","52");
INSERT INTO shop VALUES("88","3","60","52","52","52");
INSERT INTO shop VALUES("89","3","60","52","52","52");
INSERT INTO shop VALUES("90","3","60","52","52","52");
INSERT INTO shop VALUES("91","3","60","52","52","52");
INSERT INTO shop VALUES("92","3","60","52","52","52");
INSERT INTO shop VALUES("93","3","60","52","52","52");
INSERT INTO shop VALUES("94","3","60","52","52","52");
INSERT INTO shop VALUES("95","3","60","52","52","52");
INSERT INTO shop VALUES("96","3","60","52","52","52");
INSERT INTO shop VALUES("97","4","200","95","95","95");
INSERT INTO shop VALUES("98","4","200","95","95","95");
INSERT INTO shop VALUES("99","4","200","95","95","95");
INSERT INTO shop VALUES("100","4","200","95","95","95");
INSERT INTO shop VALUES("101","4","200","95","95","95");
INSERT INTO shop VALUES("102","4","200","95","95","95");
INSERT INTO shop VALUES("103","4","200","95","95","95");
INSERT INTO shop VALUES("104","4","200","95","95","95");
INSERT INTO shop VALUES("105","4","200","95","95","95");
INSERT INTO shop VALUES("106","4","200","95","95","95");
INSERT INTO shop VALUES("107","4","200","95","95","95");
INSERT INTO shop VALUES("108","4","200","95","95","95");
INSERT INTO shop VALUES("109","4","200","95","95","95");
INSERT INTO shop VALUES("110","4","200","95","95","95");
INSERT INTO shop VALUES("111","4","200","95","95","95");
INSERT INTO shop VALUES("112","4","200","95","95","95");
INSERT INTO shop VALUES("113","4","200","95","95","95");
INSERT INTO shop VALUES("114","4","200","95","95","95");
INSERT INTO shop VALUES("115","4","200","95","95","95");
INSERT INTO shop VALUES("177","6","5000","232","232","232");
INSERT INTO shop VALUES("116","4","200","95","95","95");
INSERT INTO shop VALUES("117","4","200","95","95","95");
INSERT INTO shop VALUES("118","4","200","95","95","95");
INSERT INTO shop VALUES("119","4","200","95","95","95");
INSERT INTO shop VALUES("120","4","200","95","95","95");
INSERT INTO shop VALUES("121","4","200","95","95","95");
INSERT INTO shop VALUES("122","4","200","95","95","95");
INSERT INTO shop VALUES("123","4","200","95","95","95");
INSERT INTO shop VALUES("124","4","200","95","95","95");
INSERT INTO shop VALUES("125","4","2000","95","95","95");
INSERT INTO shop VALUES("126","4","200","95","95","95");
INSERT INTO shop VALUES("127","4","200","95","95","95");
INSERT INTO shop VALUES("128","4","200","95","95","95");
INSERT INTO shop VALUES("129","4","200","59","95","95");
INSERT INTO shop VALUES("130","4","200","95","95","95");
INSERT INTO shop VALUES("131","4","200","95","95","95");
INSERT INTO shop VALUES("132","4","200","95","95","95");
INSERT INTO shop VALUES("133","4","200","95","95","95");
INSERT INTO shop VALUES("134","4","200","95","95","95");
INSERT INTO shop VALUES("135","4","200","95","95","95");
INSERT INTO shop VALUES("136","4","200","95","95","95");
INSERT INTO shop VALUES("137","5","2000","160","160","160");
INSERT INTO shop VALUES("138","5","2000","160","160","160");
INSERT INTO shop VALUES("139","5","2000","160","160","160");
INSERT INTO shop VALUES("140","5","2000","160","160","160");
INSERT INTO shop VALUES("141","5","2000","160","160","160");
INSERT INTO shop VALUES("142","5","2000","160","160","160");
INSERT INTO shop VALUES("143","5","2000","160","160","160");
INSERT INTO shop VALUES("144","5","2000","160","160","160");
INSERT INTO shop VALUES("145","5","2000","160","160","160");
INSERT INTO shop VALUES("146","5","2000","160","160","160");
INSERT INTO shop VALUES("147","5","2000","160","160","160");
INSERT INTO shop VALUES("148","5","2000","160","160","160");
INSERT INTO shop VALUES("149","5","2000","160","160","160");
INSERT INTO shop VALUES("150","5","2000","160","160","160");
INSERT INTO shop VALUES("151","5","2000","160","160","160");
INSERT INTO shop VALUES("152","5","2000","160","160","160");
INSERT INTO shop VALUES("153","5","2000","160","160","160");
INSERT INTO shop VALUES("154","5","2000","160","160","160");
INSERT INTO shop VALUES("155","5","2000","160","160","160");
INSERT INTO shop VALUES("156","5","2000","160","160","160");
INSERT INTO shop VALUES("157","5","2000","160","160","160");
INSERT INTO shop VALUES("158","5","2000","160","160","160");
INSERT INTO shop VALUES("159","5","2000","160","160","160");
INSERT INTO shop VALUES("160","5","2000","160","160","160");
INSERT INTO shop VALUES("161","5","2000","160","160","160");
INSERT INTO shop VALUES("162","5","2000","160","160","160");
INSERT INTO shop VALUES("163","5","2000","160","160","160");
INSERT INTO shop VALUES("164","5","2000","160","160","160");
INSERT INTO shop VALUES("165","5","2000","160","160","160");
INSERT INTO shop VALUES("166","5","2000","160","160","160");
INSERT INTO shop VALUES("167","5","2000","160","160","160");
INSERT INTO shop VALUES("168","5","2000","160","160","160");
INSERT INTO shop VALUES("169","5","2000","160","160","160");
INSERT INTO shop VALUES("170","5","2000","160","160","160");
INSERT INTO shop VALUES("171","5","2000","160","160","160");
INSERT INTO shop VALUES("172","5","2000","160","160","160");
INSERT INTO shop VALUES("173","5","2000","160","160","160");
INSERT INTO shop VALUES("174","5","2000","160","160","160");
INSERT INTO shop VALUES("175","1","2000","160","160","160");
INSERT INTO shop VALUES("176","5","2000","160","160","160");
INSERT INTO shop VALUES("178","6","5000","232","232","232");
INSERT INTO shop VALUES("179","6","5000","232","232","232");
INSERT INTO shop VALUES("180","6","5000","232","232","232");
INSERT INTO shop VALUES("181","6","5000","232","232","232");
INSERT INTO shop VALUES("182","6","5000","232","232","232");
INSERT INTO shop VALUES("183","6","5000","232","232","232");
INSERT INTO shop VALUES("184","6","5000","232","232","232");
INSERT INTO shop VALUES("185","6","5000","232","232","232");
INSERT INTO shop VALUES("186","6","5000","232","232","232");
INSERT INTO shop VALUES("187","6","5000","232","232","232");
INSERT INTO shop VALUES("188","6","5000","232","232","232");
INSERT INTO shop VALUES("189","6","5000","232","232","232");
INSERT INTO shop VALUES("190","6","5000","232","232","232");
INSERT INTO shop VALUES("191","6","5000","232","232","232");
INSERT INTO shop VALUES("192","6","5000","232","232","232");
INSERT INTO shop VALUES("193","6","5000","232","232","232");
INSERT INTO shop VALUES("194","6","5000","232","232","232");
INSERT INTO shop VALUES("195","6","5000","232","232","232");
INSERT INTO shop VALUES("196","6","5000","232","232","232");
INSERT INTO shop VALUES("197","6","5000","232","232","232");
INSERT INTO shop VALUES("198","6","5000","232","232","232");
INSERT INTO shop VALUES("199","6","5000","232","232","232");
INSERT INTO shop VALUES("200","6","5000","232","232","232");
INSERT INTO shop VALUES("201","6","5000","232","232","232");
INSERT INTO shop VALUES("202","6","5000","232","232","232");
INSERT INTO shop VALUES("203","6","5000","232","232","232");
INSERT INTO shop VALUES("204","6","5000","232","232","232");
INSERT INTO shop VALUES("205","6","5000","232","232","232");
INSERT INTO shop VALUES("206","6","5000","232","232","232");
INSERT INTO shop VALUES("207","6","5000","232","232","232");
INSERT INTO shop VALUES("208","6","5000","232","232","232");
INSERT INTO shop VALUES("209","6","5000","232","232","232");
INSERT INTO shop VALUES("210","6","5000","232","232","232");
INSERT INTO shop VALUES("211","6","5000","232","232","232");
INSERT INTO shop VALUES("212","6","5000","232","232","232");
INSERT INTO shop VALUES("213","6","5000","232","232","232");
INSERT INTO shop VALUES("214","6","5000","232","232","232");
INSERT INTO shop VALUES("215","6","5000","232","232","232");
INSERT INTO shop VALUES("216","6","5000","232","232","232");
INSERT INTO shop VALUES("217","6","5000","232","232","232");
INSERT INTO shop VALUES("218","6","5000","232","232","232");
INSERT INTO shop VALUES("219","6","5000","232","232","232");
INSERT INTO shop VALUES("220","6","5000","232","232","232");
INSERT INTO shop VALUES("221","6","5000","232","232","232");
INSERT INTO shop VALUES("222","6","5000","232","232","232");
INSERT INTO shop VALUES("223","6","5000","232","232","232");
INSERT INTO shop VALUES("224","6","5000","232","232","232");
INSERT INTO shop VALUES("225","6","5000","232","232","232");
INSERT INTO shop VALUES("226","6","5000","232","232","232");
INSERT INTO shop VALUES("227","6","5000","232","232","232");
INSERT INTO shop VALUES("228","6","5000","232","232","232");
INSERT INTO shop VALUES("229","6","5000","232","232","232");
INSERT INTO shop VALUES("230","6","5000","232","232","232");
INSERT INTO shop VALUES("231","6","5000","232","232","232");
INSERT INTO shop VALUES("232","6","5000","232","232","232");
INSERT INTO shop VALUES("233","6","5000","232","232","232");
INSERT INTO shop VALUES("234","6","5000","232","232","232");
INSERT INTO shop VALUES("235","6","5000","232","232","232");
INSERT INTO shop VALUES("236","6","5000","232","232","232");
INSERT INTO shop VALUES("237","6","5000","232","232","232");
INSERT INTO shop VALUES("238","6","5000","232","232","232");
INSERT INTO shop VALUES("239","6","5000","232","232","232");
INSERT INTO shop VALUES("240","6","5000","232","232","232");



DROP TABLE IF EXISTS `task`;

CREATE TABLE `task` (
  `id` int(100) NOT NULL DEFAULT '0',
  `name` text,
  `type` enum('daily','storyline') NOT NULL,
  `glava` int(11) NOT NULL,
  `how` int(11) NOT NULL DEFAULT '0',
  `_gold` int(11) NOT NULL DEFAULT '0',
  `_silver` int(11) NOT NULL DEFAULT '0',
  `_exp` int(11) NOT NULL DEFAULT '0',
  `place` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

INSERT INTO task VALUES("1","Сразись 3 раза с боссами","daily","0","3","3","200","250","1");
INSERT INTO task VALUES("2","Победи 30 противников на Арене","daily","0","30","5","500","200","2");
INSERT INTO task VALUES("3","Победи в 2 битвах в Колизее","daily","0","2","3","500","500","3");
INSERT INTO task VALUES("4","Проведи 6 боев в Колизее","daily","0","6","0","0","0","");
INSERT INTO task VALUES("5","Подними параметры героя 3 раза","daily","0","3","0","0","0","");
INSERT INTO task VALUES("6","Сходи в набег 2 раза","daily","0","2","0","0","0","");
INSERT INTO task VALUES("7","Купи 200 золота и получи еще 20 золота в подарок","daily","0","200","0","0","0","");
INSERT INTO task VALUES("8","Купи 1000 золота и получи еще 50 золота в подарок","daily","0","1000","0","0","0","");
INSERT INTO task VALUES("18","Убей 3 орков","storyline","2","3","10","1000","1000","");
INSERT INTO task VALUES("9","Убей 3 волков","storyline","1","3","10","1000","1000","");
INSERT INTO task VALUES("10","Улучши амулет","storyline","1","2","10","1000","1000","");
INSERT INTO task VALUES("11","Победи 25 раз на арене","storyline","1","25","10","1000","1000","");
INSERT INTO task VALUES("12","Тренируй силу до 15","storyline","1","15","10","1000","1000","");
INSERT INTO task VALUES("13","Надень 8 простых вещей","storyline","1","8","10","1000","1000","");
INSERT INTO task VALUES("14","Разбери 10 любых вещей","storyline","1","10","10","1000","1000","");
INSERT INTO task VALUES("15","Набери 125 здоровья","storyline","1","125","10","1000","1000","");
INSERT INTO task VALUES("16","Заточи все вещи на +1","storyline","1","8","10","1000","1000","");
INSERT INTO task VALUES("17","Убей оборотня в пещере ","storyline","1","1","10","1000","1000","");
INSERT INTO task VALUES("19","Купи 3 любые вещи в магазине","storyline","2","3","20","2000","2000","");
INSERT INTO task VALUES("20","Тренируй броню до 30","storyline","2","30","20","2000","2000","");
INSERT INTO task VALUES("21","Заточи все вещи на +2","storyline","2","8","20","2000","2000","");
INSERT INTO task VALUES("22","Победи 60 врагов на арене","storyline","2","60","20","2000","2000","");
INSERT INTO task VALUES("23","Прокачай умение Ярость до 1 уровня","storyline","2","1","20","2000","2000","");
INSERT INTO task VALUES("24","Набери 330 здоровья","storyline","2","330","20","2000","2000","");
INSERT INTO task VALUES("25","Найди на арене 6 вещей необычного качества и лучше","storyline","2","6","20","2000","2000","");
INSERT INTO task VALUES("26","Разбери 30 любых вещей","storyline","2","30","20","2000","2000","");
INSERT INTO task VALUES("27","Убей Горного тролля ","storyline","2","1","20","2000","2000","");
INSERT INTO task VALUES("28","Убей 3 зомби","storyline","3","3","30","3000","3000","");
INSERT INTO task VALUES("29","Улучши амулет до 5","storyline","3","5","30","3000","3000","");
INSERT INTO task VALUES("30","Набери 500 брони","storyline","3","500","30","3000","3000","");
INSERT INTO task VALUES("31","Прокачай все умения до 1 уровня","storyline","3","4","30","3000","3000","");
INSERT INTO task VALUES("32","Надень 6 вещей редкого качества и выше","storyline","3","6","30","3000","3000","");
INSERT INTO task VALUES("33","Разбери 10 необычных вещей","storyline","3","10","30","3000","3000","");
INSERT INTO task VALUES("34","Заточи все вещи на +5","storyline","3","8","30","3000","3000","");
INSERT INTO task VALUES("35","Разбери 45 любых вещей","storyline","3","45","30","3000","3000","");
INSERT INTO task VALUES("36","Установи 2 руны обычного качества и выше","storyline","3","2","30","3000","3000","");
INSERT INTO task VALUES("37","Набери 600 силы","storyline","3","600","30","3000","3000","");
INSERT INTO task VALUES("38","Тренируй здоровье до 35","storyline","3","35","30","3000","3000","");
INSERT INTO task VALUES("39","Найди и убей Вампира","storyline","3","1","30","3000","3000","");
INSERT INTO task VALUES("40","Прокачай 4 умения до 3 уровня","storyline","4","4","40","4000","4000","");
INSERT INTO task VALUES("41","Надень 6 вещей эпического качества и выше","storyline","4","6","40","4000","4000","");
INSERT INTO task VALUES("42","Заточи все вещи на +6","storyline","4","8","40","4000","4000","");
INSERT INTO task VALUES("43","Разбери 10 редких вещей","storyline","4","10","40","4000","4000","");
INSERT INTO task VALUES("44","Убей 3 гончих","storyline","4","3","40","4000","4000","");
INSERT INTO task VALUES("45","Убей цербера","storyline","4","1","40","4000","4000","");
INSERT INTO task VALUES("46","Прокачай амулет до 7","storyline","4","7","40","4000","4000","");
INSERT INTO task VALUES("47","Победи 200 раз на арене","storyline","4","200","40","4000","4000","");
INSERT INTO task VALUES("48","Тренируй силу до 40","storyline","4","40","40","4000","4000","");
INSERT INTO task VALUES("49","Прокачай здоровье до 1100 \r\n","storyline","4","1100","40","4000","4000","");



DROP TABLE IF EXISTS `task_user`;

CREATE TABLE `task_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `task` int(11) NOT NULL DEFAULT '0',
  `type` enum('daily','storyline') NOT NULL,
  `how` int(11) NOT NULL DEFAULT '0',
  `complete` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=cp1251;

INSERT INTO task_user VALUES("1","0","1","daily","0","0","0");
INSERT INTO task_user VALUES("2","0","2","daily","0","0","0");
INSERT INTO task_user VALUES("3","0","3","daily","0","0","0");
INSERT INTO task_user VALUES("4","0","4","daily","0","0","0");
INSERT INTO task_user VALUES("5","0","5","daily","0","0","0");
INSERT INTO task_user VALUES("6","0","6","daily","0","0","0");
INSERT INTO task_user VALUES("7","0","7","daily","0","0","0");
INSERT INTO task_user VALUES("8","0","8","daily","0","0","0");
INSERT INTO task_user VALUES("9","1","1","daily","1","0","0");
INSERT INTO task_user VALUES("10","1","2","daily","2","0","0");
INSERT INTO task_user VALUES("11","1","3","daily","0","0","0");
INSERT INTO task_user VALUES("12","1","4","daily","0","0","0");
INSERT INTO task_user VALUES("13","1","5","daily","0","0","0");
INSERT INTO task_user VALUES("14","1","6","daily","1","0","0");
INSERT INTO task_user VALUES("15","1","7","daily","0","0","0");
INSERT INTO task_user VALUES("16","1","8","daily","0","0","0");
INSERT INTO task_user VALUES("17","1","9","storyline","1","0","0");
INSERT INTO task_user VALUES("18","1","10","storyline","1","0","0");
INSERT INTO task_user VALUES("19","1","11","storyline","2","0","0");
INSERT INTO task_user VALUES("20","1","12","storyline","0","0","0");
INSERT INTO task_user VALUES("21","1","13","storyline","0","0","0");
INSERT INTO task_user VALUES("22","1","14","storyline","0","0","0");
INSERT INTO task_user VALUES("23","1","15","storyline","39","0","0");
INSERT INTO task_user VALUES("24","1","16","storyline","0","0","0");
INSERT INTO task_user VALUES("25","1","17","storyline","0","0","0");
INSERT INTO task_user VALUES("26","2","1","daily","0","0","0");
INSERT INTO task_user VALUES("27","2","2","daily","0","0","0");
INSERT INTO task_user VALUES("28","2","3","daily","0","0","0");
INSERT INTO task_user VALUES("29","2","4","daily","0","0","0");
INSERT INTO task_user VALUES("30","2","5","daily","0","0","0");
INSERT INTO task_user VALUES("31","2","6","daily","0","0","0");
INSERT INTO task_user VALUES("32","2","7","daily","0","0","0");
INSERT INTO task_user VALUES("33","2","8","daily","0","0","0");
INSERT INTO task_user VALUES("34","2","9","storyline","0","0","0");
INSERT INTO task_user VALUES("35","2","10","storyline","1","0","0");
INSERT INTO task_user VALUES("36","2","11","storyline","0","0","0");
INSERT INTO task_user VALUES("37","2","12","storyline","0","0","0");
INSERT INTO task_user VALUES("38","2","13","storyline","0","0","0");
INSERT INTO task_user VALUES("39","2","14","storyline","0","0","0");
INSERT INTO task_user VALUES("40","2","15","storyline","39","0","0");
INSERT INTO task_user VALUES("41","2","16","storyline","0","0","0");
INSERT INTO task_user VALUES("42","2","17","storyline","0","0","0");
INSERT INTO task_user VALUES("43","3","1","daily","0","0","0");
INSERT INTO task_user VALUES("44","3","2","daily","0","0","0");
INSERT INTO task_user VALUES("45","3","3","daily","0","0","0");
INSERT INTO task_user VALUES("46","3","4","daily","0","0","0");
INSERT INTO task_user VALUES("47","3","5","daily","0","0","0");
INSERT INTO task_user VALUES("48","3","6","daily","0","0","0");
INSERT INTO task_user VALUES("49","3","7","daily","0","0","0");
INSERT INTO task_user VALUES("50","3","8","daily","0","0","0");
INSERT INTO task_user VALUES("51","3","9","storyline","0","0","0");
INSERT INTO task_user VALUES("52","3","10","storyline","0","0","0");
INSERT INTO task_user VALUES("53","3","11","storyline","0","0","0");
INSERT INTO task_user VALUES("54","3","12","storyline","0","0","0");
INSERT INTO task_user VALUES("55","3","13","storyline","0","0","0");
INSERT INTO task_user VALUES("56","3","14","storyline","0","0","0");
INSERT INTO task_user VALUES("57","3","15","storyline","0","0","0");
INSERT INTO task_user VALUES("58","3","16","storyline","0","0","0");
INSERT INTO task_user VALUES("59","3","17","storyline","0","0","0");



DROP TABLE IF EXISTS `ticket`;

CREATE TABLE `ticket` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` varchar(8048) NOT NULL,
  `status` enum('new','read','close','user') NOT NULL,
  `user_read` enum('0','1') NOT NULL DEFAULT '0',
  `admin_read` enum('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ticket_answer`;

CREATE TABLE `ticket_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `text` varchar(2048) NOT NULL,
  `ticket` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `travel`;

CREATE TABLE `travel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `h` int(11) NOT NULL DEFAULT '0',
  `step` int(11) NOT NULL,
  `boss` int(11) NOT NULL,
  `user_hp` int(11) NOT NULL,
  `boss_hp` int(11) NOT NULL,
  `boss_attack` int(11) NOT NULL,
  `boss_def` int(11) NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO travel VALUES("1","1","1","1","2","39","102","102","102","1551824698");



DROP TABLE IF EXISTS `travel_boss`;

CREATE TABLE `travel_boss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `name2` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO travel_boss VALUES("1","Бродяга","Бродягу");
INSERT INTO travel_boss VALUES("2","Одинокий путник","Одинокого путника");
INSERT INTO travel_boss VALUES("3","Повозка с серебром","Повозку с серебром");
INSERT INTO travel_boss VALUES("4","Купец","Купца");
INSERT INTO travel_boss VALUES("5","Повозка","Повозку");
INSERT INTO travel_boss VALUES("6","Знатный вельможа","Знатного вельможу");
INSERT INTO travel_boss VALUES("7","Обоз с товарами","Обоз с товарами");
INSERT INTO travel_boss VALUES("8","Повозка с серебром ","Повозку с серебром ");
INSERT INTO travel_boss VALUES("9","Вооруженный отряд","Вооруженный отряд");
INSERT INTO travel_boss VALUES("10","Разбойники","Разбойников");
INSERT INTO travel_boss VALUES("11","Караван","Караван");
INSERT INTO travel_boss VALUES("12","Повозка с серебром","Повозку с серебром");
INSERT INTO travel_boss VALUES("13","Темный рыцарь","Темного рыцаря");
INSERT INTO travel_boss VALUES("14","Войско императора","Войско императора");
INSERT INTO travel_boss VALUES("15","Лагерь разбойников","Лагерь разбойников");
INSERT INTO travel_boss VALUES("16","Черный голем","Черного голема");
INSERT INTO travel_boss VALUES("17","Гигант - отшельник","Гиганта - отшельника");
INSERT INTO travel_boss VALUES("18","Маг - ренегат","Мага - ренегата");



DROP TABLE IF EXISTS `travel_log`;

CREATE TABLE `travel_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `trophies`;

CREATE TABLE `trophies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `param` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `silver` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO trophies VALUES("1","Голова Оборотня","20","3","3");
INSERT INTO trophies VALUES("2","Голова Тролля","30","3","3");
INSERT INTO trophies VALUES("3","Голова Вампира\r\n","50","3","3");
INSERT INTO trophies VALUES("4","Голова Цербера","50","3","3");
INSERT INTO trophies VALUES("5","Голова Горгоны","50","3","3");
INSERT INTO trophies VALUES("6","Голова Некроманта","50","3","3");
INSERT INTO trophies VALUES("7","Голова Циклопа","50","3","3");
INSERT INTO trophies VALUES("8","Голова Гидры","50","3","3");
INSERT INTO trophies VALUES("9","Голова Кошмара","50","3","3");
INSERT INTO trophies VALUES("10","Голова Ифрита","50","3","3");
INSERT INTO trophies VALUES("11","Голова Мантикоры","50","3","3");
INSERT INTO trophies VALUES("12","Голова Виверны\r\n","50","3","3");
INSERT INTO trophies VALUES("13","Голова Феникса\r\n","50","3","3");
INSERT INTO trophies VALUES("14","Голова Владыки","50","3","3");
INSERT INTO trophies VALUES("15","Голова Гиганта","50","3","3");
INSERT INTO trophies VALUES("16","Голова Властелина\r\n","50","3","3");
INSERT INTO trophies VALUES("17","Голова Повелителя","50","3","3");
INSERT INTO trophies VALUES("18","Голова Ужаса","50","3","3");
INSERT INTO trophies VALUES("19","Голова Фенрира","50","3","3");
INSERT INTO trophies VALUES("20","Голова Хель","50","3","3");



DROP TABLE IF EXISTS `trophies_user`;

CREATE TABLE `trophies_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `trophies_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `param` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `silver` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `password` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `step` int(11) NOT NULL,
  `sex` enum('0','1') CHARACTER SET utf8 NOT NULL DEFAULT '0',
  `online` int(11) NOT NULL DEFAULT '0',
  `access` enum('0','1','2','3') NOT NULL DEFAULT '0',
  `r` enum('0','1') NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '1',
  `exp` int(11) NOT NULL DEFAULT '0',
  `g` int(11) NOT NULL DEFAULT '0',
  `s` int(11) NOT NULL DEFAULT '0',
  `skill` int(11) NOT NULL DEFAULT '0',
  `str` int(11) NOT NULL DEFAULT '10',
  `_str` int(11) NOT NULL DEFAULT '0',
  `vit` int(11) NOT NULL DEFAULT '10',
  `_vit` int(11) NOT NULL DEFAULT '0',
  `def` int(11) NOT NULL DEFAULT '10',
  `_def` int(11) NOT NULL DEFAULT '0',
  `w_1` int(11) NOT NULL DEFAULT '0',
  `w_2` int(11) NOT NULL DEFAULT '0',
  `w_3` int(11) NOT NULL DEFAULT '0',
  `w_4` int(11) NOT NULL DEFAULT '0',
  `w_5` int(11) NOT NULL DEFAULT '0',
  `w_6` int(11) NOT NULL DEFAULT '0',
  `w_7` int(11) NOT NULL DEFAULT '0',
  `w_8` int(11) NOT NULL DEFAULT '0',
  `ip` text,
  `ua` text,
  `self` text,
  `ability_1` int(11) NOT NULL DEFAULT '0',
  `ability_1_quality` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0',
  `ability_2` int(11) NOT NULL DEFAULT '0',
  `ability_2_quality` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0',
  `ability_3` int(11) NOT NULL DEFAULT '0',
  `ability_3_quality` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0',
  `ability_4` int(11) NOT NULL DEFAULT '0',
  `ability_4_quality` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0',
  `ability_5` int(11) NOT NULL DEFAULT '0',
  `ability_5_quality` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0',
  `bg` enum('0','1','2','3','4') NOT NULL DEFAULT '0',
  `chest` enum('0','1') NOT NULL DEFAULT '0',
  `mail_closed` int(11) NOT NULL DEFAULT '0',
  `bonus_date` varchar(11) NOT NULL,
  `amulet` int(11) NOT NULL DEFAULT '1',
  `amulet_stat` int(11) NOT NULL,
  `amulet_exp` int(11) NOT NULL,
  `amulet_silver` int(11) NOT NULL,
  `lair` int(11) NOT NULL,
  `lair_glava` int(11) NOT NULL,
  `lair_boi` int(11) NOT NULL,
  `lair_gold` int(11) NOT NULL,
  `coliseum_id` int(11) NOT NULL,
  `coliseum_rating` int(11) NOT NULL,
  `trophies_exp` int(11) NOT NULL,
  `trophies_silver` int(11) NOT NULL,
  `maze_kluch` int(11) NOT NULL,
  `task_kluch` int(11) NOT NULL,
  `notified` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=cp1251;

INSERT INTO users VALUES("1","Admin","92a35d8b542d4b11a6430f4db05c7e8d","0","0","1551821625","3","0","1","151","30","36","0","39","0","39","0","39","0","0","0","0","0","0","0","0","0","127.0.0.1","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36 OPR/58.0.3135.79","/index.php","0","0","0","0","0","0","0","0","0","0","0","0","0","06.03.2019","1","0","0","0","2","1","1","0","0","0","0","0","0","0","1");
INSERT INTO users VALUES("2","system","92a35d8b542d4b11a6430f4db05c7e8d","0","0","1551821076","0","0","1","9","20","12","0","39","0","39","0","39","0","0","0","0","0","0","0","0","0","127.0.0.1","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36 OPR/58.0.3135.79","/index.php","0","0","0","0","0","0","0","0","0","0","0","0","0","06.03.2019","1","0","0","0","1","1","2","0","0","0","0","0","0","0","1");
INSERT INTO users VALUES("3","111111","92a35d8b542d4b11a6430f4db05c7e8d","0","0","1552549223","0","0","1","9","1000020","10000012","0","39","0","39","0","39","0","0","0","0","0","0","0","0","0","213.87.134.77","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.109 YaBrowser/19.3.0.2485 Yowser/2.5 Safari/537.36","/index.php","0","0","0","0","0","0","0","0","0","0","0","0","0","14.03.2019","1","0","0","0","1","1","2","0","0","0","0","0","0","0","0");



