--
-- Структура таблицы `adm_chat`
--

CREATE TABLE IF NOT EXISTS `adm_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `amulet_user`
--

CREATE TABLE IF NOT EXISTS `amulet_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `level` int(11) NOT NULL DEFAULT '1',
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `energy` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `arena`
--

CREATE TABLE IF NOT EXISTS `arena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `auction`
--

CREATE TABLE IF NOT EXISTS `auction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `summa` int(11) NOT NULL,
  `summa_2` int(11) NOT NULL DEFAULT '0',
  `skidka` int(11) NOT NULL,
  `skidka_2` int(11) NOT NULL DEFAULT '0',
  `name` set('gold','train','pit','shop','smitch','amulet','clan_stat','exp') NOT NULL,
  `zagolovok` varchar(100) NOT NULL,
  `text` text NOT NULL,
  `text_2` text NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Дамп данных таблицы `auction`
--

INSERT INTO `auction` (`id`, `summa`, `summa_2`, `skidka`, `skidka_2`, `name`, `zagolovok`, `text`, `text_2`, `last`) VALUES
(1, 300, 500, 45, 45, 'exp', 'Акция - бонус опыта', 'Купи 300 или больше золота и получай 45% к добываемому опыту!', '', 1473395306);

--
-- Структура таблицы `ban`
--

CREATE TABLE IF NOT EXISTS `ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_admin` int(11) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL DEFAULT '0',
  `block` set('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `bashna`
--

CREATE TABLE IF NOT EXISTS `bashna` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `gold` int(11) NOT NULL DEFAULT '0',
  `side` set('good','evil','','') NOT NULL,
  `health` int(11) NOT NULL,
  `max_health` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Дамп данных таблицы `bashna`
--

INSERT INTO `bashna` (`id`, `name`, `gold`, `side`, `health`, `max_health`, `last`) VALUES
(1, 'Башня смерти', 50, 'evil', 8159, 20000, 1473318835),
(2, 'Ущелье', 75, 'evil', 24560, 30000, 1473168220),
(3, 'Деревня', 100, 'evil', 40000, 40000, 1473280148),
(4, 'Старый замок', 150, 'evil', 40937, 50000, 1473101977),
(5, 'Крепость дракона', 200, 'good', 60000, 60000, 1473266768),
(6, 'Старый храм', 250, 'evil', 31373, 70000, 1472920543);

--
-- Структура таблицы `bashna_log`
--

CREATE TABLE IF NOT EXISTS `bashna_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `tipe` set('bashna','user','zahvat','remont','users') NOT NULL,
  `uron` int(11) NOT NULL,
  `krit` int(11) NOT NULL DEFAULT '0',
  `id_bashna` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `boss`
--

CREATE TABLE IF NOT EXISTS `boss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `max_health` int(11) NOT NULL,
  `min_gold` int(11) NOT NULL,
  `max_gold` int(11) NOT NULL,
  `min_exp` int(11) NOT NULL,
  `max_exp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;

--
-- Дамп данных таблицы `boss`
--

INSERT INTO `boss` (`id`, `name`, `str`, `def`, `max_health`, `min_gold`, `max_gold`, `min_exp`, `max_exp`) VALUES
(1, 'Сторажевой пес', 40, 40, 567, 1, 3, 10, 30),
(2, 'Повелитель волков', 70, 70, 723, 1, 4, 10, 40),
(3, 'Оборотень', 140, 140, 800, 1, 5, 10, 50),
(4, 'Повелитель стихии', 203, 203, 990, 2, 10, 20, 60),
(5, 'Волшебник', 245, 245, 1230, 2, 11, 20, 70),
(6, 'Одержимый', 300, 300, 1408, 2, 12, 20, 80),
(7, 'Мститель', 378, 378, 1689, 5, 20, 50, 200),
(8, 'Неуязвимый', 423, 423, 1754, 10, 25, 100, 300),
(9, 'Вершитель скал', 578, 578, 1900, 15, 30, 300, 500),
(10, 'Повелитель быков', 645, 645, 2000, 16, 30, 400, 600),
(11, 'Смертоносец', 800, 800, 3400, 20, 34, 800, 1000),
(12, 'Великан', 1179, 1179, 3887, 21, 35, 900, 1100),
(13, 'Силиус', 1997, 1997, 4000, 30, 40, 1000, 1300),
(14, 'Водяной', 2300, 2300, 5677, 30, 45, 1235, 1500),
(15, 'Водяная леди', 3000, 3000, 7000, 35, 50, 1500, 1800),
(16, 'Воин анубиса', 3500, 3500, 10000, 40, 55, 1800, 2000),
(17, 'Посланник сатаны', 4000, 4000, 12000, 50, 60, 2000, 2200),
(18, 'Исчадье ада', 4200, 4200, 15000, 55, 60, 2200, 2400),
(19, 'Смерть несущий', 4300, 4300, 18000, 60, 65, 2400, 2600),
(20, 'Демон огня', 4400, 4400, 20000, 65, 70, 2600, 2800),
(21, 'Кронос', 4600, 4600, 22000, 65, 75, 2800, 3000),
(22, 'Отец титанов', 5000, 5000, 28000, 70, 75, 3000, 3200),
(23, 'Великий поглотитель', 5500, 5500, 40000, 75, 80, 3200, 3400);

--
-- Структура таблицы `boss_batlle`
--

CREATE TABLE IF NOT EXISTS `boss_batlle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_boss` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `boss_health` int(11) NOT NULL,
  `user_health` int(11) NOT NULL,
  `kamen` int(11) NOT NULL,
  `trava` int(11) NOT NULL,
  `udar_last` int(11) NOT NULL,
  `win` set('net','da') NOT NULL DEFAULT 'net',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `boss_batlle_log`
--

CREATE TABLE IF NOT EXISTS `boss_batlle_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uron` int(11) NOT NULL,
  `krit` int(11) NOT NULL DEFAULT '0',
  `tip` varchar(100) NOT NULL,
  `id_batlle` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `boss_user`
--

CREATE TABLE IF NOT EXISTS `boss_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_boss` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `cforum_comments`
--

CREATE TABLE IF NOT EXISTS `cforum_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_topic` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_clan` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `text` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `cforum_sub`
--

CREATE TABLE IF NOT EXISTS `cforum_sub` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_clan` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `clan_rang` set('1','4') NOT NULL,
  `gb` set('0','1') NOT NULL DEFAULT '0',
  `sett_user` int(11) NOT NULL,
  `sett_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `cforum_topic`
--

CREATE TABLE IF NOT EXISTS `cforum_topic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_clan` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `top` set('0','1','','') NOT NULL DEFAULT '0',
  `close` set('0','1','','') NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `onlick` int(11) NOT NULL,
  `dr_igrok` set('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `chat`
--

CREATE TABLE IF NOT EXISTS `chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `clanchat`
--

CREATE TABLE IF NOT EXISTS `clanchat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_clan` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `clans`
--

CREATE TABLE IF NOT EXISTS `clans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NOT NULL DEFAULT '1',
  `exp` int(11) NOT NULL DEFAULT '0',
  `gold` int(11) NOT NULL DEFAULT '0',
  `crystals` int(11) NOT NULL DEFAULT '0',
  `name` tinytext NOT NULL,
  `info` varchar(100) NOT NULL COMMENT 'Добавьте описание',
  `date` int(11) NOT NULL,
  `gerb` int(11) NOT NULL DEFAULT '0',
  `side` varchar(100) NOT NULL,
  `stat` int(11) NOT NULL DEFAULT '0',
  `stat_level` int(11) NOT NULL DEFAULT '0',
  `vstup` int(11) NOT NULL DEFAULT '0',
  `ob` varchar(100) NOT NULL COMMENT 'Объевление клана',
  `user` int(11) NOT NULL,
  `login` varchar(255) NOT NULL,
  `kazna_obnul` int(11) NOT NULL,
  `bonys` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `clan_bonus`
--

CREATE TABLE IF NOT EXISTS `clan_bonus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_clan` int(11) NOT NULL,
  `stat` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `clan_journal`
--

CREATE TABLE IF NOT EXISTS `clan_journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_clan` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `clan_memb`
--

CREATE TABLE IF NOT EXISTS `clan_memb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_clan` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `clan_podzemelie`
--

CREATE TABLE IF NOT EXISTS `clan_podzemelie` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_clan` int(11) NOT NULL,
  `id_reid` int(11) NOT NULL,
  `id_boss` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  `start` int(11) NOT NULL DEFAULT '0',
  `boss_health` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `clan_podzemelie_log`
--

CREATE TABLE IF NOT EXISTS `clan_podzemelie_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_boss` int(11) NOT NULL,
  `user_ubit` int(11) NOT NULL DEFAULT '0',
  `boss_ubit` int(11) NOT NULL DEFAULT '0',
  `uron_user` int(11) NOT NULL,
  `uron_boss` int(11) NOT NULL,
  `tip` set('user','boss') NOT NULL,
  `krit` int(11) NOT NULL DEFAULT '0',
  `id_batlle` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `clan_podzemelie_reid`
--

CREATE TABLE IF NOT EXISTS `clan_podzemelie_reid` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `gold_user` int(11) NOT NULL DEFAULT '0',
  `gold_clan` int(11) NOT NULL DEFAULT '0',
  `clan_level` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Дамп данных таблицы `clan_podzemelie_reid`
--

INSERT INTO `clan_podzemelie_reid` (`id`, `name`, `gold_user`, `gold_clan`, `clan_level`) VALUES
(1, 'Рейд 1', 4, 50, 1),
(2, 'Рейд 2', 8, 100, 10),
(3, 'Рейд 3', 20, 500, 15),
(4, 'Рейд 4', 50, 1000, 25),
(5, 'Рейд 5', 70, 1500, 30);

--
-- Структура таблицы `clan_podzemelie_reid_boss`
--

CREATE TABLE IF NOT EXISTS `clan_podzemelie_reid_boss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `id_reid` set('1','2','3','4','5') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Дамп данных таблицы `clan_podzemelie_reid_boss`
--

INSERT INTO `clan_podzemelie_reid_boss` (`id`, `name`, `str`, `def`, `health`, `id_reid`) VALUES
(1, 'Огненный пес', 800, 800, 5000, '1,2,3,4,5'),
(2, 'Рыцарь смерти', 1000, 1000, 10000, '1,2,3,4,5'),
(3, 'Палач', 1200, 1200, 15000, '2,3,4,5'),
(4, 'Горгулья', 1500, 1500, 20000, '2,3,4,5'),
(5, 'Змий', 2000, 2000, 25000, '3,4,5'),
(6, 'Минотавр', 2500, 2500, 30000, '3,4,5'),
(7, 'Повелитель огня', 3000, 3000, 35000, '4,5'),
(8, 'Всадник апокалипсиса', 4200, 4200, 40000, '4,5'),
(9, 'Горлум', 4500, 4500, 45000, '5'),
(10, 'Варлорд', 5000, 5000, 60000, '5');

--
-- Структура таблицы `clan_podzemelie_users`
--

CREATE TABLE IF NOT EXISTS `clan_podzemelie_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `max_health` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `ubit` int(11) NOT NULL DEFAULT '0',
  `kamen` int(11) NOT NULL,
  `trava` int(11) NOT NULL,
  `nastroika` int(11) NOT NULL,
  `udar_last` int(11) NOT NULL,
  `id_batlle` int(11) NOT NULL,
  `end` int(11) NOT NULL DEFAULT '0',
  `urons` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `coliseum`
--

CREATE TABLE IF NOT EXISTS `coliseum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start` int(11) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `coliseum_log`
--

CREATE TABLE IF NOT EXISTS `coliseum_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `cel` int(11) NOT NULL,
  `ubit` int(11) NOT NULL DEFAULT '0',
  `uron` int(11) NOT NULL,
  `krit` int(11) NOT NULL DEFAULT '0',
  `id_batlle` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `coliseum_users`
--

CREATE TABLE IF NOT EXISTS `coliseum_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `max_health` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `ubit` int(11) NOT NULL DEFAULT '0',
  `time_ubit` int(11) NOT NULL DEFAULT '2147483647',
  `cel` int(11) NOT NULL DEFAULT '0',
  `kamen` int(11) NOT NULL,
  `trava` int(11) NOT NULL,
  `nastroika` int(11) NOT NULL,
  `uvorot` int(11) NOT NULL,
  `udar_last` int(11) NOT NULL,
  `id_batlle` int(11) NOT NULL,
  `end` int(11) NOT NULL DEFAULT '0',
  `ubito` int(11) NOT NULL DEFAULT '0',
  `urons` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `drakon`
--

CREATE TABLE IF NOT EXISTS `drakon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start` int(11) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL,
  `max_health` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `drakon_users`
--

CREATE TABLE IF NOT EXISTS `drakon_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `end` set('0','1') NOT NULL DEFAULT '0',
  `id_batlle` int(11) NOT NULL,
  `ubit` set('0','1') NOT NULL DEFAULT '0',
  `trava` int(11) NOT NULL DEFAULT '0',
  `kamen` int(11) NOT NULL DEFAULT '0',
  `udar_last` int(11) NOT NULL DEFAULT '0',
  `urons` int(11) NOT NULL DEFAULT '0',
  `health` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `duel`
--

CREATE TABLE IF NOT EXISTS `duel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opponent` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `start` int(11) NOT NULL,
  `opp_health` int(11) NOT NULL,
  `user_health` int(11) NOT NULL,
  `koll` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  `kamen` int(11) NOT NULL,
  `trava` int(11) NOT NULL,
  `udar_last` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `duel_log`
--

CREATE TABLE IF NOT EXISTS `duel_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uron` int(11) NOT NULL,
  `krit` set('0','1') NOT NULL DEFAULT '0',
  `tip` varchar(100) NOT NULL,
  `id_batle` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `effects`
--

CREATE TABLE IF NOT EXISTS `effects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sys_name` varchar(100) DEFAULT NULL,
  `last` int(11) DEFAULT '0',
  `on` int(11) DEFAULT '0',
  `def` int(11) DEFAULT '0',
  `health` int(11) DEFAULT '0',
  `id_user` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `farm`
--

CREATE TABLE IF NOT EXISTS `farm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  `trava_shance` int(11) NOT NULL DEFAULT '17',
  `kamen_shance` int(11) NOT NULL DEFAULT '17',
  `id_boss` int(11) NOT NULL DEFAULT '0',
  `start` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `farm_batlle`
--

CREATE TABLE IF NOT EXISTS `farm_batlle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_boss` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `boss_health` int(11) NOT NULL,
  `user_health` int(11) NOT NULL,
  `kamen` int(11) NOT NULL,
  `trava` int(11) NOT NULL,
  `udar_last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `farm_batlle_log`
--

CREATE TABLE IF NOT EXISTS `farm_batlle_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uron` int(11) NOT NULL,
  `krit` int(11) NOT NULL DEFAULT '0',
  `tip` varchar(100) NOT NULL,
  `id_batlle` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `forum`
--

CREATE TABLE IF NOT EXISTS `forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `access` set('0','1','2','') NOT NULL,
  `side` set('','good','evil') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Дамп данных таблицы `forum`
--

INSERT INTO `forum` (`id`, `name`, `access`, `side`) VALUES
(1, 'Новости игры', '2', ''),
(2, 'Разговоры тут', '0', ''),
(3, 'Предложения', '0', ''),
(4, 'Ошибки и баги', '0', ''),
(5, 'Помощь по игре', '0', ''),
(7, 'Кланы Добро', '0', 'good'),
(8, 'Кланы Зло', '0', 'evil'),
(9, 'Вопросы об оплате', '', '');

--
-- Структура таблицы `gold`
--

CREATE TABLE IF NOT EXISTS `gold` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `hp_mp`
--

CREATE TABLE IF NOT EXISTS `hp_mp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `inv`
--

CREATE TABLE IF NOT EXISTS `inv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `tip` set('golova','plechi','tors','perchatki','lev','prav','nogi','obuv') NOT NULL,
  `skill` int(11) NOT NULL,
  `odeta` set('da','net','','') NOT NULL,
  `name` varchar(100) NOT NULL,
  `item` varchar(100) NOT NULL,
  `smitch` int(11) NOT NULL DEFAULT '0',
  `smitch_shance` int(11) NOT NULL DEFAULT '80',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `item`
--

CREATE TABLE IF NOT EXISTS `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `id_komplekt` int(11) NOT NULL,
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `tip` set('golova','plechi','tors','perchatki','lev','prav','nogi','obuv') NOT NULL,
  `skill` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  `item` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=113 ;

--
-- Дамп данных таблицы `item`
--

INSERT INTO `item` (`id`, `name`, `id_komplekt`, `str`, `def`, `health`, `tip`, `skill`, `cena`, `item`) VALUES
(1, 'Шлем война', 1, 10, 10, 10, 'golova', 1, 10, 'voin'),
(2, 'Наплечник война', 1, 10, 10, 10, 'plechi', 1, 10, 'voin'),
(3, 'Броня война', 1, 10, 10, 10, 'tors', 1, 10, 'voin'),
(4, 'Перчатки война', 1, 10, 10, 10, 'perchatki', 1, 10, 'voin'),
(5, 'Щит война', 1, 10, 10, 10, 'lev', 1, 10, 'voin'),
(6, 'Меч война', 1, 10, 10, 10, 'prav', 1, 10, 'voin'),
(7, 'Штаны война', 1, 10, 10, 10, 'nogi', 1, 10, 'voin'),
(8, 'Сапоги война', 1, 10, 10, 10, 'obuv', 1, 10, 'voin'),
(9, 'Шлем ополченца', 2, 10, 10, 10, 'golova', 1, 10, 'opolchenec'),
(10, 'Наплечник ополченца', 2, 10, 10, 10, 'plechi', 1, 10, 'opolchenec'),
(11, 'Броня ополченца', 2, 10, 10, 10, 'tors', 1, 10, 'opolchenec'),
(12, 'Перчатки ополченца', 2, 10, 10, 10, 'perchatki', 1, 10, 'opolchenec'),
(13, 'Щит ополченца', 2, 10, 10, 10, 'lev', 1, 10, 'opolchenec'),
(14, 'Топор ополченца', 2, 10, 10, 10, 'prav', 1, 10, 'opolchenec'),
(15, 'Штаны ополченца', 2, 10, 10, 10, 'nogi', 1, 10, 'opolchenec'),
(16, 'Сапоги ополченца', 2, 10, 10, 10, 'obuv', 1, 10, 'opolchenec'),
(17, 'Шлем рыцаря', 3, 45, 45, 45, 'golova', 10, 30, 'rijzar'),
(18, 'Наплечник рыцаря', 3, 45, 45, 45, 'plechi', 10, 30, 'rijzar'),
(19, 'Броня рыцаря', 3, 45, 45, 45, 'tors', 10, 30, 'rijzar'),
(20, 'Перчатки рыцаря', 3, 45, 45, 45, 'perchatki', 10, 30, 'rijzar'),
(21, 'Щит рыцаря', 3, 45, 45, 45, 'lev', 10, 30, 'rijzar'),
(22, 'Топор рыцаря', 3, 45, 45, 45, 'prav', 10, 30, 'rijzar'),
(23, 'Штаны рыцаря', 3, 45, 45, 45, 'nogi', 10, 30, 'rijzar'),
(24, 'Сапоги рыцаря', 3, 45, 45, 45, 'obuv', 10, 30, 'rijzar'),
(25, 'Шлем Паладина', 4, 60, 60, 60, 'golova', 26, 90, 'paladin'),
(26, 'Наплечник Паладина', 4, 60, 60, 60, 'plechi', 26, 90, 'paladin'),
(27, 'Доспех Паладина', 4, 60, 60, 60, 'tors', 26, 90, 'paladin'),
(28, 'Перчатки Паладина', 4, 60, 60, 60, 'perchatki', 26, 90, 'paladin'),
(29, 'Щит Паладина', 4, 60, 60, 60, 'lev', 26, 90, 'paladin'),
(30, 'Молот Паладина', 4, 60, 60, 60, 'prav', 26, 90, 'paladin'),
(31, 'Штаны Паладина', 4, 60, 60, 60, 'nogi', 26, 90, 'paladin'),
(32, 'Сапоги Паладина', 4, 60, 60, 60, 'obuv', 26, 90, 'paladin'),
(33, 'Шлем полководца', 5, 100, 100, 100, 'golova', 48, 500, 'polkovodezj'),
(34, 'Наплечник полководца', 5, 100, 100, 100, 'plechi', 48, 500, 'polkovodezj'),
(35, 'Броня полководца', 5, 100, 100, 100, 'tors', 48, 500, 'polkovodezj'),
(36, 'Перчатки полководца', 5, 100, 100, 100, 'perchatki', 48, 500, 'polkovodezj'),
(37, 'Щит полководца', 5, 100, 100, 100, 'lev', 48, 500, 'polkovodezj'),
(38, 'Меч полководца', 5, 100, 100, 100, 'prav', 48, 500, 'polkovodezj'),
(39, 'Штаны полководца', 5, 100, 100, 100, 'nogi', 48, 500, 'polkovodezj'),
(40, 'Сапоги полководца', 5, 100, 100, 100, 'obuv', 48, 500, 'polkovodezj'),
(41, 'Шлем Избранного', 6, 170, 170, 170, 'golova', 100, 2000, 'izbran'),
(42, 'Наплечник Избранного', 6, 170, 170, 170, 'plechi', 100, 2000, 'izbran'),
(43, 'Доспех Избранного', 6, 170, 170, 170, 'tors', 100, 2000, 'izbran'),
(44, 'Перчатки Избранного', 6, 170, 170, 170, 'perchatki', 100, 2000, 'izbran'),
(45, 'Щит Избранного', 6, 170, 170, 170, 'lev', 100, 2000, 'izbran'),
(46, 'Секира Избранного', 6, 170, 170, 170, 'prav', 100, 2000, 'izbran'),
(47, 'Штаны Избранного', 6, 170, 170, 170, 'nogi', 100, 2000, 'izbran'),
(48, 'Сапоги Избранного', 6, 170, 170, 170, 'obuv', 100, 2000, 'izbran'),
(49, 'Капюшон Ассасина', 7, 45, 45, 45, 'golova', 10, 30, 'assasin'),
(50, 'Наплечник Ассасина', 7, 45, 45, 45, 'plechi', 10, 30, 'assasin'),
(51, 'Броня Ассасина', 7, 45, 45, 45, 'tors', 10, 30, 'assasin'),
(52, 'Перчатки Ассасина', 7, 45, 45, 45, 'perchatki', 10, 30, 'assasin'),
(53, 'Щит Ассасина', 7, 45, 45, 45, 'lev', 10, 30, 'assasin'),
(54, 'Клинок Ассасина', 7, 45, 45, 45, 'prav', 10, 30, 'assasin'),
(55, 'Штаны Ассасина', 7, 45, 45, 45, 'nogi', 10, 30, 'assasin'),
(56, 'Ботинки Ассасина', 7, 45, 45, 45, 'obuv', 10, 30, 'assasin'),
(57, 'Шлем Лучистого', 8, 60, 60, 60, 'golova', 26, 90, 'luz'),
(58, 'Наплетчики Лучистого', 8, 60, 60, 60, 'plechi', 26, 90, 'luz'),
(59, 'Броня Лучистого', 8, 60, 60, 60, 'tors', 26, 90, 'luz'),
(60, 'Перчатки Лучистого', 8, 60, 60, 60, 'perchatki', 26, 90, 'luz'),
(61, 'Щит Лучистого', 8, 60, 60, 60, 'lev', 26, 90, 'luz'),
(62, 'Меч Лучистого', 8, 60, 60, 60, 'prav', 26, 90, 'luz'),
(63, 'Штаны Лучистого', 8, 60, 60, 60, 'nogi', 26, 90, 'luz'),
(64, 'Сапоги Лучистого', 8, 60, 60, 60, 'obuv', 26, 90, 'luz'),
(65, 'Шлем искателя', 9, 45, 45, 45, 'golova', 10, 30, '1_5'),
(66, 'Наплечник искателя', 9, 45, 45, 45, 'plechi', 10, 30, '1_5'),
(67, 'Броня искателя', 9, 45, 45, 45, 'tors', 10, 30, '1_5'),
(68, 'Перчатки искателя', 9, 45, 45, 45, 'perchatki', 10, 30, '1_5'),
(69, 'Щит искателя', 9, 45, 45, 45, 'lev', 10, 30, '1_5'),
(70, 'Меч искателя', 9, 45, 45, 45, 'prav', 10, 30, '1_5'),
(71, 'Штаны искателя', 9, 45, 45, 45, 'nogi', 10, 30, '1_5'),
(72, 'Сапоги искателя', 9, 45, 45, 45, 'obuv', 10, 30, '1_5'),
(73, 'Шлем зверобоя', 10, 60, 60, 60, 'golova', 26, 90, '1_8'),
(74, 'Наплечник зверобоя', 10, 60, 60, 60, 'plechi', 26, 90, '1_8'),
(75, 'Броня зверобоя', 10, 60, 60, 60, 'tors', 26, 90, '1_8'),
(76, 'Перчатки зверобоя', 10, 60, 60, 60, 'perchatki', 26, 90, '1_8'),
(77, 'Щит зверобоя', 10, 60, 60, 60, 'lev', 26, 90, '1_8'),
(78, 'Меч зверобоя', 10, 60, 60, 60, 'prav', 26, 90, '1_8'),
(79, 'Штаны зверобоя', 10, 60, 60, 60, 'nogi', 26, 90, '1_8'),
(80, 'Сапоги зверобоя', 10, 60, 60, 60, 'obuv', 26, 90, '1_8'),
(81, 'Шлем атакера', 11, 100, 100, 100, 'golova', 48, 500, '1_10'),
(82, 'Наплечник атакера', 11, 100, 100, 100, 'plechi', 48, 500, '1_10'),
(83, 'Броня атакера', 11, 100, 100, 100, 'tors', 48, 500, '1_10'),
(84, 'Перчатки атакера', 11, 100, 100, 100, 'perchatki', 48, 500, '1_10'),
(85, 'Щит атакера', 11, 100, 100, 100, 'lev', 48, 500, '1_10'),
(86, 'Меч атакера', 11, 100, 100, 100, 'prav', 48, 500, '1_10'),
(87, 'Штаны атакера', 11, 100, 100, 100, 'nogi', 48, 500, '1_10'),
(88, 'Сапоги атакера', 11, 100, 100, 100, 'obuv', 48, 500, '1_10'),
(89, 'Шлем гладиатора', 12, 100, 100, 100, 'golova', 48, 500, '1_11'),
(90, 'Наплечник гладиатора', 12, 100, 100, 100, 'plechi', 48, 500, '1_11'),
(91, 'Броня гладиатора', 12, 100, 100, 100, 'tors', 48, 500, '1_11'),
(92, 'Перчатки гладиатора', 12, 100, 100, 100, 'perchatki', 48, 500, '1_11'),
(93, 'Щит гладиатора', 12, 100, 100, 100, 'lev', 48, 500, '1_11'),
(94, 'Меч гладиатора', 12, 100, 100, 100, 'prav', 48, 500, '1_11'),
(95, 'Штаны гладиатора', 12, 100, 100, 100, 'nogi', 48, 500, '1_11'),
(96, 'Сапоги гладиатора', 12, 100, 100, 100, 'obuv', 48, 500, '1_11'),
(97, 'Шлем мучителя', 13, 170, 170, 170, 'golova', 100, 2000, '1_13'),
(98, 'Наплечник мучителя', 13, 170, 170, 170, 'plechi', 100, 2000, '1_13'),
(99, 'Броня мучителя', 13, 170, 170, 170, 'tors', 100, 2000, '1_13'),
(100, 'Перчатки мучителя', 13, 170, 170, 170, 'perchatki', 100, 2000, '1_13'),
(101, 'Щит мучителя', 13, 170, 170, 170, 'lev', 100, 2000, '1_13'),
(102, 'Меч мучителя', 13, 170, 170, 170, 'prav', 100, 2000, '1_13'),
(103, 'Штаны мучителя', 13, 170, 170, 170, 'nogi', 100, 2000, '1_13'),
(104, 'Сапоги мучителя', 13, 170, 170, 170, 'obuv', 100, 2000, '1_13'),
(105, 'Шлем убийцы', 14, 170, 170, 170, 'golova', 100, 2000, '1_14'),
(106, 'Наплечник убийцы', 14, 170, 170, 170, 'plechi', 100, 2000, '1_14'),
(107, 'Броня убийцы', 14, 170, 170, 170, 'tors', 100, 2000, '1_14'),
(108, 'Перчатки убийцы', 14, 170, 170, 170, 'perchatki', 100, 2000, '1_14'),
(109, 'Щит убийцы', 14, 170, 170, 170, 'lev', 100, 2000, '1_14'),
(110, 'Меч убийцы', 14, 170, 170, 170, 'prav', 100, 2000, '1_14'),
(111, 'Штаны убийцы', 14, 170, 170, 170, 'nogi', 100, 2000, '1_14'),
(112, 'Сапоги убийцы', 14, 170, 170, 170, 'obuv', 100, 2000, '1_14');

--
-- Структура таблицы `komplekt`
--

CREATE TABLE IF NOT EXISTS `komplekt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `skill` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Дамп данных таблицы `komplekt`
--

INSERT INTO `komplekt` (`id`, `name`, `skill`) VALUES
(1, 'Комплект война', 1),
(2, 'Комплект ополченца', 1),
(3, 'Комплект рыцаря', 10),
(4, 'Комплект паладина', 26),
(5, 'Комплект полководца', 48),
(6, 'Комплект избранного', 100),
(7, 'Комплект ассасина', 10),
(8, 'Комплект Лучистого', 26),
(9, 'Комплект искателя', 10),
(10, 'Комплект зверобоя', 26),
(11, 'Комплект атакера', 48),
(12, 'Комплект гладиатора', 48),
(13, 'Комплект мучителя', 100),
(14, 'Комплект убийцы', 100);

--
-- Структура таблицы `kont`
--

CREATE TABLE IF NOT EXISTS `kont` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `limit_clan_kazna`
--

CREATE TABLE IF NOT EXISTS `limit_clan_kazna` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  `gold` int(11) NOT NULL,
  `crystals` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `l_ch`
--

CREATE TABLE IF NOT EXISTS `l_ch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_1` int(11) NOT NULL,
  `id_2` int(11) NOT NULL,
  `schet_1` int(11) NOT NULL,
  `schet_2` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `mail`
--

CREATE TABLE IF NOT EXISTS `mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `in` int(11) NOT NULL,
  `out` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `online` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `mertvec`
--

CREATE TABLE IF NOT EXISTS `mertvec` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start` int(11) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL,
  `kol_mertvec` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `mertvec_users`
--

CREATE TABLE IF NOT EXISTS `mertvec_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `end` set('0','1') NOT NULL DEFAULT '0',
  `id_batlle` int(11) NOT NULL,
  `ubit` set('0','1') NOT NULL DEFAULT '0',
  `trava` int(11) NOT NULL DEFAULT '0',
  `kamen` int(11) NOT NULL DEFAULT '0',
  `udar_last` int(11) NOT NULL DEFAULT '0',
  `urons` int(11) NOT NULL DEFAULT '0',
  `kol_mertvec` int(11) NOT NULL DEFAULT '0',
  `health` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `pits`
--

CREATE TABLE IF NOT EXISTS `pits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `item` varchar(100) NOT NULL,
  `cena` int(11) NOT NULL,
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Дамп данных таблицы `pits`
--

INSERT INTO `pits` (`id`, `name`, `item`, `cena`, `str`, `def`, `health`) VALUES
(1, 'Злобный паучек', '01', 250, 100, 100, 100),
(2, 'Оборотень', '02', 250, 100, 100, 100),
(3, 'Высший волк', '03', 250, 100, 100, 100),
(4, 'Пантера', '04', 250, 100, 100, 100),
(5, 'Дикий', '05', 250, 100, 100, 100),
(6, 'Шакал', '06', 250, 100, 100, 100);

--
-- Структура таблицы `pit_users`
--

CREATE TABLE IF NOT EXISTS `pit_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `id_user` int(11) NOT NULL,
  `level` int(11) NOT NULL DEFAULT '1',
  `str` int(11) NOT NULL,
  `def` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `item` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `quest`
--

CREATE TABLE IF NOT EXISTS `quest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `koll` int(11) NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `gold` int(11) NOT NULL DEFAULT '0',
  `crystals` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Дамп данных таблицы `quest`
--

INSERT INTO `quest` (`id`, `name`, `koll`, `text`, `gold`, `crystals`) VALUES
(1, 'Боец арены', 10, 'Проведи 10 боев на арене!', 2, 134),
(2, 'Гладиатор арены', 15, 'Победи 15 раз на арене!', 3, 245),
(3, 'Охотник за властью', 3000, 'Нанеси 3000 урона в битве за власть!', 2, 679),
(4, 'Воин дуэлей ', 15, 'Проведи 15 боев в дуэлях!', 3, 456),
(5, 'Гладиатор дуэлей', 10, 'Победи 10 врагов в дуэлях!', 3, 564),
(8, 'Защитник земель', 700, 'Почени захваченные земли на 700 жизней!', 4, 896),
(9, 'Гроза мертвых', 5, 'Убей 5 мертвецов в долине мертвецов!', 3, 156),
(10, 'Секрет золота', 400, 'Купи 400 золота через любую систему оплаты', 200, 678),
(11, 'Гладиатор колизея', 5, 'Проведи 5 боев в колизее!', 6, 874);

--
-- Структура таблицы `quest_user`
--

CREATE TABLE IF NOT EXISTS `quest_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_quest` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `koll` int(11) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL,
  `max_koll` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `ten`
--

CREATE TABLE IF NOT EXISTS `ten` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `ticket`
--

CREATE TABLE IF NOT EXISTS `ticket` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `tip` varchar(250) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `status` set('close','otckrit') NOT NULL DEFAULT 'otckrit',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `ticket_msg`
--

CREATE TABLE IF NOT EXISTS `ticket_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ticket` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `onlick` set('0','1') NOT NULL DEFAULT '1',
  `tip` set('user','admin') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `time_bashna`
--

CREATE TABLE IF NOT EXISTS `time_bashna` (
  `id` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL,
  `id_bashna` int(11) NOT NULL,
  `tipe` set('remont','attaka','attaka_user','') NOT NULL,
  `last` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Структура таблицы `topic`
--

CREATE TABLE IF NOT EXISTS `topic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `top` set('0','1','','') NOT NULL DEFAULT '0',
  `close` set('0','1','','') NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `onlick` int(11) NOT NULL,
  `sett_time` int(11) NOT NULL,
  `sett_user` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `topic_msg`
--

CREATE TABLE IF NOT EXISTS `topic_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_topic` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `turnir_chereps`
--

CREATE TABLE IF NOT EXISTS `turnir_chereps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` int(11) NOT NULL,
  `start` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_playrum` int(11) NOT NULL,
  `ip` varchar(100) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `sex` set('w','m') NOT NULL DEFAULT 'm',
  `registr` int(11) NOT NULL,
  `access` set('0','1','2','') NOT NULL DEFAULT '0',
  `health` int(11) NOT NULL DEFAULT '100',
  `energy` int(11) NOT NULL DEFAULT '100',
  `max_health` int(11) NOT NULL DEFAULT '450',
  `max_energy` int(11) NOT NULL DEFAULT '500',
  `level` int(11) NOT NULL DEFAULT '1',
  `exp` int(11) NOT NULL DEFAULT '0',
  `gold` int(11) NOT NULL DEFAULT '0',
  `crystals` int(11) NOT NULL DEFAULT '0',
  `side` set('good','evil') NOT NULL DEFAULT 'evil',
  `str` int(11) NOT NULL DEFAULT '10',
  `def` int(11) NOT NULL DEFAULT '10',
  `krit` decimal(11,2) NOT NULL DEFAULT '1.00',
  `skill` int(11) NOT NULL DEFAULT '0',
  `_str` int(11) NOT NULL DEFAULT '0',
  `_def` int(11) NOT NULL DEFAULT '0',
  `_health` int(11) NOT NULL DEFAULT '0',
  `_energy` int(11) NOT NULL DEFAULT '0',
  `_krit` int(11) NOT NULL DEFAULT '0',
  `online` int(11) NOT NULL,
  `save` int(11) NOT NULL DEFAULT '0',
  `news_read` int(11) NOT NULL DEFAULT '0',
  `id_partner` int(11) NOT NULL DEFAULT '0',
  `fix_mesto` text NOT NULL,
  `fix_url` text NOT NULL,
  `koll_gold` int(11) NOT NULL,
  `id_clan` int(11) NOT NULL DEFAULT '0',
  `clan_exp` int(11) NOT NULL DEFAULT '0',
  `clan_exp_24` int(11) NOT NULL DEFAULT '0',
  `clan_exp_48` int(11) NOT NULL DEFAULT '0',
  `clan_exp_72` int(11) NOT NULL DEFAULT '0',
  `clan_rang` int(11) NOT NULL DEFAULT '1',
  `clan_gold` int(11) NOT NULL DEFAULT '0',
  `clan_crystals` int(11) NOT NULL DEFAULT '0',
  `kamen` int(11) NOT NULL DEFAULT '0',
  `trava` int(11) NOT NULL DEFAULT '0',
  `auction` int(11) NOT NULL DEFAULT '0',
  `limit_clan_gold` int(11) NOT NULL DEFAULT '3',
  `limit_clan_crystals` int(11) NOT NULL DEFAULT '300',
  `clan_chat_read` set('0','1') NOT NULL DEFAULT '0',
  `vstup` int(11) NOT NULL,
  `ct_clan` int(11) DEFAULT '0',
  `ob_read` set('1','0') NOT NULL DEFAULT '0',
  `oformlenie` set('link','btn-blue','btn','greens','sin','purs') NOT NULL DEFAULT 'link',
  `clan_off` set('0','1') NOT NULL DEFAULT '0',
  `ten_koll` int(11) NOT NULL DEFAULT '0',
  `clan_jourlan_read` set('0','1') NOT NULL DEFAULT '0',
  `browser` varchar(255) NOT NULL,
  `coliseum_rating` int(11) NOT NULL DEFAULT '0',
  `chereps` int(11) NOT NULL DEFAULT '0',
  `bot` set('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `wapkassa`
--

CREATE TABLE IF NOT EXISTS `wapkassa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `summa` decimal(11,2) NOT NULL DEFAULT '0.00',
  `num` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_oplata` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `webmoney`
--

CREATE TABLE IF NOT EXISTS `webmoney` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `summa` decimal(11,2) NOT NULL DEFAULT '0.00',
  `num` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_oplata` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Структура таблицы `worldkassa`
--

CREATE TABLE IF NOT EXISTS `worldkassa` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID платежа (Внутренний ID)',
  `id_user` int(11) unsigned NOT NULL COMMENT 'ID пользователя',
  `id_bill` int(11) unsigned NOT NULL COMMENT 'ID платежа в Worldkassa',
  `time` int(11) unsigned NOT NULL COMMENT 'Время инициализации платежа',
  `time_oplata` int(11) unsigned DEFAULT '0' COMMENT 'Время оплаты',
  `summa` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT 'Сумма',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Статистика платежей через WorldKassa' AUTO_INCREMENT=1 ;