﻿<?php
class TopCommand extends CConsoleCommand {
    public function run($args) {
        Yii::app()->db->createCommand()->truncateTable(Top::model()->tableName());
        //Рейтинг по игроков сумме статов
		$criteria = new CDbCriteria();
        $criteria->select = array('t.id_user', 
            'IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.strength+items.enchant_strength)*(100+t.guild_buff)/100)+t.strength, 
			SUM(items.strength+items.enchant_strength)+t.strength) + 
			IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.health+items.enchant_health)*(100+t.guild_buff)/100)+t.health, 
			SUM(items.health+items.enchant_health)+t.health) + 
			IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.energy+items.enchant_energy)*(100+t.guild_buff)/100)+t.energy, 
			SUM(items.energy+items.enchant_energy)+t.energy) + 
			IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.regeneration+items.enchant_regeneration)*(100+t.guild_buff)/100)+t.regeneration, 
			SUM(items.regeneration+items.enchant_regeneration)+t.regeneration) + 
			IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.armor+items.enchant_armor)*(100+t.guild_buff)/100)+t.armor, 
			SUM(items.armor+items.enchant_armor)+t.armor) as totalSummary'
        );
        $criteria->with = array('items');
        $criteria->together = true;
        $criteria->addNotInCondition('t.id_role', array(5, 6));
        $criteria->addCondition('items.status = 0 AND items.hardness > 0');
        $criteria->group = 't.id_user';
		$criteria->order = 'totalSummary DESC';
		$criteria->limit = 50;
        $result = Users::model()->findAll($criteria);
        foreach ($result as $user) {
            $top = new Top();
            $top->type = 1;
            $top->id_user = $user->id_user;
            $top->value = $user->totalSummary;
            $top->save();
        }
        //Рейтинг по игроков силе
		$criteria = new CDbCriteria();
        $criteria->select = array('t.id_user', 
            'IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.strength+items.enchant_strength)*(100+t.guild_buff)/100)+t.strength, 
			SUM(items.strength+items.enchant_strength)+t.strength
			) as totalStrength'
        );
        $criteria->with = array('items');
        $criteria->together = true;
        $criteria->addNotInCondition('t.id_role', array(5, 6));
        $criteria->addCondition('items.status = 0 AND items.hardness > 0');
        $criteria->group = 't.id_user';
		$criteria->order = 'totalStrength DESC';
		$criteria->limit = 50;
        $result = Users::model()->findAll($criteria);
        foreach ($result as $user) {
            $top = new Top();
            $top->type = 2;
            $top->id_user = $user->id_user;
            $top->value = $user->totalStrength;
            $top->save();
        }
        //Рейтинг по игроков жизням
		$criteria = new CDbCriteria();
        $criteria->select = array('t.id_user', 
            'IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.health+items.enchant_health)*(100+t.guild_buff)/100)+t.health, 
			SUM(items.health+items.enchant_health)+t.health
		) as totalHealth'
        );
        $criteria->with = array('items');
        $criteria->together = true;
        $criteria->addNotInCondition('t.id_role', array(5, 6));
        $criteria->addCondition('items.status = 0 AND items.hardness > 0');
        $criteria->group = 't.id_user';
		$criteria->order = 'totalHealth DESC';
		$criteria->limit = 50;
        $result = Users::model()->findAll($criteria);
        foreach ($result as $user) {
            $top = new Top();
            $top->type = 3;
            $top->id_user = $user->id_user;
            $top->value = $user->totalHealth;
            $top->save();
        }
        //Рейтинг по игроков энергии
		$criteria = new CDbCriteria();
        $criteria->select = array('t.id_user', 
            'IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.energy+items.enchant_energy)*(100+t.guild_buff)/100)+t.energy, 
			SUM(items.energy+items.enchant_energy)+t.energy
		) as totalEnergy'
        );
        $criteria->with = array('items');
        $criteria->together = true;
        $criteria->addNotInCondition('t.id_role', array(5, 6));
        $criteria->addCondition('items.status = 0 AND items.hardness > 0');
        $criteria->group = 't.id_user';
		$criteria->order = 'totalEnergy DESC';
		$criteria->limit = 50;
        $result = Users::model()->findAll($criteria);
        foreach ($result as $user) {
            $top = new Top();
            $top->type = 4;
            $top->id_user = $user->id_user;
            $top->value = $user->totalEnergy;
            $top->save();
        }
        //Рейтинг по игроков регену
		$criteria = new CDbCriteria();
        $criteria->select = array('t.id_user', 
            'IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.regeneration+items.enchant_regeneration)*(100+t.guild_buff)/100)+t.regeneration, 
			SUM(items.regeneration+items.enchant_regeneration)+t.regeneration
		) as totalRegeneration'
        );
        $criteria->with = array('items');
        $criteria->together = true;
        $criteria->addNotInCondition('t.id_role', array(5, 6));
        $criteria->addCondition('items.status = 0 AND items.hardness > 0');
        $criteria->group = 't.id_user';
		$criteria->order = 'totalRegeneration DESC';
		$criteria->limit = 50;
        $result = Users::model()->findAll($criteria);
        foreach ($result as $user) {
            $top = new Top();
            $top->type = 5;
            $top->id_user = $user->id_user;
            $top->value = $user->totalRegeneration;
            $top->save();
        }
        //Рейтинг по игроков защите
		$criteria = new CDbCriteria();
        $criteria->select = array('t.id_user', 
            'IF (t.premium_time > unix_timestamp(NOW()), 50, 0) + IF (t.guild_buff_time > unix_timestamp(NOW()), 
			ROUND(SUM(items.armor+items.enchant_armor)*(100+t.guild_buff)/100)+t.armor, 
			SUM(items.armor+items.enchant_armor)+t.armor
		) as totalArmor'
        );
        $criteria->with = array('items');
        $criteria->together = true;
        $criteria->addNotInCondition('t.id_role', array(5, 6));
        $criteria->addCondition('items.status = 0 AND items.hardness > 0');
        $criteria->group = 't.id_user';
		$criteria->order = 'totalArmor DESC';
		$criteria->limit = 50;
        $result = Users::model()->findAll($criteria);
        foreach ($result as $user) {
            $top = new Top();
            $top->type = 6;
            $top->id_user = $user->id_user;
            $top->value = $user->totalArmor;
            $top->save();
        }

        //Рейтинг гильдий по уровню
        $criteria = new CDbCriteria();
        $criteria->select = array('id_guild', 'level');
        $criteria->order = 'level DESC';
        $criteria->limit = 50;
        $guilds = Guilds::model()->findAll($criteria);
        foreach ($guilds as $guild) {
            $top = new Top();
            $top->type = 7;
            $top->id_user = $guild->id_guild;
            $top->value = $guild->level;
            $top->save();
        }
    }
}

