<?php

namespace Worldcms;

use Worldcms\Classes\Router\DispatchedRoute;
use Worldcms\Helper\Common;

class Worldcms {

    /**
     * @var
     */

    private $di;

    /**
     * @var
     */

    public $router;

    /**
     * Worldcms constructor.
     * @param $di
     */

    public function __construct($di) {
        $this->di = $di;
        $this->router = $this->di->get('router');
    }

    /**
     *
     */

    public function run() {
        try {
            # Подключаем роутеры
            require __DIR__ . '/../manager/Routes.php';
            #
            $routerDispatch = $this->router->dispatch(Common::getMethod(), Common::getPathUrl());
            # Проверка на ошибку! 404
            if ($routerDispatch == null) {
                $routerDispatch = new DispatchedRoute('ErrorController:page404');
            }
            #
            list($class, $action) = explode(':', $routerDispatch->getController(), 2);
            #
            $controller = '\\Manager\\Controller\\' . $class;
            $parameters = $routerDispatch->getParameters();
            call_user_func_array([new $controller($this->di), $action], $parameters);

        }catch (\Exception $e) {
            $e->getMessage();
            exit;
        }
    }
}
