<?php

namespace Worldcms\Classes\Template;

use Worldcms\Classes\Template\Theme;

class View {

    /**
     * @var \Worldcms\Classes\Template\Theme
     */

    protected $theme;

    /**
     * View constructor.
     */

    public function __construct() {
        $this->theme = new Theme();
    }

    /**
     * @param $template
     * @param array $vars
     * @throws \Exception
     */

    public function render($template, $vars = []) {
    	
    	# Патч на папку с темой!
        $templatePath = ROOT_DIR . '/content/themes/default/' . $template . '.php';
        
        # Проверка на существования файла!
        if(!is_file($templatePath)) {
        	# Выводим ошибку в виде исключения
            throw new \InvalidArgumentException(
                sprintf('Template "%s" not found in "%s"', $template, $templatePath)
            );
        }

        $this->theme->setData($vars);
        extract($vars);
        
        # Включаем буферизацию.
        # ob_start();  -Включить-
        ob_implicit_flush(0);
        
        # Исключения 
        try {
        	# Подключаем шаблон
            require $templatePath;
        } catch (\Exception $e) {
        	# Очистка буфера
            ob_end_clean();
            throw $e;
        }
        
        # Содержиое текучего буфера
        echo ob_end_clean();

    }
}
