<?php

require __DIR__ . '/../vendor/autoload.php';

use Worldcms\Worldcms;
use Worldcms\Relation\DI;

try{
    # Dependency injection
    $di = new DI();
    $services =  require __DIR__ . '/Config/Service.php';

    # Init Service
    foreach ($services as $service) {
        $provider = new $service($di);
        $provider -> init();
    }

    $worldcms = new Worldcms($di);
    $worldcms -> run();

}catch(\ErrorException $e) {
    echo $e -> getMessage();
}
