<?php

namespace Worldcms;

use Worldcms\Helper\Common;

class Worldcms {

    private $di;
    public $router;

    public function __construct($di) {
        $this->di = $di;
        $this->router = $this -> di -> get('router');
    }

    public function run() {
        $this->router->add('main', '/', 'MainController:index');
        $this->router->add('news', '/news', 'MainController:news');

    	$routerDispatch = $this->router->dispatch(Common::getMethod(), Common::getPathUrl());

    	list($class, $action) = explode(':', $routerDispatch->getController(), 2);

    	$controller = '\\Manager\\Controller\\' . $class;

        call_user_func_array([new $controller($this->di), $action], $routerDispatch->getParameters());

    	//print_r($routerDispatch);
    }
}
