<?php

namespace Engine\Classes\Database;

use \PDO;

class Connection {
    private $link;

    /**
     * Connection constructor.
     */

    public function __construct() {
        $this->connect();
    }

    /**
     * @return $this
     */

    public function connect() {

        $config = [
            'db_host' => 'localhost',
            'db_name' => 'localhost',
            'db_user' => 'root',
            'db_pass' => '',
            'charset' => 'utf8'
        ];

        $dsn = 'mysql:host='.$config['db_host'].';dbname='.$config['db_name'].';charset='.$config['charset'];
        $this->link = new PDO($dsn, $config['db_user'], $config['db_pass']);
        return $this;
    }

    /**
     * @param $sql
     * @return mixed
     */

    public function execute($sql) {
        $sth = $this->link->prepare($sql);
        return $sth->execute();
    }

    /**
     * @return array
     */

    public function query() {
        $sth = $this->link->prepare($sql);
        $sth->execute();
        $result = $exe->fetchAll(PDO::FETCH_ASSOC);
        if ($result === false) {
            return[];
        }
        return $result;
    }
}
